/*
 * Decompiled with CFR 0.152.
 */
package com.fusesource.ide.fabric.camel;

import com.fusesource.ide.fabric.FabricPlugin;
import com.fusesource.ide.fabric.camel.FabricCamelAdapterFactory;
import com.fusesource.ide.fabric.camel.navigator.CamelNodeProvider;
import com.fusesource.ide.fabric.camel.navigator.CamelPreferenceInitializer;
import com.fusesource.ide.jmx.core.JMXActivator;
import com.fusesource.ide.jmx.core.tree.NodeProvider;
import com.fusesource.rider.commons.logging.RiderLogFacade;
import com.fusesource.rider.commons.ui.ImagesActivatorSupport;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.Platform;
import org.osgi.framework.BundleContext;

public class FabricCamelPlugin
extends ImagesActivatorSupport {
    private static FabricCamelPlugin plugin;
    private static CamelNodeProvider nodeProvider;
    private static IAdapterFactory adapterFactory;
    private static AtomicBoolean started;

    static {
        started = new AtomicBoolean(false);
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
        FabricCamelPlugin.registerPlugins();
    }

    public void stop(BundleContext context) throws Exception {
        FabricCamelPlugin.unregisterPlugins();
        plugin = null;
        super.stop(context);
    }

    public static void registerPlugins() {
        if (started.compareAndSet(false, true)) {
            Class[] classses;
            new CamelPreferenceInitializer().initializeDefaultPreferences();
            nodeProvider = new CamelNodeProvider();
            adapterFactory = new FabricCamelAdapterFactory();
            Class[] classArray = classses = adapterFactory.getAdapterList();
            int n = classses.length;
            int n2 = 0;
            while (n2 < n) {
                Class clazz = classArray[n2];
                Platform.getAdapterManager().registerAdapters(adapterFactory, clazz);
                ++n2;
            }
            FabricPlugin.addNodeProvider((com.fusesource.ide.fabric.navigator.NodeProvider)nodeProvider);
            JMXActivator.addNodeProvider((NodeProvider)nodeProvider);
        }
    }

    public static void unregisterPlugins() {
        Class[] classses;
        if (nodeProvider != null) {
            JMXActivator.removeNodeProvider((NodeProvider)nodeProvider);
            FabricPlugin.removeNodeProvider((com.fusesource.ide.fabric.navigator.NodeProvider)nodeProvider);
        }
        Class[] classArray = classses = adapterFactory.getAdapterList();
        int n = classses.length;
        int n2 = 0;
        while (n2 < n) {
            Class clazz = classArray[n2];
            Platform.getAdapterManager().unregisterAdapters(adapterFactory, clazz);
            ++n2;
        }
        started.set(false);
    }

    public static FabricCamelPlugin getDefault() {
        return plugin;
    }

    public static RiderLogFacade getLogger() {
        return RiderLogFacade.getLog((ILog)FabricCamelPlugin.getDefault().getLog());
    }
}

