/*
 * Decompiled with CFR 0.152.
 */
package com.fusesource.ide.fabric.camel.navigator;

import com.fusesource.ide.fabric.camel.FabricCamelPlugin;
import com.fusesource.ide.fabric.camel.navigator.CamelContextNode;
import com.fusesource.ide.fabric.camel.navigator.stats.model.CamelContextStatistics;
import com.fusesource.ide.fabric.camel.navigator.stats.model.IProcessorStatistics;
import com.fusesource.ide.fabric.camel.navigator.stats.model.ProcessorStatistics;
import com.fusesource.ide.fabric.camel.navigator.stats.model.RouteStatistics;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Unmarshaller;
import org.fusesource.fon.util.messages.NodeStatisticsContainer;

public class CachingCamelContextNodeStatisticsContainer
implements NodeStatisticsContainer {
    private static final long THROTTLE_MILLIS = 300L;
    private final CamelContextNode camelContextNode;
    private long lastRequestTime = 0L;
    private Map<String, IProcessorStatistics> cache = new HashMap<String, IProcessorStatistics>();

    public CachingCamelContextNodeStatisticsContainer(CamelContextNode camelContextNode) {
        this.camelContextNode = camelContextNode;
    }

    public IProcessorStatistics getNodeStats(String nodeId) {
        if (this.shouldQuery()) {
            String managementName = this.camelContextNode.getManagementName();
            try {
                ArrayList<RouteStatistics> routeStatisticsList;
                CamelContextStatistics stats;
                String xml = this.camelContextNode.getFacade().dumpRoutesStatsAsXml(managementName);
                if (xml != null && (xml = xml.trim()).length() > 0 && (stats = this.getStatistics(xml)) != null && (routeStatisticsList = stats.getRouteStatisticsList()) != null) {
                    HashMap<String, IProcessorStatistics> map = new HashMap<String, IProcessorStatistics>();
                    for (RouteStatistics stat : routeStatisticsList) {
                        String id = stat.getId();
                        map.put(id, stat);
                        ArrayList<ProcessorStatistics> procStats = stat.getProcessorStatisticsList();
                        if (procStats == null) continue;
                        for (ProcessorStatistics procStat : procStats) {
                            map.put(procStat.getId(), procStat);
                        }
                    }
                    this.cache = map;
                }
            }
            catch (Exception e) {
                FabricCamelPlugin.getLogger().error("Failed to query the JMX statistics of Camel: " + managementName, (Throwable)e);
            }
        }
        return this.cache.get(nodeId);
    }

    private CamelContextStatistics getStatistics(String xmlDump) {
        System.err.println("CamelContextNode.getStatistics() called...");
        CamelContextStatistics stats = null;
        try {
            JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{CamelContextStatistics.class, RouteStatistics.class, ProcessorStatistics.class});
            Unmarshaller um = context.createUnmarshaller();
            stats = (CamelContextStatistics)um.unmarshal((Reader)new StringReader(xmlDump));
        }
        catch (Exception exception) {
            stats = null;
            System.err.println("Error retrieving the statistics for camel context: " + this.camelContextNode.getContextId());
        }
        return stats;
    }

    protected boolean shouldQuery() {
        long now = System.currentTimeMillis();
        long delta = now - this.lastRequestTime;
        this.lastRequestTime = now;
        return delta > 300L || this.cache.isEmpty();
    }
}

