/*
 * Decompiled with CFR 0.152.
 */
package com.fusesource.ide.fabric.camel.navigator;

import com.fusesource.fmc.camel.facade.CamelFacade;
import com.fusesource.fmc.camel.facade.mbean.CamelContextMBean;
import com.fusesource.fmc.camel.facade.mbean.CamelFabricTracerMBean;
import com.fusesource.fmc.camel.facade.mbean.CamelProcessorMBean;
import com.fusesource.ide.fabric.FabricPlugin;
import com.fusesource.ide.fabric.camel.Messages;
import com.fusesource.ide.fabric.camel.editor.CamelContextNodeEditorInput;
import com.fusesource.ide.fabric.camel.navigator.CachingCamelContextNodeStatisticsContainer;
import com.fusesource.ide.fabric.camel.navigator.CamelContextsNode;
import com.fusesource.ide.fabric.camel.navigator.CamelFacades;
import com.fusesource.ide.fabric.camel.navigator.EndpointsNode;
import com.fusesource.ide.fabric.camel.navigator.ProcessorBeanView;
import com.fusesource.ide.fabric.camel.navigator.RoutesNode;
import com.fusesource.ide.fabric.camel.navigator.TraceExchangeList;
import com.fusesource.ide.jmx.ui.internal.views.navigator.ContextMenuProvider;
import com.fusesource.rider.commons.tree.Node;
import com.fusesource.rider.commons.tree.NodeSupport;
import com.fusesource.rider.commons.tree.Refreshable;
import com.fusesource.rider.commons.ui.ImageProvider;
import com.fusesource.rider.commons.ui.Workbenches;
import com.fusesource.rider.commons.util.Function1;
import com.fusesource.rider.commons.util.Objects;
import com.fusesource.rider.model.AbstractNode;
import com.fusesource.rider.model.AbstractNodeFacade;
import com.fusesource.rider.model.Activator;
import com.fusesource.rider.model.RouteContainer;
import com.fusesource.rider.model.io.XmlContainerMarshaller;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.camel.RuntimeCamelException;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.fusesource.fon.util.messages.IExchange;
import org.fusesource.fon.util.messages.IMessage;
import org.fusesource.fon.util.messages.ITraceExchangeBrowser;
import org.fusesource.fon.util.messages.ITraceExchangeList;
import org.fusesource.fon.util.messages.NodeStatisticsContainer;

public class CamelContextNode
extends NodeSupport
implements Refreshable,
AbstractNodeFacade,
ContextMenuProvider,
ITraceExchangeBrowser,
ImageProvider {
    public static final String CAMEL_EDITOR_ID = "com.fusesource.rider.plugin.editor";
    private final CamelContextsNode camelContextsNode;
    private final CamelFacade facade;
    private final CamelContextMBean camelContextMBean;
    private XmlContainerMarshaller marshaller = new XmlContainerMarshaller();
    private final RoutesNode routes;
    private Map<String, TraceExchangeList> traceMessageMap = new ConcurrentHashMap<String, TraceExchangeList>();
    private NodeStatisticsContainer runtimeNodeStatisticsContainer;

    public CamelContextNode(CamelContextsNode camelContextsNode, CamelFacade facade, CamelContextMBean camelContext) throws Exception {
        super((Node)camelContextsNode);
        this.camelContextsNode = camelContextsNode;
        this.facade = facade;
        this.camelContextMBean = camelContext;
        this.routes = new RoutesNode(this);
        this.addChild((Node)this.routes);
        this.addChild((Node)new EndpointsNode(this));
        this.setPropertyBean(camelContext);
    }

    public String toString() {
        return this.getContextId();
    }

    public void refresh() {
        if (this.getParent() instanceof Refreshable) {
            Refreshable refreshable = (Refreshable)this.getParent();
            refreshable.refresh();
        }
    }

    public CamelContextsNode getCamelContextsNode() {
        return this.camelContextsNode;
    }

    public String getContextId() {
        return this.camelContextMBean.getCamelId();
    }

    public String getManagementName() {
        return this.camelContextMBean.getManagementName();
    }

    public CamelFacade getFacade() {
        return this.facade;
    }

    public CamelContextMBean getCamelContextMBean() {
        return this.camelContextMBean;
    }

    public String getXmlString() {
        return this.camelContextMBean.dumpRoutesAsXml();
    }

    public RouteContainer getModelContainer() {
        String xml = this.getXmlText();
        return this.marshaller.loadRoutesFromText(xml);
    }

    public String getXmlText() {
        String routeElement;
        String xml = this.getXmlString();
        if (!xml.contains("<camelContext") && xml.contains(routeElement = "<routes")) {
            xml = xml.replace(routeElement, "<camelContext").replace("</routes>", "</camelContext>");
        }
        return xml;
    }

    public void updateXml(String xml) {
        this.camelContextMBean.addOrUpdateRoutesFromXml(xml);
        this.refresh();
    }

    public AbstractNode getAbstractNode() {
        return this.getRoutes().getAbstractNode();
    }

    public XmlContainerMarshaller getMarshaller() {
        return this.marshaller;
    }

    public void setMarshaller(XmlContainerMarshaller marshaller) {
        this.marshaller = marshaller;
    }

    public RoutesNode getRoutes() {
        return this.routes;
    }

    public boolean isTracing() {
        return this.getTracer() != null && this.getTracer().isEnabled();
    }

    public void send(String endpointUri, IMessage message) {
        Object body = message.getBody();
        Map headers = message.getHeaders();
        this.getCamelContextMBean().sendBodyAndHeaders(endpointUri, body, headers);
        this.reloadRoutes();
    }

    public void startTracing() {
        try {
            this.getTracer().setEnabled(true);
            this.reloadRoutes();
        }
        catch (Exception e) {
            FabricPlugin.showUserError((String)"Failed to start tracing", (String)("Failed to start tracing context " + (Object)((Object)this)), (Exception)e);
        }
    }

    protected void reloadRoutes() {
        this.routes.refresh();
    }

    public void stopTracing() {
        this.getTracer().setEnabled(false);
        this.traceMessageMap.clear();
    }

    public void editRoutes() {
        IWorkbenchPage page = Workbenches.getActiveWorkbenchPage();
        if (page == null) {
            Activator.getLogger().warning("No active page!");
        } else {
            CamelContextNodeEditorInput input = new CamelContextNodeEditorInput(this);
            try {
                page.openEditor((IEditorInput)input, CAMEL_EDITOR_ID, true);
            }
            catch (PartInitException e) {
                Activator.getLogger().warning("Could not open editor: com.fusesource.rider.plugin.editor. Reason: " + (Object)((Object)e), (Throwable)e);
            }
        }
    }

    public void provideContextMenu(IMenuManager menu) {
        this.provideContextMenu(menu, null);
    }

    public void provideContextMenu(IMenuManager menu, Function1<IMenuManager, Void> fn) {
        Action editAction = new Action(Messages.EditRoutesAction, 32){

            public void run() {
                CamelContextNode.this.editRoutes();
            }
        };
        editAction.setToolTipText(Messages.EditRoutesActionToolTip);
        editAction.setImageDescriptor(FabricPlugin.getDefault().getImageDescriptor("open.gif"));
        menu.add((IAction)editAction);
        if (fn != null) {
            fn.apply((Object)menu);
        } else {
            Action traceAction;
            if (this.isMbeanSuspended()) {
                traceAction = new Action(Messages.ResumeCamelContextAction, 32){

                    public void run() {
                        CamelContextNode.this.resumeMBean();
                    }
                };
                traceAction.setToolTipText(Messages.ResumeCamelContextActionToolTip);
                traceAction.setImageDescriptor(FabricPlugin.getDefault().getImageDescriptor("start_task.gif"));
                menu.add((IAction)traceAction);
            } else {
                traceAction = new Action(Messages.SuspendCamelContextAction, 32){

                    public void run() {
                        CamelContextNode.this.suspendMBean();
                    }
                };
                traceAction.setToolTipText(Messages.SuspendCamelContextActionToolTip);
                traceAction.setImageDescriptor(FabricPlugin.getDefault().getImageDescriptor("stop_task.gif"));
                menu.add((IAction)traceAction);
            }
            traceAction = new Action(Messages.StopCamelContextAction, 32){

                public void run() {
                    CamelContextNode.this.stopMBean();
                }
            };
            traceAction.setToolTipText(Messages.StopCamelContextActionToolTip);
            traceAction.setImageDescriptor(FabricPlugin.getDefault().getImageDescriptor("delete.gif"));
            menu.add((IAction)traceAction);
        }
        if (this.canTrace()) {
            menu.add((IContributionItem)new Separator());
            boolean tracing = this.isTracing();
            if (tracing) {
                Action traceAction = new Action(Messages.StopTraceAction, 32){

                    public void run() {
                        CamelContextNode.this.stopTracing();
                    }
                };
                traceAction.setToolTipText(Messages.StopTraceActionToolTip);
                traceAction.setImageDescriptor(FabricPlugin.getDefault().getImageDescriptor("stop_listening.gif"));
                menu.add((IAction)traceAction);
            } else {
                Action traceAction = new Action(Messages.TraceAction, 32){

                    public void run() {
                        CamelContextNode.this.startTracing();
                    }
                };
                traceAction.setToolTipText(Messages.TraceActionToolTip);
                traceAction.setImageDescriptor(FabricPlugin.getDefault().getImageDescriptor("start_listening.gif"));
                menu.add((IAction)traceAction);
            }
        }
    }

    protected boolean canTrace() {
        String camelVersion = this.camelContextMBean.getCamelVersion();
        if (camelVersion != null && camelVersion.contains("fuse")) {
            return this.getTracer() != null;
        }
        return false;
    }

    protected void startMBean() {
        this.camelContextMBean.start();
        this.refresh();
    }

    protected void stopMBean() {
        this.camelContextMBean.stop();
        this.refresh();
    }

    protected void suspendMBean() {
        this.camelContextMBean.suspend();
        this.refresh();
    }

    protected void resumeMBean() {
        this.camelContextMBean.resume();
        this.refresh();
    }

    public boolean isMbeanSuspended() {
        String state = this.camelContextMBean.getState();
        return Objects.equal((Object)"Suspended", (Object)state);
    }

    public List<IExchange> browseExchanges() {
        String nodeId = null;
        return this.getTraceExchanges(nodeId);
    }

    public NodeStatisticsContainer getNodeStatisticsContainer() {
        if (this.isTracing()) {
            return this.getTraceExchangeList(null);
        }
        if (this.runtimeNodeStatisticsContainer == null) {
            this.runtimeNodeStatisticsContainer = new CachingCamelContextNodeStatisticsContainer(this);
        }
        return this.runtimeNodeStatisticsContainer;
    }

    public NodeStatisticsContainer getNodeStatisticsContainer(String routeId) {
        if (this.isTracing()) {
            return this.getTraceExchangeList(routeId);
        }
        return this.getNodeStatisticsContainer();
    }

    public ITraceExchangeList getTraceExchangeList(String id) {
        if (id != null) {
            return this.getTraceExchangeList(null);
        }
        TraceExchangeList traceList = null;
        String key = id;
        if (key == null) {
            key = this.getContextId();
        }
        if ((traceList = this.traceMessageMap.get(key)) == null) {
            traceList = new TraceExchangeList();
            this.traceMessageMap.put(key, traceList);
        }
        try {
            CamelFabricTracerMBean tracer = this.getTracer();
            if (tracer != null) {
                List traceMessages = id == null ? tracer.dumpAllTracedMessages() : tracer.dumpTracedMessages(id);
                traceList.addTraceMessages(traceMessages);
            }
        }
        catch (Exception e) {
            FabricPlugin.showUserError((String)"Failed to get tracing messages", (String)("Failed to get tracing messages on CamelContext " + (Object)((Object)this)), (Exception)e);
        }
        return traceList;
    }

    public Image getImage() {
        return FabricPlugin.getDefault().getImage("camel.png");
    }

    public List<IExchange> getTraceExchanges(String id) {
        return this.getTraceExchangeList(id).getExchangeList();
    }

    public CamelFabricTracerMBean getTracer() {
        try {
            return this.getFacade().getFabricTracer(this.getManagementName());
        }
        catch (Exception e) {
            throw new RuntimeCamelException((Throwable)e);
        }
    }

    public CamelProcessorMBean getProcessorMBean(String nodeId) {
        return CamelFacades.getProcessorMBean(this.getFacade(), this.getManagementName(), nodeId);
    }

    public Object createProcessorBeanView(String routeId, String nodeId) {
        return new ProcessorBeanView(this, routeId, nodeId);
    }
}

