/*
 * Decompiled with CFR 0.152.
 */
package com.fusesource.ide.fabric.camel.navigator;

import com.fusesource.fmc.camel.facade.mbean.CamelBrowsableEndpointMBean;
import com.fusesource.fmc.camel.facade.mbean.CamelContextMBean;
import com.fusesource.fmc.camel.facade.mbean.CamelEndpointMBean;
import com.fusesource.ide.fabric.FabricPlugin;
import com.fusesource.ide.fabric.camel.FabricCamelPlugin;
import com.fusesource.ide.fabric.camel.Messages;
import com.fusesource.ide.fabric.camel.navigator.CamelContextNode;
import com.fusesource.ide.fabric.camel.navigator.EndpointSchemeNode;
import com.fusesource.ide.fabric.navigator.MessageDropHandler;
import com.fusesource.ide.fabric.navigator.MessageDropTarget;
import com.fusesource.ide.jmx.ui.internal.views.navigator.ContextMenuProvider;
import com.fusesource.rider.commons.tree.Node;
import com.fusesource.rider.commons.tree.NodeSupport;
import com.fusesource.rider.commons.ui.ImageProvider;
import com.fusesource.rider.commons.ui.Shells;
import com.fusesource.rider.commons.ui.drop.DropHandler;
import com.fusesource.rider.commons.ui.drop.DropHandlerFactory;
import com.fusesource.rider.commons.util.URIs;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Shell;
import org.fusesource.fon.util.messages.Exchange;
import org.fusesource.fon.util.messages.Exchanges;
import org.fusesource.fon.util.messages.IExchange;
import org.fusesource.fon.util.messages.IExchangeBrowser;
import org.fusesource.fon.util.messages.IMessage;

public class EndpointNode
extends NodeSupport
implements IExchangeBrowser,
MessageDropTarget,
DropHandlerFactory,
ImageProvider,
ContextMenuProvider {
    private final EndpointSchemeNode schemeNode;
    private final CamelEndpointMBean endpointMBean;
    private String remaining;

    public EndpointNode(EndpointSchemeNode schemeNode, CamelEndpointMBean endpointMBean) {
        super((Node)schemeNode);
        this.schemeNode = schemeNode;
        this.endpointMBean = endpointMBean;
        this.setPropertyBean(endpointMBean);
    }

    public String toString() {
        return this.getRemaining();
    }

    public CamelEndpointMBean getEndpointMBean() {
        return this.endpointMBean;
    }

    public EndpointSchemeNode getSchemeNode() {
        return this.schemeNode;
    }

    public String getRemaining() {
        if (this.remaining == null) {
            this.remaining = URIs.getRemaining((String)this.getEndpointUri());
        }
        return this.remaining;
    }

    public List<IExchange> browseExchanges() {
        ArrayList<IExchange> answer = new ArrayList<IExchange>();
        if (this.endpointMBean instanceof CamelBrowsableEndpointMBean) {
            CamelBrowsableEndpointMBean browsable = (CamelBrowsableEndpointMBean)this.endpointMBean;
            long size = browsable.queueSize();
            try {
                int i = 0;
                while ((long)i < size) {
                    Exchange exchange;
                    String xml = browsable.browseMessageAsXml(Integer.valueOf(i), Boolean.valueOf(true));
                    if (xml != null && (exchange = Exchanges.unmarshalNoNamespaceXmlString((String)xml)) != null) {
                        IMessage in = exchange.getIn();
                        if (in != null) {
                            in.setEndpointUri(this.getEndpointUri());
                        }
                        answer.add((IExchange)exchange);
                    }
                    ++i;
                }
            }
            catch (Exception e) {
                FabricCamelPlugin.getLogger().warning("Failed to browse messages for " + (Object)((Object)this) + ". " + e, (Throwable)e);
            }
        }
        return answer;
    }

    public Image getImage() {
        return FabricPlugin.getDefault().getImage("jms/queue.gif");
    }

    public DropHandler createDropHandler(DropTargetEvent event) {
        return new MessageDropHandler((MessageDropTarget)this);
    }

    public void dropMessage(IMessage message) {
        try {
            String uri = this.getEndpointUri();
            this.getCamelContextNode().send(uri, message);
        }
        catch (Exception e) {
            FabricPlugin.showUserError((String)("Failed to send message to " + (Object)((Object)this)), (String)("Could not send message to " + (Object)((Object)this)), (Exception)e);
        }
    }

    public String getEndpointUri() {
        return this.getEndpointMBean().getEndpointUri();
    }

    public CamelContextNode getCamelContextNode() {
        return this.schemeNode.getEndpointsNode().getCamelContextNode();
    }

    public void provideContextMenu(IMenuManager menu) {
        Action traceAction = new Action(Messages.DeleteEndpointAction, 32){

            public void run() {
                EndpointNode.this.showDeleteEndpointDialog();
            }
        };
        traceAction.setToolTipText(Messages.DeleteEndpointActionToolTip);
        traceAction.setImageDescriptor(FabricPlugin.getDefault().getImageDescriptor("delete.gif"));
        menu.add((IAction)traceAction);
    }

    protected void showDeleteEndpointDialog() {
        String message = Messages.bind((String)Messages.DeleteEndpointDialogMessage, (Object)this.endpointMBean.getEndpointUri());
        boolean confirm = MessageDialog.openConfirm((Shell)Shells.getShell(), (String)Messages.DeleteEndpointDialogTitle, (String)message);
        if (confirm) {
            this.deleteEndpoint();
        }
    }

    protected void deleteEndpoint() {
        try {
            CamelContextMBean mbean = this.getCamelContextNode().getCamelContextMBean();
            mbean.removeEndpoints(this.getEndpointUri());
            this.schemeNode.refresh();
        }
        catch (Exception e) {
            FabricPlugin.showUserError((String)"Failed to delete Endpoint", (String)("Failed to delete endpoint: " + this.getEndpointUri()), (Exception)e);
        }
    }

    protected void doDelete() {
        this.getEndpointUri();
    }
}

