/*
 * Decompiled with CFR 0.152.
 */
package com.fusesource.ide.fabric.camel.navigator;

import com.fusesource.fmc.camel.facade.CamelFacade;
import com.fusesource.fmc.camel.facade.mbean.CamelContextMBean;
import com.fusesource.fmc.camel.facade.mbean.CamelEndpointMBean;
import com.fusesource.ide.fabric.FabricPlugin;
import com.fusesource.ide.fabric.camel.FabricCamelPlugin;
import com.fusesource.ide.fabric.camel.Messages;
import com.fusesource.ide.fabric.camel.navigator.CamelContextNode;
import com.fusesource.ide.fabric.camel.navigator.EndpointNode;
import com.fusesource.ide.fabric.camel.navigator.EndpointSchemeNode;
import com.fusesource.ide.jmx.ui.internal.views.navigator.ContextMenuProvider;
import com.fusesource.rider.commons.tree.Node;
import com.fusesource.rider.commons.tree.RefreshableCollectionNode;
import com.fusesource.rider.commons.tree.RefreshableUI;
import com.fusesource.rider.commons.ui.ImageProvider;
import com.fusesource.rider.commons.ui.Shells;
import com.fusesource.rider.commons.util.Strings;
import com.fusesource.rider.commons.util.URIs;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;

public class EndpointsNode
extends RefreshableCollectionNode
implements ImageProvider,
ContextMenuProvider {
    private final CamelContextNode camelContextNode;
    private Map<String, EndpointSchemeNode> schemeNodes = new HashMap<String, EndpointSchemeNode>();

    public EndpointsNode(CamelContextNode camelContextNode) {
        super((Node)camelContextNode);
        this.camelContextNode = camelContextNode;
    }

    public CamelContextNode getCamelContextNode() {
        return this.camelContextNode;
    }

    public CamelFacade getFacade() {
        return this.getCamelContextNode().getFacade();
    }

    public String toString() {
        return "Endpoints";
    }

    public Image getImage() {
        return FabricPlugin.getDefault().getImage("jms/queue.gif");
    }

    public void clearChildren() {
        Collection<EndpointSchemeNode> nodes = this.schemeNodes.values();
        for (EndpointSchemeNode schemeNode : nodes) {
            schemeNode.clearChildren();
        }
    }

    protected void refreshUI() {
        super.refreshUI();
        Collection<EndpointSchemeNode> values = this.schemeNodes.values();
        RefreshableUI ui = this.getRefreshableUI();
        if (ui != null) {
            for (EndpointSchemeNode schemeNode : values) {
                ui.fireRefresh((Object)schemeNode, false);
            }
        }
    }

    public void provideContextMenu(IMenuManager menu) {
        this.addCreateEndpointAction(menu, "");
    }

    protected void addCreateEndpointAction(IMenuManager menu, final String defaultEndpointName) {
        Action traceAction = new Action(Messages.CreateEndpointAction, 32){

            public void run() {
                EndpointsNode.this.showCreateEndpointDialog(defaultEndpointName);
            }
        };
        traceAction.setToolTipText(Messages.CreateEndpointActionToolTip);
        traceAction.setImageDescriptor(FabricPlugin.getDefault().getImageDescriptor("add_destination.gif"));
        menu.add((IAction)traceAction);
    }

    protected void showCreateEndpointDialog(String defaultEndpointName) {
        InputDialog dialog = new InputDialog(Shells.getShell(), Messages.CreateEndpointDialogTitle, Messages.CreateEndpointDialogMessage, defaultEndpointName, null);
        int result = dialog.open();
        if (result == 0) {
            String endpoint = dialog.getValue();
            this.createEndpoint(endpoint);
        }
    }

    protected void createEndpoint(String uri) {
        if (!Strings.isBlank((String)uri)) {
            try {
                CamelContextMBean mbean = this.getCamelContextNode().getCamelContextMBean();
                mbean.createEndpoint(uri);
                Display.getDefault().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        EndpointsNode.this.refresh();
                    }
                });
            }
            catch (Exception e) {
                FabricPlugin.showUserError((String)"Failed to create Endpoint", (String)("Failed to create endpoint: " + uri), (Exception)e);
            }
        }
    }

    protected void loadChildren() {
        try {
            List endpoints = this.camelContextNode.getFacade().getEndpoints(this.camelContextNode.getManagementName());
            for (CamelEndpointMBean endpointMBean : endpoints) {
                String uri = endpointMBean.getEndpointUri();
                String scheme = URIs.getScheme((String)uri);
                EndpointSchemeNode schemeEndpoint = this.getEndpointScheme(scheme);
                EndpointNode endpoint = new EndpointNode(schemeEndpoint, endpointMBean);
                schemeEndpoint.addChild((Node)endpoint);
            }
        }
        catch (Exception e) {
            FabricCamelPlugin.getLogger().warning("Failed to load endpoints for " + (Object)((Object)this.camelContextNode) + ". " + e, (Throwable)e);
        }
    }

    protected EndpointSchemeNode getEndpointScheme(String scheme) {
        EndpointSchemeNode answer = this.schemeNodes.get(scheme);
        if (answer == null) {
            answer = new EndpointSchemeNode(this, scheme);
            this.addChild((Node)answer);
            this.schemeNodes.put(scheme, answer);
        }
        return answer;
    }
}

