/*
 * Decompiled with CFR 0.152.
 */
package com.fusesource.ide.fabric.camel.navigator;

import com.fusesource.ide.fabric.camel.navigator.CamelContextNode;
import com.fusesource.ide.fabric.camel.navigator.ProcessorNodeSupport;
import com.fusesource.ide.fabric.camel.navigator.RouteNode;
import com.fusesource.rider.commons.tree.Node;
import com.fusesource.rider.model.AbstractNode;
import java.util.List;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.swt.graphics.Image;

public class ProcessorNode
extends ProcessorNodeSupport {
    private static final boolean useCaching = true;
    private final RouteNode routeNode;
    private final AbstractNode node;

    public ProcessorNode(RouteNode routeNode, Node parent, AbstractNode node) {
        super(parent, routeNode.getRoute());
        this.routeNode = routeNode;
        this.node = node;
    }

    public String toString() {
        return this.node.getDisplayText();
    }

    public AbstractNode getAbstractNode() {
        return this.node;
    }

    @Override
    public CamelContextNode getCamelContextNode() {
        return this.routeNode.getCamelContextNode();
    }

    protected void loadChildren() {
        List children = this.node.getOutputs();
        for (AbstractNode node : children) {
            this.addChild((Node)new ProcessorNode(this.routeNode, (Node)this, node));
        }
    }

    protected Object createPropertyBean() {
        String nodeId = this.getNodeId();
        if (nodeId != null) {
            return this.getCamelContextNode().createProcessorBeanView(this.getRouteId(), nodeId);
        }
        return super.createPropertyBean();
    }

    public void provideContextMenu(IMenuManager menu) {
        this.routeNode.provideContextMenu(menu);
    }

    @Override
    public String getNodeId() {
        return this.node.getId();
    }

    public Image getImage() {
        return this.node.getSmallImage();
    }
}

