/*
 * Decompiled with CFR 0.152.
 */
package com.fusesource.ide.fabric.camel.navigator;

import com.fusesource.fmc.camel.facade.mbean.CamelRouteMBean;
import com.fusesource.ide.fabric.FabricPlugin;
import com.fusesource.ide.fabric.camel.Messages;
import com.fusesource.ide.fabric.camel.navigator.CamelContextNode;
import com.fusesource.ide.fabric.camel.navigator.ProcessorNode;
import com.fusesource.ide.fabric.camel.navigator.ProcessorNodeSupport;
import com.fusesource.ide.fabric.camel.navigator.RoutesNode;
import com.fusesource.rider.commons.tree.Node;
import com.fusesource.rider.commons.util.Function1;
import com.fusesource.rider.commons.util.Objects;
import com.fusesource.rider.commons.util.Strings;
import com.fusesource.rider.model.AbstractNode;
import com.fusesource.rider.model.RouteSupport;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.swt.graphics.Image;

public class RouteNode
extends ProcessorNodeSupport {
    private final RoutesNode routesNode;
    private final RouteSupport route;
    private CamelRouteMBean routeMBean;

    public RouteNode(RoutesNode routesNode, RouteSupport route) {
        super((Node)routesNode, route);
        this.routesNode = routesNode;
        this.route = route;
    }

    public RoutesNode getRoutesNode() {
        return this.routesNode;
    }

    @Override
    public CamelContextNode getCamelContextNode() {
        return this.getRoutesNode().getCamelContextNode();
    }

    public String toString() {
        return Strings.getOrElse((Object)this.getRouteId(), (String)"Route");
    }

    public AbstractNode getAbstractNode() {
        return this.route;
    }

    public Image getImage() {
        return this.route.getSmallImage();
    }

    protected void loadChildren() {
        List children = this.route.getRootNodes();
        for (AbstractNode node : children) {
            this.addChild((Node)new ProcessorNode(this, (Node)this, node));
        }
    }

    public CamelRouteMBean getRouteMBean() {
        return this.routeMBean;
    }

    public void setRouteMBean(CamelRouteMBean mbean) {
        this.routeMBean = mbean;
        this.setPropertyBean(this.routeMBean);
    }

    public void provideContextMenu(IMenuManager menu) {
        Function1<IMenuManager, Void> fn = new Function1<IMenuManager, Void>(){

            public Void apply(IMenuManager menu) {
                if (RouteNode.this.isMBeanStarted()) {
                    Action traceAction = new Action(Messages.StopRouteAction, 32){

                        public void run() {
                            RouteNode.this.stopMBean();
                        }
                    };
                    traceAction.setToolTipText(Messages.StopRouteActionToolTip);
                    traceAction.setImageDescriptor(FabricPlugin.getDefault().getImageDescriptor("stop_task.gif"));
                    menu.add((IAction)traceAction);
                } else {
                    Action traceAction = new Action(Messages.StartRouteAction, 32){

                        public void run() {
                            RouteNode.this.startMBean();
                        }
                    };
                    traceAction.setToolTipText(Messages.StartRouteActionToolTip);
                    traceAction.setImageDescriptor(FabricPlugin.getDefault().getImageDescriptor("start_task.gif"));
                    menu.add((IAction)traceAction);
                }
                return null;
            }
        };
        this.getCamelContextNode().provideContextMenu(menu, fn);
    }

    protected void startMBean() {
        this.routeMBean.start();
    }

    protected void stopMBean() {
        this.routeMBean.stop();
    }

    public boolean isMBeanStarted() {
        String state = this.routeMBean.getState();
        return Objects.equal((Object)"Started", (Object)state);
    }

    @Override
    public String getNodeId() {
        return null;
    }
}

