/*
 * Decompiled with CFR 0.152.
 */
package com.fusesource.ide.fabric.camel.navigator;

import com.fusesource.fmc.camel.facade.CamelFacade;
import com.fusesource.fmc.camel.facade.mbean.CamelRouteMBean;
import com.fusesource.ide.fabric.camel.navigator.CamelContextNode;
import com.fusesource.ide.fabric.camel.navigator.ProcessorNodeSupport;
import com.fusesource.ide.fabric.camel.navigator.RouteNode;
import com.fusesource.ide.fabric.camel.navigator.RoutesTabViewPage;
import com.fusesource.ide.jmx.ui.internal.views.navigator.ContextMenuProvider;
import com.fusesource.rider.commons.tree.Node;
import com.fusesource.rider.commons.tree.RefreshableCollectionNode;
import com.fusesource.rider.model.AbstractNode;
import com.fusesource.rider.model.AbstractNodeFacade;
import com.fusesource.rider.model.Activator;
import com.fusesource.rider.model.RouteContainer;
import com.fusesource.rider.model.RouteSupport;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.ui.views.properties.IPropertySheetPage;
import org.eclipse.ui.views.properties.IPropertySource;
import org.fusesource.fon.util.messages.IExchange;
import org.fusesource.fon.util.messages.ITraceExchangeBrowser;
import org.fusesource.fon.util.messages.NodeStatisticsContainer;

public class RoutesNode
extends RefreshableCollectionNode
implements AbstractNodeFacade,
ContextMenuProvider,
ITraceExchangeBrowser {
    private final CamelContextNode camelContextNode;
    private RouteContainer routeContainer;

    public RoutesNode(CamelContextNode camelContextNode) {
        super((Node)camelContextNode);
        this.camelContextNode = camelContextNode;
    }

    public String toString() {
        return "Routes";
    }

    public Object getAdapter(Class adapter) {
        if (adapter == IPropertySheetPage.class) {
            return new RoutesTabViewPage(this);
        }
        return super.getAdapter(adapter);
    }

    public CamelFacade getFacade() {
        return this.camelContextNode.getFacade();
    }

    public CamelContextNode getCamelContextNode() {
        return this.camelContextNode;
    }

    protected void loadChildren() {
        HashMap<String, RouteNode> routeMap = new HashMap<String, RouteNode>();
        this.routeContainer = this.getCamelContextNode().getModelContainer();
        if (this.routeContainer != null) {
            List children = this.routeContainer.getChildren();
            for (AbstractNode node : children) {
                if (!(node instanceof RouteSupport)) continue;
                RouteSupport route = (RouteSupport)node;
                RouteNode routeNode = new RouteNode(this, route);
                String id = route.getId();
                if (id != null) {
                    routeMap.put(id, routeNode);
                }
                this.addChild((Node)routeNode);
            }
        }
        try {
            List routeMBeans = this.getFacade().getRoutes(this.getManagementName());
            for (CamelRouteMBean mbean : routeMBeans) {
                RouteNode node;
                String routeId = mbean.getRouteId();
                if (routeId == null || (node = (RouteNode)((Object)routeMap.get(routeId))) == null) continue;
                node.setRouteMBean(mbean);
            }
        }
        catch (Exception e) {
            Activator.getLogger().warning((Throwable)e);
        }
    }

    public String getCamelContextId() {
        return this.camelContextNode.getContextId();
    }

    public String getManagementName() {
        return this.camelContextNode.getManagementName();
    }

    public List<IExchange> browseExchanges() {
        return this.getCamelContextNode().browseExchanges();
    }

    public NodeStatisticsContainer getNodeStatisticsContainer() {
        return this.getCamelContextNode().getNodeStatisticsContainer();
    }

    public AbstractNode getAbstractNode() {
        this.checkLoaded();
        return this.routeContainer;
    }

    public void provideContextMenu(IMenuManager menu) {
        this.getCamelContextNode().provideContextMenu(menu);
    }

    public List<IPropertySource> getAllProcessorsPropertySourceList() {
        Node[] children;
        ArrayList<IPropertySource> answer = new ArrayList<IPropertySource>();
        Node[] nodeArray = children = this.getChildren();
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            Node node = nodeArray[n2];
            if (node instanceof ProcessorNodeSupport) {
                ProcessorNodeSupport processor = (ProcessorNodeSupport)node;
                processor.appendAllProcessorSourceList(answer);
            }
            ++n2;
        }
        return answer;
    }
}

