/*
 * Decompiled with CFR 0.152.
 */
package com.fusesource.ide.graph;

import java.util.HashMap;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.graph.DirectedGraph;
import org.eclipse.draw2d.graph.DirectedGraphLayout;
import org.eclipse.draw2d.graph.Edge;
import org.eclipse.draw2d.graph.Node;
import org.eclipse.draw2d.graph.Rank;
import org.eclipse.zest.layouts.algorithms.AbstractLayoutAlgorithm;
import org.eclipse.zest.layouts.dataStructures.InternalNode;
import org.eclipse.zest.layouts.dataStructures.InternalRelationship;

public class DirectedDiagramViewLayoutAlgorithm
extends AbstractLayoutAlgorithm {
    public DirectedDiagramViewLayoutAlgorithm(int styles) {
        super(styles);
    }

    protected void applyLayoutInternal(InternalNode[] entitiesToLayout, InternalRelationship[] relationshipsToConsider, double boundsX, double boundsY, double boundsWidth, double boundsHeight) {
        HashMap<InternalNode, Node> mapping = new HashMap<InternalNode, Node>(entitiesToLayout.length);
        DirectedGraph graph = new DirectedGraph();
        graph.setDirection(4);
        graph.setMargin(new Insets(20, 60, 20, 60));
        graph.setDefaultPadding(new Insets(30, 50, 30, 50));
        int i = 0;
        while (i < entitiesToLayout.length) {
            InternalNode internalNode = entitiesToLayout[i];
            Node node = new Node((Object)internalNode);
            node.setSize(new Dimension(10, 10));
            mapping.put(internalNode, node);
            graph.nodes.add((Object)node);
            ++i;
        }
        i = 0;
        while (i < relationshipsToConsider.length) {
            InternalRelationship relationship = relationshipsToConsider[i];
            Node source = (Node)mapping.get(relationship.getSource());
            Node dest = (Node)mapping.get(relationship.getDestination());
            Edge edge = new Edge((Object)relationship, source, dest);
            graph.edges.add((Object)edge);
            ++i;
        }
        DirectedGraphLayout directedGraphLayout = new DirectedGraphLayout();
        directedGraphLayout.visit(graph);
        for (Node node : graph.nodes) {
            InternalNode internalNode = (InternalNode)node.data;
            if ((this.layout_styles & 0x100) == 256) {
                internalNode.setInternalLocation((double)node.y, (double)node.x);
                continue;
            }
            internalNode.setInternalLocation((double)node.x, (double)node.y);
        }
        this.updateLayoutLocations(entitiesToLayout);
        this.adjustHorizontalSpaces(graph);
    }

    private void adjustHorizontalSpaces(DirectedGraph g) {
        int row = 0;
        while (row < g.ranks.size()) {
            Rank rank = g.ranks.getRank(row);
            int n = 0;
            while (n < rank.size()) {
                Node node = rank.getNode(n);
                InternalNode internalNode = (InternalNode)node.data;
                Insets padNode = g.getPadding(node);
                internalNode.setSize(internalNode.getWidthInLayout(), 25.0);
                if (node.getLeft() != null) {
                    Node left = node.getLeft();
                    InternalNode internalLeft = (InternalNode)left.data;
                    Insets padLeft = g.getPadding(left);
                    double left_end = internalLeft.getCurrentX() + internalLeft.getWidthInLayout() + (double)padLeft.right + (double)padNode.left;
                    if (internalNode.getCurrentX() <= left_end) {
                        internalNode.setLocation(left_end, internalNode.getCurrentY());
                    }
                }
                if (node.getRight() != null) {
                    Node right = node.getRight();
                    InternalNode internalRight = (InternalNode)right.data;
                    Insets padRight = g.getPadding(right);
                    double node_end = internalNode.getCurrentX() + internalNode.getWidthInLayout() + (double)padNode.right + (double)padRight.left;
                    if (node_end >= internalRight.getCurrentX()) {
                        internalRight.setLocation(node_end, internalRight.getCurrentY());
                    }
                }
                ++n;
            }
            ++row;
        }
    }

    protected int getCurrentLayoutStep() {
        return 0;
    }

    protected int getTotalNumberOfLayoutSteps() {
        return 0;
    }

    protected boolean isValidConfiguration(boolean asynchronous, boolean continuous) {
        return true;
    }

    protected void postLayoutAlgorithm(InternalNode[] entitiesToLayout, InternalRelationship[] relationshipsToConsider) {
    }

    protected void preLayoutAlgorithm(InternalNode[] entitiesToLayout, InternalRelationship[] relationshipsToConsider, double x, double y, double width, double height) {
    }

    public void setLayoutArea(double x, double y, double width, double height) {
    }
}

