/*
 * Decompiled with CFR 0.152.
 */
package com.fusesource.ide.graph;

import com.fusesource.ide.graph.BigHorizontalShift;
import com.fusesource.ide.graph.DirectedDiagramViewLayoutAlgorithm;
import com.fusesource.ide.graph.GraphFilter;
import com.fusesource.ide.graph.GraphLabelProviderSupport;
import com.fusesource.rider.commons.Viewers;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.zest.core.viewers.AbstractZoomableViewer;
import org.eclipse.zest.core.viewers.GraphViewer;
import org.eclipse.zest.core.viewers.IZoomableWorkbenchPart;
import org.eclipse.zest.core.viewers.ZoomContributionViewItem;
import org.eclipse.zest.core.widgets.Graph;
import org.eclipse.zest.layouts.LayoutAlgorithm;
import org.eclipse.zest.layouts.algorithms.CompositeLayoutAlgorithm;
import org.eclipse.zest.layouts.algorithms.DirectedGraphLayoutAlgorithm;
import org.eclipse.zest.layouts.algorithms.HorizontalTreeLayoutAlgorithm;
import org.eclipse.zest.layouts.algorithms.RadialLayoutAlgorithm;
import org.eclipse.zest.layouts.algorithms.SpringLayoutAlgorithm;
import org.eclipse.zest.layouts.algorithms.TreeLayoutAlgorithm;

public abstract class GraphViewSupport
extends ViewPart
implements IZoomableWorkbenchPart {
    protected GraphViewer viewer;
    String helpContextId = "com.fusesource.rider.editor.viewer";
    private GraphLabelProviderSupport graphLabelProvider;
    private IAction selectAllAction;
    private IAction showIconAction;
    private IAction wrapLabelAction;
    private IAction radialLayoutAction;
    private IAction showLegendAction;
    private Action doubleClickAction;
    private ZoomContributionViewItem zoomContributionItem;
    private Action directedLayout;
    private Action horizontalTree;
    private Action radialLayout;
    private Action springLayout;
    private Action verticalTree;
    private ZoomContributionViewItem toolbarZoomContributionViewItem;
    private GraphFilter graphFilter = this.createGraphFilter();
    private boolean setLayoutChecked = false;

    public GraphViewer getViewer() {
        return this.viewer;
    }

    public AbstractZoomableViewer getZoomableViewer() {
        return this.viewer;
    }

    protected abstract void doubleClickSelection(ISelection var1);

    protected abstract IContentProvider createGraphContentProvider();

    protected abstract GraphLabelProviderSupport createGraphLabelProvider();

    protected void setInputAndSelection(Object input, Object selection) {
        if (this.isViewerValid()) {
            this.viewer.setInput(input);
            if (selection != null) {
                this.viewer.setSelection((ISelection)new StructuredSelection(selection));
            }
            Viewers.refresh((Viewer)this.viewer);
        }
    }

    protected void setSelectedObject(Object node) {
        if (this.isViewerValid()) {
            this.viewer.setInput(node);
            IStructuredContentProvider contentProvider = (IStructuredContentProvider)this.viewer.getContentProvider();
            if (node != null) {
                this.viewer.setSelection((ISelection)new StructuredSelection(contentProvider.getElements(node)));
            }
            Viewers.refresh((Viewer)this.viewer);
        }
    }

    protected void setSelectedObjectOnly(Object node) {
        if (this.isViewerValid()) {
            this.viewer.setInput(node);
            if (node != null) {
                this.viewer.setSelection((ISelection)new StructuredSelection(node));
            }
            Viewers.refresh((Viewer)this.viewer);
        }
    }

    protected boolean isViewerValid() {
        Control control = this.viewer.getControl();
        boolean valid = control != null && !control.isDisposed();
        return valid;
    }

    public void createPartControl(Composite parent) {
        GridLayout layout;
        ViewerFilter[] filters = this.createViewFilters();
        if (filters != null) {
            layout = new GridLayout(2, false);
            parent.setLayout((Layout)layout);
            Label searchLabel = new Label(parent, 0);
            searchLabel.setText("Search: ");
            final Text searchText = new Text(parent, 2176);
            searchText.setLayoutData((Object)new GridData(768));
            searchText.addKeyListener((KeyListener)new KeyAdapter(){

                public void keyReleased(KeyEvent ke) {
                    GraphViewSupport.this.graphFilter.setSearchText(searchText.getText());
                    if (Viewers.isValid((Viewer)GraphViewSupport.this.viewer)) {
                        GraphViewSupport.this.viewer.refresh();
                        GraphViewSupport.this.viewer.getGraphControl().applyLayout();
                    }
                }
            });
        } else {
            layout = new GridLayout(1, false);
            layout.marginHeight = 0;
            layout.marginWidth = 0;
            parent.setLayout((Layout)layout);
        }
        class MyGraphViewer
        extends GraphViewer {
            public MyGraphViewer(Composite parent, int style) {
                super(parent, style);
                Graph graphControl = new Graph(parent, style){

                    public Point computeSize(int wHint, int hHint, boolean changed) {
                        return new Point(0, 0);
                    }
                };
                this.setControl(graphControl);
            }
        }
        this.viewer = new MyGraphViewer(parent, 0);
        IContentProvider graphContentProvider = this.createGraphContentProvider();
        GraphLabelProviderSupport graphLabelProvider = this.createGraphLabelProvider();
        this.viewer.setContentProvider(graphContentProvider);
        this.viewer.setLabelProvider((IBaseLabelProvider)graphLabelProvider);
        if (filters != null) {
            GridData gridData = new GridData();
            gridData.verticalAlignment = 4;
            gridData.horizontalSpan = 2;
            gridData.grabExcessHorizontalSpace = true;
            gridData.grabExcessVerticalSpace = true;
            gridData.horizontalAlignment = 4;
            this.viewer.getControl().setLayoutData((Object)gridData);
        } else {
            this.viewer.getControl().setLayoutData((Object)new GridData(4, 4, true, true));
        }
        this.viewer.setConnectionStyle(2);
        this.viewer.setNodeStyle(65792);
        this.viewer.setLayoutAlgorithm((LayoutAlgorithm)new DirectedDiagramViewLayoutAlgorithm(515));
        if (graphLabelProvider instanceof ISelectionChangedListener) {
            this.viewer.addSelectionChangedListener((ISelectionChangedListener)graphLabelProvider);
        }
        if (filters != null) {
            this.viewer.setFilters(filters);
        }
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.viewer.getControl(), this.helpContextId);
        this.makeActions();
        this.hookContextMenu();
        this.hookDoubleClickAction();
        this.contributeToActionBars();
    }

    protected ViewerFilter[] createViewFilters() {
        return new ViewerFilter[]{this.graphFilter};
    }

    private void hookContextMenu() {
        MenuManager manager = new MenuManager("#PopupMenu");
        manager.setRemoveAllWhenShown(true);
        manager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                manager.removeAll();
                GraphViewSupport.this.fillContextMenu(manager);
            }
        });
        Menu menu = manager.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(manager, (ISelectionProvider)this.viewer);
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        this.fillLocalPullDown(bars.getMenuManager());
        this.fillLocalToolBar(bars.getToolBarManager());
    }

    private void fillLocalPullDown(IMenuManager manager) {
        this.fillContextMenu(manager);
    }

    private void fillContextMenu(IMenuManager manager) {
        MenuManager subMenu = new MenuManager("Layout");
        manager.add((IContributionItem)subMenu);
        this.addRadioMenuItem(subMenu, this.directedLayout);
        this.addRadioMenuItem(subMenu, this.horizontalTree);
        this.addRadioMenuItem(subMenu, this.springLayout);
        this.addRadioMenuItem(subMenu, this.verticalTree);
        this.addRadioMenuItem(subMenu, this.radialLayout);
        manager.add((IContributionItem)new Separator());
        if (this.showLegendAction != null) {
            manager.add(this.showLegendAction);
        }
        if (this.zoomContributionItem != null) {
            manager.add((IContributionItem)new Separator());
            manager.add((IContributionItem)this.zoomContributionItem);
        }
        manager.add((IContributionItem)new Separator());
        manager.add((IContributionItem)this.toolbarZoomContributionViewItem);
    }

    private void addRadioMenuItem(MenuManager subMenu, final Action action) {
        subMenu.add((IContributionItem)new ContributionItem(){

            public void fill(Menu menu, int index) {
                MenuItem menuItem = new MenuItem(menu, 16);
                menuItem.setText(action.getText());
                menuItem.setAccelerator(action.getAccelerator());
                menuItem.addSelectionListener(new SelectionListener(){

                    public void widgetSelected(SelectionEvent e) {
                        action.run();
                    }

                    public void widgetDefaultSelected(SelectionEvent e) {
                    }
                });
                if (!GraphViewSupport.this.setLayoutChecked) {
                    GraphViewSupport.this.setLayoutChecked = true;
                    menuItem.setSelection(true);
                }
            }
        });
    }

    protected Action createLayoutMenuAction(String text, final LayoutAlgorithm layoutAlgorithm) {
        Action action = new Action(text, 16){

            public void run() {
                this.setChecked(true);
                GraphViewSupport.this.viewer.setLayoutAlgorithm((LayoutAlgorithm)new CompositeLayoutAlgorithm(1, new LayoutAlgorithm[]{layoutAlgorithm, new BigHorizontalShift(1)}));
                GraphViewSupport.this.viewer.getGraphControl().applyLayout();
            }
        };
        return action;
    }

    private void fillLocalToolBar(IToolBarManager manager) {
    }

    private void makeActions() {
        this.toolbarZoomContributionViewItem = new ZoomContributionViewItem((IZoomableWorkbenchPart)this);
        this.directedLayout = this.createLayoutMenuAction("Directed", (LayoutAlgorithm)new DirectedGraphLayoutAlgorithm(1));
        this.directedLayout.setChecked(true);
        this.horizontalTree = this.createLayoutMenuAction("Horizontal Tree", (LayoutAlgorithm)new HorizontalTreeLayoutAlgorithm(1));
        this.radialLayout = this.createLayoutMenuAction("Radial", (LayoutAlgorithm)new RadialLayoutAlgorithm(1));
        this.springLayout = this.createLayoutMenuAction("Spring", (LayoutAlgorithm)new SpringLayoutAlgorithm(1));
        this.verticalTree = this.createLayoutMenuAction("Vertical Tree", (LayoutAlgorithm)new TreeLayoutAlgorithm(1));
        this.selectAllAction = new Action("Select &All"){

            public void run() {
            }
        };
        this.showIconAction = new Action("Show &Icon", 32){

            public void run() {
                GraphViewSupport.this.graphLabelProvider.setShowIcon(this.isChecked());
            }
        };
        this.showIconAction.setChecked(true);
        this.wrapLabelAction = new Action("&Wrap Label", 32){

            public void run() {
                GraphViewSupport.this.graphLabelProvider.setWrapLabel(this.isChecked());
            }
        };
        this.wrapLabelAction.setChecked(true);
        this.radialLayoutAction = new Action("&Radial Layout", 32){

            public void run() {
                if (this.isChecked()) {
                    GraphViewSupport.this.viewer.setLayoutAlgorithm((LayoutAlgorithm)new CompositeLayoutAlgorithm(1, new LayoutAlgorithm[]{new RadialLayoutAlgorithm(1), new BigHorizontalShift(1)}));
                } else {
                    GraphViewSupport.this.viewer.setLayoutAlgorithm((LayoutAlgorithm)new CompositeLayoutAlgorithm(1, new LayoutAlgorithm[]{new DirectedGraphLayoutAlgorithm(1), new BigHorizontalShift(1)}));
                }
                GraphViewSupport.this.viewer.getGraphControl().applyLayout();
            }
        };
        this.radialLayoutAction.setChecked(false);
        this.doubleClickAction = new Action(){

            public void run() {
                ISelection selection = GraphViewSupport.this.viewer.getSelection();
                GraphViewSupport.this.doubleClickSelection(selection);
            }
        };
    }

    private void hookDoubleClickAction() {
        this.viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                GraphViewSupport.this.doubleClickAction.run();
            }
        });
    }

    protected GraphFilter createGraphFilter() {
        return new GraphFilter(this);
    }

    protected String getMessageTitle() {
        return "Route View";
    }

    public void setFocus() {
        this.viewer.getControl().setFocus();
    }

    protected void showMessage(String message) {
        MessageDialog.openInformation((Shell)this.viewer.getControl().getShell(), (String)this.getMessageTitle(), (String)message);
    }
}

