/*
 * Decompiled with CFR 0.152.
 */
package com.fusesource.ide.jvmmonitor.internal.ui;

import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.swt.widgets.Display;

public abstract class RefreshJob
extends Job {
    private String jobId;

    public RefreshJob(String name, String jobId) {
        super(name);
        Assert.isNotNull((Object)jobId);
        this.setPriority(20);
        this.jobId = jobId;
    }

    protected IStatus run(IProgressMonitor monitor) {
        if (monitor.isCanceled()) {
            return Status.CANCEL_STATUS;
        }
        this.refreshModel(monitor);
        if (monitor.isCanceled()) {
            return Status.CANCEL_STATUS;
        }
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                RefreshJob.this.refreshUI();
            }
        });
        return Status.OK_STATUS;
    }

    public boolean belongsTo(Object family) {
        return this.jobId.equals(family.toString());
    }

    public boolean shouldSchedule() {
        Job[] runningJobs;
        Job[] jobArray = runningJobs = Job.getJobManager().find((Object)this.jobId);
        int n = runningJobs.length;
        int n2 = 0;
        while (n2 < n) {
            Job runningJob = jobArray[n2];
            if (runningJob instanceof RefreshJob && this.belongsTo(((RefreshJob)runningJob).getJobId())) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public boolean equals(Object obj) {
        if (obj instanceof RefreshJob) {
            RefreshJob job = (RefreshJob)((Object)obj);
            return job.getJobId().equals(this.jobId);
        }
        return false;
    }

    public int hashCode() {
        return super.hashCode() | this.jobId.hashCode();
    }

    protected void refreshModel(IProgressMonitor monitor) {
    }

    protected void refreshUI() {
    }

    private String getJobId() {
        return this.jobId;
    }
}

