/*
 * Decompiled with CFR 0.152.
 */
package com.fusesource.ide.jvmmonitor.internal.ui.actions;

import com.fusesource.ide.jvmmonitor.core.IActiveJvm;
import com.fusesource.ide.jvmmonitor.core.JvmCoreException;
import com.fusesource.ide.jvmmonitor.core.mbean.IMonitoredMXBeanGroup;
import com.fusesource.ide.jvmmonitor.internal.ui.actions.Messages;
import com.fusesource.ide.jvmmonitor.internal.ui.properties.AbstractJvmPropertySection;
import com.fusesource.ide.jvmmonitor.internal.ui.properties.timeline.ConfigureChartDialog;
import com.fusesource.ide.jvmmonitor.internal.ui.properties.timeline.MBeanAttribute;
import com.fusesource.ide.jvmmonitor.ui.Activator;
import java.util.ArrayList;
import java.util.List;
import javax.management.ObjectName;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public abstract class ShowInTimelineAction
extends Action
implements ISelectionChangedListener {
    List<MBeanAttribute> selections;
    private AbstractJvmPropertySection section;

    public ShowInTimelineAction(AbstractJvmPropertySection section) {
        this.setText(Messages.showInTimelineLabel);
        this.setId(((Object)((Object)this)).getClass().getName());
        this.section = section;
        this.selections = new ArrayList<MBeanAttribute>();
    }

    public void selectionChanged(SelectionChangedEvent event) {
        IActiveJvm jvm = this.section.getJvm();
        if (!(event.getSelection() instanceof StructuredSelection) || jvm == null || !jvm.isConnected()) {
            this.setEnabled(false);
            return;
        }
        Object[] elements = ((StructuredSelection)event.getSelection()).toArray();
        if (elements.length == 0) {
            this.setEnabled(false);
            return;
        }
        boolean enabled = true;
        this.selections.clear();
        Object[] objectArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            Object element = objectArray[n2];
            MBeanAttribute attribute = this.getMBeanAttribute(element);
            if (attribute != null) {
                this.selections.add(attribute);
            }
            if (!this.getEnabled(element)) {
                enabled = false;
            }
            ++n2;
        }
        this.setEnabled(enabled);
    }

    public void run() {
        IActiveJvm jvm = this.section.getJvm();
        if (jvm == null || this.selections.isEmpty()) {
            return;
        }
        ShowInTimelineDialog dialog = new ShowInTimelineDialog(Display.getDefault().getActiveShell(), this.selections.get(0).getAttributeName(), jvm);
        if (dialog.open() == 0) {
            this.performShowInTimeline(dialog.getChartTitle(), dialog.getAxisUnit(), dialog.getAttributes());
        }
    }

    protected abstract boolean getEnabled(Object var1);

    protected abstract MBeanAttribute getMBeanAttribute(Object var1);

    private void performShowInTimeline(String chartTitle, IMonitoredMXBeanGroup.AxisUnit axisUnit, List<MBeanAttribute> attributes) {
        IActiveJvm jvm = this.section.getJvm();
        if (jvm == null) {
            return;
        }
        IMonitoredMXBeanGroup group = jvm.getMBeanServer().addMonitoredAttributeGroup(chartTitle, axisUnit);
        for (MBeanAttribute attribute : attributes) {
            ObjectName objectName = attribute.getObjectName();
            String attributeName = attribute.getAttributeName();
            RGB rgb = attribute.getRgb();
            try {
                group.addAttribute(objectName.getCanonicalName(), attributeName, new int[]{rgb.red, rgb.green, rgb.blue});
            }
            catch (JvmCoreException e) {
                Activator.log(NLS.bind((String)Messages.addAttributeFailedMsg, (Object)attributeName), (CoreException)((Object)e));
            }
        }
    }

    private class ShowInTimelineDialog
    extends ConfigureChartDialog {
        protected ShowInTimelineDialog(Shell shell, String attributeName, IActiveJvm jvm) {
            super(shell, attributeName, null, ShowInTimelineAction.this.selections, jvm, false);
        }

        @Override
        public void create() {
            super.create();
            this.getShell().setText(Messages.showInTimelineDialogTitle);
        }

        @Override
        protected void configureShell(Shell newShell) {
            super.configureShell(newShell);
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)newShell, "com.fusesource.ide.jvmmonitor.ui.show_in_timeline_dialog_content");
        }
    }
}

