/*
 * Decompiled with CFR 0.152.
 */
package com.fusesource.ide.jvmmonitor.internal.ui.actions;

import com.fusesource.ide.jvmmonitor.internal.ui.actions.Messages;
import com.fusesource.ide.jvmmonitor.ui.Activator;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.IDialogSettings;

public class ToggleOrientationAction
extends Action {
    private static final String DIALOG_SETTINGS_NAME = "ToggleOrientationAction";
    private ISashForm sashForm;
    private Orientation orientation;

    public ToggleOrientationAction(Orientation orientation) {
        super(orientation.label, 8);
        this.setImageDescriptor(Activator.getImageDescriptor(orientation.imagePath));
        this.setId(String.valueOf(((Object)((Object)this)).getClass().getName()) + orientation.toString());
        this.orientation = orientation;
    }

    public ToggleOrientationAction(ISashForm sashForm, Orientation orientation) {
        this(orientation);
        this.sashForm = sashForm;
        this.refreshCheckState();
    }

    public void run() {
        if (this.sashForm != null) {
            this.sashForm.setOrientation(this.orientation);
            this.storeCheckState();
        }
    }

    public void setSashForm(ISashForm sashForm) {
        this.sashForm = sashForm;
        this.refreshCheckState();
    }

    private void refreshCheckState() {
        String key;
        IDialogSettings settings = Activator.getDefault().getDialogSettings(DIALOG_SETTINGS_NAME);
        String orientationString = settings.get(key = this.sashForm.getClass().getCanonicalName());
        if (orientationString != null && Orientation.valueOf(orientationString) == this.orientation || orientationString == null && this.orientation == Orientation.AUTOMATIC) {
            this.setChecked(true);
        }
    }

    private void storeCheckState() {
        IDialogSettings settings = Activator.getDefault().getDialogSettings(DIALOG_SETTINGS_NAME);
        String key = this.sashForm.getClass().getCanonicalName();
        settings.put(key, this.orientation.name());
    }

    public static interface ISashForm {
        public void setOrientation(Orientation var1);
    }

    public static enum Orientation {
        VERTICAL(Messages.verticalOrientationLabel, "icons/full/etool16/layout_vertical.gif"),
        HORIZONTAL(Messages.horizontalOrientationLabel, "icons/full/etool16/layout_horizontal.gif"),
        AUTOMATIC(Messages.automaticOrientationLabel, "icons/full/etool16/layout_automatic.gif"),
        SINGLE(Messages.singleOrientationLabel, "icons/full/etool16/layout_single.gif");

        public final String label;
        public final String imagePath;

        private Orientation(String label, String imagePath) {
            this.label = label;
            this.imagePath = imagePath;
        }
    }
}

