/*
 * Decompiled with CFR 0.152.
 */
package com.fusesource.ide.jvmmonitor.internal.ui.editors;

import com.fusesource.ide.jvmmonitor.core.dump.IProfileInfo;
import com.fusesource.ide.jvmmonitor.internal.ui.editors.InfoPage;
import com.fusesource.ide.jvmmonitor.internal.ui.editors.Messages;
import com.fusesource.ide.jvmmonitor.ui.Activator;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.IPageChangedListener;
import org.eclipse.jface.dialogs.PageChangedEvent;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.MultiPageEditorPart;

public abstract class AbstractDumpEditor
extends MultiPageEditorPart {
    InfoPage infoPage;
    IProfileInfo info;
    private Image infoImage;
    private IResourceChangeListener resourceChangeListener;

    protected final void createPages() {
        this.createClientPages();
        this.createInfoPage();
        this.addPageChangedListener(new IPageChangedListener(){

            public void pageChanged(PageChangedEvent event) {
                if (event.getSelectedPage().equals((Object)AbstractDumpEditor.this.infoPage)) {
                    AbstractDumpEditor.this.infoPage.focusCommnentsText();
                }
            }
        });
        this.resourceChangeListener = new ResourceChangeListener();
        ResourcesPlugin.getWorkspace().addResourceChangeListener(this.resourceChangeListener);
    }

    public void doSave(IProgressMonitor monitor) {
        this.infoPage.doSave(monitor);
    }

    public void doSaveAs() {
    }

    public boolean isDirty() {
        return this.infoPage.isDirty();
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public void firePropertyChange(int propertyId) {
        super.firePropertyChange(propertyId);
    }

    public void dispose() {
        super.dispose();
        if (this.infoImage != null) {
            this.infoImage.dispose();
        }
        if (this.resourceChangeListener != null) {
            ResourcesPlugin.getWorkspace().removeResourceChangeListener(this.resourceChangeListener);
        }
    }

    protected abstract void createClientPages();

    protected void setProfileInfo(IProfileInfo profileInfo) {
        this.info = profileInfo;
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (AbstractDumpEditor.this.infoPage != null) {
                    AbstractDumpEditor.this.infoPage.refresh(AbstractDumpEditor.this.info);
                }
            }
        });
    }

    private void createInfoPage() {
        this.infoPage = new InfoPage(this, this.getContainer());
        int page = this.addPage((Control)this.infoPage);
        this.setPageText(page, Messages.infoTabLabel);
        this.setPageImage(page, this.getInfoImage());
        if (this.info != null) {
            this.infoPage.refresh(this.info);
        }
    }

    private Image getInfoImage() {
        if (this.infoImage == null || this.infoImage.isDisposed()) {
            this.infoImage = Activator.getImageDescriptor("icons/full/obj16/info.gif").createImage();
        }
        return this.infoImage;
    }

    private class ResourceChangeListener
    implements IResourceChangeListener {
        public void resourceChanged(IResourceChangeEvent event) {
            IResourceDelta delta = event.getDelta();
            if (delta != null && this.searchFile(delta)) {
                IWorkbenchWindow[] iWorkbenchWindowArray = PlatformUI.getWorkbench().getWorkbenchWindows();
                int n = iWorkbenchWindowArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IWorkbenchWindow window = iWorkbenchWindowArray[n2];
                    IWorkbenchPage[] iWorkbenchPageArray = window.getPages();
                    int n3 = iWorkbenchPageArray.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        final IWorkbenchPage page = iWorkbenchPageArray[n4];
                        Display.getDefault().asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                page.closeEditor((IEditorPart)AbstractDumpEditor.this, false);
                            }
                        });
                        ++n4;
                    }
                    ++n2;
                }
            }
        }

        private boolean searchFile(IResourceDelta delta) {
            IEditorInput input = AbstractDumpEditor.this.getEditorInput();
            if (input instanceof IFileEditorInput) {
                String filePath = ((IFileEditorInput)input).getFile().getFullPath().toOSString();
                if (delta.getKind() == 2 && delta.getFullPath().toOSString().equals(filePath)) {
                    return true;
                }
            }
            IResourceDelta[] iResourceDeltaArray = delta.getAffectedChildren();
            int n = iResourceDeltaArray.length;
            int n2 = 0;
            while (n2 < n) {
                IResourceDelta element = iResourceDeltaArray[n2];
                if (this.searchFile(element)) {
                    return true;
                }
                ++n2;
            }
            return false;
        }
    }
}

