/*
 * Decompiled with CFR 0.152.
 */
package com.fusesource.ide.jvmmonitor.internal.ui.editors;

import com.fusesource.ide.jvmmonitor.core.cpu.CpuModelEvent;
import com.fusesource.ide.jvmmonitor.core.cpu.CpuModelFactory;
import com.fusesource.ide.jvmmonitor.core.cpu.ICallTreeNode;
import com.fusesource.ide.jvmmonitor.core.cpu.ICpuModel;
import com.fusesource.ide.jvmmonitor.core.cpu.ICpuModelChangeListener;
import com.fusesource.ide.jvmmonitor.core.cpu.IMethodNode;
import com.fusesource.ide.jvmmonitor.core.dump.CpuDumpParser;
import com.fusesource.ide.jvmmonitor.internal.ui.actions.CollapseAllAction;
import com.fusesource.ide.jvmmonitor.internal.ui.actions.CopyAction;
import com.fusesource.ide.jvmmonitor.internal.ui.actions.OpenDeclarationAction;
import com.fusesource.ide.jvmmonitor.internal.ui.editors.AbstractDumpEditor;
import com.fusesource.ide.jvmmonitor.internal.ui.editors.Messages;
import com.fusesource.ide.jvmmonitor.internal.ui.properties.cpu.AbstractContentProvider;
import com.fusesource.ide.jvmmonitor.internal.ui.properties.cpu.AbstractFilteredTree;
import com.fusesource.ide.jvmmonitor.internal.ui.properties.cpu.CallTreeContentProvider;
import com.fusesource.ide.jvmmonitor.internal.ui.properties.cpu.CallTreeFilteredTree;
import com.fusesource.ide.jvmmonitor.internal.ui.properties.cpu.CallTreeLabelProvider;
import com.fusesource.ide.jvmmonitor.internal.ui.properties.cpu.HotSpotsFilteredTree;
import com.fusesource.ide.jvmmonitor.internal.ui.properties.cpu.HotSpotsLabelProvider;
import com.fusesource.ide.jvmmonitor.internal.ui.properties.cpu.actions.FindAction;
import com.fusesource.ide.jvmmonitor.ui.Activator;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.dialogs.IPageChangedListener;
import org.eclipse.jface.dialogs.PageChangedEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.ide.FileStoreEditorInput;
import org.eclipse.ui.part.PageBook;
import org.xml.sax.SAXException;

public class CpuDumpEditor
extends AbstractDumpEditor {
    protected ICpuModel cpuModel;
    Map<AbstractFilteredTree, Integer> trees = new HashMap<AbstractFilteredTree, Integer>();
    private PageBook callersCalleesPageBook;
    private Image callTreeImage;
    private Image hotSpotsImage;
    private Image callerCalleeImage;
    CollapseAllAction collapseAllAction;

    @Override
    protected void createClientPages() {
        this.contributeToActionBars();
        this.createCallTreePage();
        this.createHotSpotsPage();
        this.createCallerCalleePage();
        this.refresh();
        this.addListeners();
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.getContainer(), "com.fusesource.ide.jvmmonitor.ui.cpu_dump_editor_content");
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        super.init(site, input);
        this.cpuModel = new CpuModelFactory().createCpuModel();
        this.cpuModel.addModelChangeListener(new ICpuModelChangeListener(){

            public void modelChanged(CpuModelEvent event) {
                if (event.state == CpuModelEvent.CpuModelState.CallersCalleesTargetChanged) {
                    CpuDumpEditor.this.refresh();
                    if (CpuDumpEditor.this.cpuModel.getCallersCalleesTarget() != null) {
                        CpuDumpEditor.this.showCallerCalleeTab();
                    }
                }
            }
        });
        this.setPartName(input.getName());
        if (input instanceof IFileEditorInput) {
            String filePath = ((IFileEditorInput)input).getFile().getRawLocation().toOSString();
            this.loadDumpFile(filePath);
        } else if (input instanceof FileStoreEditorInput) {
            String filePath = ((FileStoreEditorInput)input).getURI().getPath();
            this.loadDumpFile(filePath);
        }
    }

    public void setFocus() {
        this.getContainer().setFocus();
        this.refresh();
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this.callTreeImage != null) {
            this.callTreeImage.dispose();
        }
        if (this.hotSpotsImage != null) {
            this.hotSpotsImage.dispose();
        }
        if (this.callerCalleeImage != null) {
            this.callerCalleeImage.dispose();
        }
    }

    protected void refresh() {
        this.refreshCallersCalleesPage();
        this.refreshContentDescription();
        this.cpuModel.refreshMaxValues();
        for (AbstractFilteredTree tree : this.trees.keySet()) {
            if (tree == null || tree.getViewer().getControl().isDisposed()) continue;
            tree.getViewer().refresh();
        }
    }

    private void createCallTreePage() {
        Composite panel = new Composite(this.getContainer(), 0);
        panel.setLayout((Layout)new FillLayout());
        final CallTreeFilteredTree callTreeFilteredTree = new CallTreeFilteredTree(panel, this.getEditorSite().getActionBars());
        TreeViewer callTreeViewer = callTreeFilteredTree.getViewer();
        callTreeViewer.setContentProvider((IContentProvider)new CallTreeContentProvider());
        callTreeViewer.setLabelProvider((IBaseLabelProvider)new CallTreeLabelProvider(callTreeViewer));
        callTreeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                callTreeFilteredTree.updateStatusLine((IStructuredSelection)event.getSelection());
            }
        });
        callTreeViewer.setUseHashlookup(true);
        callTreeViewer.setInput((Object)this.cpuModel);
        int page = this.addPage((Control)panel);
        this.trees.put(callTreeFilteredTree, page);
        this.setPageText(page, Messages.callTreePageLabel);
        this.setPageImage(page, this.getCallTreeImage());
    }

    private void createHotSpotsPage() {
        Composite panel = new Composite(this.getContainer(), 0);
        panel.setLayout((Layout)new FillLayout());
        final HotSpotsFilteredTree hotSpotsFilteredTree = new HotSpotsFilteredTree(panel, this.getEditorSite().getActionBars());
        TreeViewer hotSpotsViewer = hotSpotsFilteredTree.getViewer();
        hotSpotsViewer.setContentProvider((IContentProvider)new AbstractContentProvider(){

            public Object[] getElements(Object inputElement) {
                if (inputElement instanceof ICpuModel) {
                    return ((ICpuModel)inputElement).getHotSpotRoots();
                }
                return new Object[0];
            }
        });
        hotSpotsViewer.setLabelProvider((IBaseLabelProvider)new HotSpotsLabelProvider(hotSpotsFilteredTree));
        hotSpotsViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                hotSpotsFilteredTree.updateStatusLine((IStructuredSelection)event.getSelection());
            }
        });
        hotSpotsViewer.setUseHashlookup(true);
        hotSpotsViewer.setInput((Object)this.cpuModel);
        hotSpotsFilteredTree.sortColumn(hotSpotsViewer.getTree().getColumn(1));
        int page = this.addPage((Control)panel);
        this.trees.put(hotSpotsFilteredTree, page);
        this.setPageText(page, Messages.hotSpotsPageLabel);
        this.setPageImage(page, this.getHotSpotsImage());
    }

    private void createCallerCalleePage() {
        this.callersCalleesPageBook = new PageBook(this.getContainer(), 0);
        Label messageLabel = new Label((Composite)this.callersCalleesPageBook, 64);
        messageLabel.setText(Messages.noCallersCalleesMessage);
        SashForm sashForm = new SashForm((Composite)this.callersCalleesPageBook, 0);
        sashForm.setOrientation(512);
        sashForm.setLayoutData((Object)new GridData(1808));
        int page = this.addPage((Control)this.callersCalleesPageBook);
        this.createCallerViewer((Composite)sashForm, page);
        this.createCalleeViewer((Composite)sashForm, page);
        this.setPageText(page, Messages.callerCalleePageLabel);
        this.setPageImage(page, this.getCallerCalleeImage());
        this.callersCalleesPageBook.showPage((Control)sashForm);
    }

    private void createCallerViewer(Composite parent, int page) {
        final HotSpotsFilteredTree callerFilteredTree = new HotSpotsFilteredTree(parent, this.getEditorSite().getActionBars()){

            @Override
            public AbstractFilteredTree.ViewerType getViewerType() {
                return AbstractFilteredTree.ViewerType.Caller;
            }

            @Override
            protected String getMethodColumnName() {
                return com.fusesource.ide.jvmmonitor.internal.ui.properties.cpu.Messages.callerColumnLabel;
            }

            @Override
            protected String getMethodColumnToolTip() {
                return com.fusesource.ide.jvmmonitor.internal.ui.properties.cpu.Messages.callerColumnToolTip;
            }
        };
        TreeViewer callerViewer = callerFilteredTree.getViewer();
        callerViewer.setContentProvider((IContentProvider)new AbstractContentProvider(){

            public Object[] getElements(Object inputElement) {
                if (inputElement instanceof ICpuModel) {
                    return ((ICpuModel)inputElement).getCallers();
                }
                return new Object[0];
            }
        });
        callerViewer.setLabelProvider((IBaseLabelProvider)new HotSpotsLabelProvider(callerFilteredTree));
        callerViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                callerFilteredTree.updateStatusLine((IStructuredSelection)event.getSelection());
            }
        });
        callerViewer.setUseHashlookup(true);
        callerViewer.setInput((Object)this.cpuModel);
        callerFilteredTree.sortColumn(callerViewer.getTree().getColumn(1));
        this.trees.put(callerFilteredTree, page);
    }

    private void createCalleeViewer(Composite parent, int page) {
        final HotSpotsFilteredTree calleeFilteredTree = new HotSpotsFilteredTree(parent, this.getEditorSite().getActionBars()){

            @Override
            public AbstractFilteredTree.ViewerType getViewerType() {
                return AbstractFilteredTree.ViewerType.Callee;
            }

            @Override
            protected String getMethodColumnName() {
                return com.fusesource.ide.jvmmonitor.internal.ui.properties.cpu.Messages.calleeColumnLabel;
            }

            @Override
            protected String getMethodColumnToolTip() {
                return com.fusesource.ide.jvmmonitor.internal.ui.properties.cpu.Messages.calleeColumnToolTip;
            }
        };
        TreeViewer calleeViewer = calleeFilteredTree.getViewer();
        calleeViewer.setContentProvider((IContentProvider)new AbstractContentProvider(){

            public Object[] getElements(Object inputElement) {
                if (inputElement instanceof ICpuModel) {
                    return ((ICpuModel)inputElement).getCallees();
                }
                return new Object[0];
            }
        });
        calleeViewer.setLabelProvider((IBaseLabelProvider)new HotSpotsLabelProvider(calleeFilteredTree));
        calleeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                calleeFilteredTree.updateStatusLine((IStructuredSelection)event.getSelection());
            }
        });
        calleeViewer.setUseHashlookup(true);
        calleeViewer.setInput((Object)this.cpuModel);
        calleeFilteredTree.sortColumn(calleeViewer.getTree().getColumn(1));
        this.trees.put(calleeFilteredTree, page);
    }

    private void addListeners() {
        this.cpuModel.addModelChangeListener(new ICpuModelChangeListener(){

            public void modelChanged(CpuModelEvent e) {
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        CpuDumpEditor.this.refresh();
                    }
                });
            }
        });
        this.addPageChangedListener(new IPageChangedListener(){

            public void pageChanged(PageChangedEvent event) {
                CpuDumpEditor.this.pageSelectionChanged();
            }
        });
    }

    void pageSelectionChanged() {
        AbstractFilteredTree tree = this.getActiveFilteredTree();
        if (tree == null) {
            this.setContentDescription("");
            return;
        }
        this.collapseAllAction.setViewer(tree.getViewer());
        FindAction findAction = (FindAction)this.getEditorSite().getActionBars().getGlobalActionHandler(ActionFactory.FIND.getId());
        if (findAction != null) {
            findAction.setViewer(tree.getViewer(), tree.getViewerType());
        }
    }

    private void loadDumpFile(final String filePath) {
        Job job = new Job(Messages.parseCpuDumpFileJobLabel){

            protected IStatus run(IProgressMonitor monitor) {
                CpuDumpParser parser = new CpuDumpParser(new File(filePath), CpuDumpEditor.this.cpuModel, monitor);
                try {
                    parser.parse();
                }
                catch (ParserConfigurationException e) {
                    return new Status(4, "com.fusesource.ide.jvmmonitor.ui", "Could not load CPU dump file.", (Throwable)e);
                }
                catch (SAXException e) {
                    return new Status(4, "com.fusesource.ide.jvmmonitor.ui", "Could not load CPU dump file.", (Throwable)e);
                }
                catch (IOException e) {
                    return new Status(4, "com.fusesource.ide.jvmmonitor.ui", "Could not load CPU dump file.", (Throwable)e);
                }
                CpuDumpEditor.this.setProfileInfo(parser.getProfileInfo());
                return Status.OK_STATUS;
            }
        };
        job.schedule();
    }

    private void contributeToActionBars() {
        IActionBars actionBars = this.getEditorSite().getActionBars();
        IToolBarManager manager = actionBars.getToolBarManager();
        this.collapseAllAction = new CollapseAllAction();
        boolean exist = false;
        IContributionItem[] iContributionItemArray = manager.getItems();
        int n = iContributionItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            IContributionItem contributionItem = iContributionItemArray[n2];
            if (contributionItem.getId().equals(this.collapseAllAction.getId())) {
                exist = true;
                break;
            }
            ++n2;
        }
        if (!exist) {
            manager.add((IAction)this.collapseAllAction);
        }
        actionBars.setGlobalActionHandler("org.eclipse.jdt.ui.actions.Open", (IAction)new OpenDeclarationAction());
        actionBars.setGlobalActionHandler(ActionFactory.FIND.getId(), (IAction)new FindAction());
        actionBars.setGlobalActionHandler(ActionFactory.COPY.getId(), (IAction)new CopyAction());
    }

    void showCallerCalleeTab() {
        for (Map.Entry<AbstractFilteredTree, Integer> entry : this.trees.entrySet()) {
            AbstractFilteredTree filteredTree = entry.getKey();
            if (filteredTree == null || filteredTree.getViewerType() != AbstractFilteredTree.ViewerType.Caller) continue;
            this.setActivePage(entry.getValue());
            this.pageSelectionChanged();
        }
    }

    private void refreshCallersCalleesPage() {
        Control control;
        Label label = null;
        Label sashForm = null;
        Control[] controlArray = this.callersCalleesPageBook.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            control = controlArray[n2];
            if (control instanceof Label) {
                label = (Label)control;
            } else if (control instanceof SashForm) {
                sashForm = (SashForm)control;
            }
            ++n2;
        }
        if (label == null || sashForm == null) {
            throw new IllegalStateException("label and sashform cannot be null");
        }
        control = this.cpuModel.getCallersCalleesTarget() == null ? label : sashForm;
        this.callersCalleesPageBook.showPage(control);
    }

    private AbstractFilteredTree getActiveFilteredTree() {
        for (Map.Entry<AbstractFilteredTree, Integer> entry : this.trees.entrySet()) {
            AbstractFilteredTree filteredTree = entry.getKey();
            if (entry.getValue().intValue() != this.getActivePage()) continue;
            return filteredTree;
        }
        return null;
    }

    private void refreshContentDescription() {
        ICallTreeNode focusedNode;
        StringBuilder description = new StringBuilder();
        AbstractFilteredTree activeTree = this.getActiveFilteredTree();
        if (activeTree == null) {
            this.setContentDescription(description.toString());
            return;
        }
        AbstractFilteredTree.ViewerType type = activeTree.getViewerType();
        IMethodNode callersCalleesTarget = this.cpuModel.getCallersCalleesTarget();
        if ((type == AbstractFilteredTree.ViewerType.Caller || type == AbstractFilteredTree.ViewerType.Callee) && callersCalleesTarget != null) {
            description.append(NLS.bind((String)Messages.callersCalleesTargetIndicator, (Object)callersCalleesTarget.getName()));
        }
        if ((focusedNode = this.cpuModel.getFocusTarget()) != null && (type != AbstractFilteredTree.ViewerType.Caller && type != AbstractFilteredTree.ViewerType.Callee || callersCalleesTarget != null)) {
            description.append(NLS.bind((String)Messages.focusTargetIndicator, (Object)focusedNode.getNonqualifiedName()));
        }
        String thread = null;
        if (focusedNode != null) {
            thread = focusedNode.getThread();
        } else if (callersCalleesTarget != null) {
            thread = callersCalleesTarget.getThread();
        }
        if (description.length() > 0 && thread != null) {
            description.append(NLS.bind((String)Messages.threadIndicator, (Object)thread));
        }
        this.setContentDescription(description.toString());
    }

    private Image getCallTreeImage() {
        if (this.callTreeImage == null || this.callTreeImage.isDisposed()) {
            this.callTreeImage = Activator.getImageDescriptor("icons/full/obj16/call_tree.gif").createImage();
        }
        return this.callTreeImage;
    }

    private Image getHotSpotsImage() {
        if (this.hotSpotsImage == null || this.hotSpotsImage.isDisposed()) {
            this.hotSpotsImage = Activator.getImageDescriptor("icons/full/obj16/hot_spots.gif").createImage();
        }
        return this.hotSpotsImage;
    }

    private Image getCallerCalleeImage() {
        if (this.callerCalleeImage == null || this.callerCalleeImage.isDisposed()) {
            this.callerCalleeImage = Activator.getImageDescriptor("icons/full/obj16/caller_callee.gif").createImage();
        }
        return this.callerCalleeImage;
    }
}

