/*
 * Decompiled with CFR 0.152.
 */
package com.fusesource.ide.jvmmonitor.internal.ui.editors;

import com.fusesource.ide.jvmmonitor.core.IHeapElement;
import com.fusesource.ide.jvmmonitor.core.dump.HeapDumpParser;
import com.fusesource.ide.jvmmonitor.internal.ui.editors.AbstractDumpEditor;
import com.fusesource.ide.jvmmonitor.internal.ui.editors.Messages;
import com.fusesource.ide.jvmmonitor.internal.ui.properties.memory.HeapHistogramPage;
import com.fusesource.ide.jvmmonitor.internal.ui.properties.memory.IHeapInput;
import com.fusesource.ide.jvmmonitor.ui.Activator;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.FileStoreEditorInput;
import org.xml.sax.SAXException;

public class HeapDumpEditor
extends AbstractDumpEditor {
    HeapHistogramPage heapComposite;
    List<IHeapElement> heapListElements = new ArrayList<IHeapElement>();
    private Image memoryImage;

    @Override
    protected void createClientPages() {
        this.createMemoryPage();
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.getContainer(), "com.fusesource.ide.jvmmonitor.ui.heap_dump_editor_content");
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        this.setSite((IWorkbenchPartSite)site);
        this.setInput(input);
        this.setPartName(input.getName());
        if (input instanceof IFileEditorInput) {
            String filePath = ((IFileEditorInput)input).getFile().getRawLocation().toOSString();
            this.parseDumpFile(filePath);
        } else if (input instanceof FileStoreEditorInput) {
            String filePath = ((FileStoreEditorInput)input).getURI().getPath();
            this.parseDumpFile(filePath);
        }
    }

    public void setFocus() {
        this.heapComposite.setFocus();
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this.memoryImage != null) {
            this.memoryImage.dispose();
        }
    }

    private void createMemoryPage() {
        this.heapComposite = new HeapHistogramPage(this.getContainer(), this.getEditorSite().getActionBars());
        this.heapComposite.setInput(new IHeapInput(){

            @Override
            public IHeapElement[] getHeapListElements() {
                return HeapDumpEditor.this.heapListElements.toArray(new IHeapElement[0]);
            }
        });
        int page = this.addPage((Control)this.heapComposite);
        this.setPageText(page, Messages.memoryTabLabel);
        this.setPageImage(page, this.getMemoryImage());
        this.heapComposite.refresh();
    }

    private Image getMemoryImage() {
        if (this.memoryImage == null || this.memoryImage.isDisposed()) {
            this.memoryImage = Activator.getImageDescriptor("icons/full/obj16/memory.gif").createImage();
        }
        return this.memoryImage;
    }

    private void parseDumpFile(final String filePath) {
        Job job = new Job(Messages.parseHeapDumpFileJobLabel){

            protected IStatus run(IProgressMonitor monitor) {
                HeapDumpParser parser = new HeapDumpParser(new File(filePath), HeapDumpEditor.this.heapListElements, monitor);
                try {
                    parser.parse();
                }
                catch (ParserConfigurationException e) {
                    return new Status(4, "com.fusesource.ide.jvmmonitor.ui", "Could not load heap dump file.", (Throwable)e);
                }
                catch (SAXException e) {
                    return new Status(4, "com.fusesource.ide.jvmmonitor.ui", "Could not load heap dump file.", (Throwable)e);
                }
                catch (IOException e) {
                    return new Status(4, "com.fusesource.ide.jvmmonitor.ui", "Could not load heap dump file.", (Throwable)e);
                }
                HeapDumpEditor.this.setProfileInfo(parser.getProfileInfo());
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if ((this).HeapDumpEditor.this.heapComposite != null) {
                            (this).HeapDumpEditor.this.heapComposite.refresh();
                        }
                    }
                });
                return Status.OK_STATUS;
            }
        };
        job.schedule();
    }
}

