/*
 * Decompiled with CFR 0.152.
 */
package com.fusesource.ide.jvmmonitor.internal.ui.properties;

import com.fusesource.ide.jvmmonitor.core.IActiveJvm;
import com.fusesource.ide.jvmmonitor.core.IJvmModelChangeListener;
import com.fusesource.ide.jvmmonitor.core.JvmModel;
import com.fusesource.ide.jvmmonitor.core.JvmModelEvent;
import com.fusesource.ide.jvmmonitor.internal.ui.IJvmFacade;
import com.fusesource.ide.jvmmonitor.internal.ui.actions.PreferencesAction;
import com.fusesource.ide.jvmmonitor.internal.ui.properties.Messages;
import com.fusesource.ide.jvmmonitor.internal.ui.properties.PartListener;
import com.fusesource.ide.jvmmonitor.internal.ui.properties.PerspectiveListener;
import com.fusesource.ide.jvmmonitor.ui.Activator;
import java.lang.reflect.Field;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.StatusLineContributionItem;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Sash;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.PageBook;
import org.eclipse.ui.part.PageSite;
import org.eclipse.ui.views.properties.PropertySheet;
import org.eclipse.ui.views.properties.tabbed.AbstractPropertySection;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;

public abstract class AbstractJvmPropertySection
extends AbstractPropertySection
implements IJvmModelChangeListener {
    private PageBook pageBook;
    private Label errorMessageLabel;
    private Composite composite;
    private IActiveJvm jvm;
    protected boolean suspendRefresh;
    private PartListener partListener;
    PropertySheet propertySheet;
    private PerspectiveListener perspectiveListener;
    IAction preferencesAction = new PreferencesAction();
    protected boolean isSectionActivated;

    public final void createControls(Composite parent, TabbedPropertySheetPage tabbedPropertySheetPage) {
        super.createControls(parent, tabbedPropertySheetPage);
        parent.setLayoutData((Object)new GridData(1808));
        this.pageBook = new PageBook(parent, 0);
        this.errorMessageLabel = new Label((Composite)this.pageBook, 0);
        this.composite = new Composite((Composite)this.pageBook, 0);
        this.composite.setLayout((Layout)new FillLayout());
        this.pageBook.showPage((Control)this.composite);
        this.propertySheet = this.getPropertySheet((PageSite)tabbedPropertySheetPage.getSite());
        this.createControls(this.composite);
        this.partListener = new PartListener(this, tabbedPropertySheetPage);
        this.perspectiveListener = new PerspectiveListener(this, tabbedPropertySheetPage.getSite(), this.propertySheet);
        JvmModel.getInstance().addJvmModelChangeListener((IJvmModelChangeListener)this);
        this.suspendRefresh = false;
    }

    public void dispose() {
        if (this.partListener != null) {
            this.partListener.dispose();
        }
        if (this.perspectiveListener != null) {
            this.perspectiveListener.dispose();
        }
        JvmModel.getInstance().removeJvmModelChangeListener((IJvmModelChangeListener)this);
    }

    public final void setInput(IWorkbenchPart part, ISelection selection) {
        super.setInput(part, selection);
        if (!(selection instanceof StructuredSelection)) {
            return;
        }
        StructuredSelection structuredSelection = (StructuredSelection)selection;
        Object firstElement = structuredSelection.getFirstElement();
        IActiveJvm newJvm = null;
        if (firstElement instanceof IActiveJvm) {
            newJvm = (IActiveJvm)firstElement;
        } else if (firstElement instanceof IJvmFacade) {
            IJvmFacade facade = (IJvmFacade)firstElement;
            newJvm = facade.getActiveJvm();
        }
        if (newJvm == null) {
            super.setInput(part, null);
            return;
        }
        IActiveJvm oldJvm = this.jvm;
        this.jvm = newJvm;
        if (oldJvm != newJvm || newJvm.isConnected()) {
            this.updatePage();
        }
        this.addToolBarActions();
        this.addLocalMenus();
        if (newJvm.isConnected()) {
            this.activateSection();
        }
        this.setInput(part, selection, newJvm, oldJvm);
    }

    public final void aboutToBeHidden() {
        if (this.isFocused() || !this.propertySheet.isPinned()) {
            this.deactivateSection();
        }
    }

    public final void aboutToBeShown() {
        this.activateSection();
    }

    public void jvmModelChanged(final JvmModelEvent e) {
        if (e.state != JvmModelEvent.State.JvmModified && e.state != JvmModelEvent.State.JvmConnected && e.state != JvmModelEvent.State.JvmDisconnected) {
            return;
        }
        if (!this.isSectionActivated && !this.propertySheet.isPinned()) {
            this.jvm = (IActiveJvm)e.jvm;
            return;
        }
        if (e.state == JvmModelEvent.State.JvmDisconnected) {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    AbstractJvmPropertySection.this.propertySheet.getCurrentPage().getControl().forceFocus();
                }
            });
        }
        if (this.pageBook.isDisposed() || this.composite.isDisposed() || this.errorMessageLabel.isDisposed() || this.jvm == null || e.jvm.getPid() != this.jvm.getPid()) {
            return;
        }
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (e.state == JvmModelEvent.State.JvmDisconnected) {
                    AbstractJvmPropertySection.this.propertySheet.setPinned(false);
                } else if (e.state == JvmModelEvent.State.JvmConnected) {
                    AbstractJvmPropertySection.this.updatePage();
                    AbstractJvmPropertySection.this.propertySheet.setPinned(true);
                }
                AbstractJvmPropertySection.this.refresh();
            }
        });
    }

    public void suspendRefresh(boolean suspend) {
        this.suspendRefresh = suspend;
    }

    public IActiveJvm getJvm() {
        return this.jvm;
    }

    public boolean isRefreshSuspended() {
        return this.suspendRefresh;
    }

    public boolean hasErrorMessage() {
        if (!this.errorMessageLabel.isDisposed()) {
            return !this.errorMessageLabel.getText().isEmpty();
        }
        return false;
    }

    public void refreshBackground(Control control, boolean jvmConnected) {
        int color = jvmConnected ? 1 : 22;
        if (!(control.isDisposed() || control instanceof Sash || control instanceof Label)) {
            control.setBackground(Display.getDefault().getSystemColor(color));
        }
    }

    public void refreshBackground(Control[] controls, boolean jvmConnected) {
        Control[] controlArray = controls;
        int n = controls.length;
        int n2 = 0;
        while (n2 < n) {
            Control control = controlArray[n2];
            if (!control.isDisposed()) {
                this.refreshBackground(control, jvmConnected);
                if (control instanceof Composite) {
                    this.refreshBackground(((Composite)control).getChildren(), jvmConnected);
                }
            }
            ++n2;
        }
    }

    public void clearStatusLine() {
        IContributionItem[] items;
        IStatusLineManager manager = this.propertySheet.getViewSite().getActionBars().getStatusLineManager();
        IContributionItem[] iContributionItemArray = items = manager.getItems();
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            IContributionItem item = iContributionItemArray[n2];
            if (item instanceof StatusLineContributionItem) {
                ((StatusLineContributionItem)item).setText("");
            }
            ++n2;
        }
    }

    public IActionBars getActionBars() {
        return this.propertySheet.getViewSite().getActionBars();
    }

    public void setPinned(final boolean pinned) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                AbstractJvmPropertySection.this.propertySheet.setPinned(pinned);
            }
        });
    }

    protected void partClosed() {
    }

    protected void deactivateSection() {
        IMenuManager menuManager;
        this.isSectionActivated = false;
        if (this.pageBook.isDisposed() || this.errorMessageLabel.isDisposed()) {
            return;
        }
        IToolBarManager toolBarManager = this.getToolBarManager();
        if (toolBarManager != null) {
            this.removeToolBarActions(toolBarManager);
            toolBarManager.update(false);
        }
        if ((menuManager = this.getMenuManager()) != null) {
            menuManager.remove(this.preferencesAction.getId());
            this.removeLocalMenus(menuManager);
            menuManager.update(false);
        }
        this.clearStatusLine();
    }

    protected void activateSection() {
        this.isSectionActivated = true;
        this.addToolBarActions();
        this.addLocalMenus();
    }

    protected String getPropertySheetId() {
        return this.propertySheet.toString();
    }

    protected void addToolBarActions(IToolBarManager manager) {
    }

    protected void removeToolBarActions(IToolBarManager manager) {
    }

    protected void addLocalMenus(IMenuManager manager) {
    }

    protected void removeLocalMenus(IMenuManager manager) {
    }

    protected void updatePage() {
        if (this.jvm == null || this.pageBook.isDisposed() || this.errorMessageLabel.isDisposed()) {
            return;
        }
        if (this.jvm.isConnected()) {
            this.errorMessageLabel.setText("");
        } else if (this.jvm.isConnectionSupported()) {
            this.errorMessageLabel.setText(Messages.monitoringNotStartedMsg);
        } else {
            StringBuffer buffer = new StringBuffer(Messages.monitoringNotSupportedMsg);
            String errorMessage = this.jvm.getErrorStateMessage();
            if (errorMessage != null) {
                buffer.append('\n').append('(').append(errorMessage).append(')');
            }
            this.errorMessageLabel.setText(buffer.toString());
        }
        this.pageBook.showPage((Control)(this.hasErrorMessage() ? this.errorMessageLabel : this.composite));
    }

    protected abstract void setInput(IWorkbenchPart var1, ISelection var2, IActiveJvm var3, IActiveJvm var4);

    protected abstract void createControls(Composite var1);

    private PropertySheet getPropertySheet(PageSite pageSite) {
        try {
            Field field = PageSite.class.getDeclaredField("parentSite");
            field.setAccessible(true);
            return (PropertySheet)((IViewSite)field.get(pageSite)).getPart();
        }
        catch (Exception e) {
            Activator.log(4, "", e);
            return null;
        }
    }

    private IToolBarManager getToolBarManager() {
        return this.propertySheet.getViewSite().getActionBars().getToolBarManager();
    }

    IMenuManager getMenuManager() {
        return this.propertySheet.getViewSite().getActionBars().getMenuManager();
    }

    private void addToolBarActions() {
        IToolBarManager toolBarManager = this.getToolBarManager();
        if (toolBarManager != null) {
            this.addToolBarActions(toolBarManager);
            toolBarManager.update(false);
        }
    }

    private void addLocalMenus() {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                IMenuManager menuManager = AbstractJvmPropertySection.this.getMenuManager();
                if (menuManager != null && menuManager.find(AbstractJvmPropertySection.this.preferencesAction.getId()) == null) {
                    AbstractJvmPropertySection.this.addLocalMenus(menuManager);
                    menuManager.add(AbstractJvmPropertySection.this.preferencesAction);
                    menuManager.update(false);
                }
            }
        });
    }

    private boolean isFocused() {
        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        if (page == null) {
            return false;
        }
        IWorkbenchPart part = page.getActivePart();
        if (part != null) {
            return part.equals(this.propertySheet);
        }
        return false;
    }
}

