/*
 * Decompiled with CFR 0.152.
 */
package com.fusesource.ide.jvmmonitor.internal.ui.properties;

import com.fusesource.ide.jvmmonitor.internal.ui.actions.ToggleOrientationAction;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IActionBars;

public abstract class AbstractSashForm
extends SashForm
implements ToggleOrientationAction.ISashForm {
    ToggleOrientationAction.Orientation currentOrientation;
    private List<ToggleOrientationAction> orientationActions;
    protected int[] initialSashWeights;

    public AbstractSashForm(Composite parent, IActionBars actionBars, int[] sashWeights) {
        super(parent, 256);
        this.initialSashWeights = sashWeights;
        this.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                if (AbstractSashForm.this.currentOrientation == ToggleOrientationAction.Orientation.AUTOMATIC) {
                    AbstractSashForm.this.updateOrientation(AbstractSashForm.this.currentOrientation);
                }
            }
        });
    }

    protected abstract void createSashFormControls(SashForm var1, IActionBars var2);

    @Override
    public void setOrientation(ToggleOrientationAction.Orientation orientation) {
        if (this.currentOrientation != orientation) {
            this.updateOrientation(orientation);
            this.currentOrientation = orientation;
        }
    }

    public List<ToggleOrientationAction> getOrientationActions() {
        if (this.orientationActions == null) {
            this.orientationActions = new ArrayList<ToggleOrientationAction>();
            ToggleOrientationAction.Orientation[] orientationArray = ToggleOrientationAction.Orientation.values();
            int n = orientationArray.length;
            int n2 = 0;
            while (n2 < n) {
                ToggleOrientationAction.Orientation orientation = orientationArray[n2];
                ToggleOrientationAction action = new ToggleOrientationAction(this, orientation);
                this.orientationActions.add(action);
                if (action.isChecked()) {
                    this.updateOrientation(orientation);
                    this.currentOrientation = orientation;
                }
                ++n2;
            }
        }
        return this.orientationActions;
    }

    void updateOrientation(ToggleOrientationAction.Orientation orientation) {
        if (orientation == ToggleOrientationAction.Orientation.AUTOMATIC) {
            Rectangle r = this.getBounds();
            if (r.width < r.height) {
                this.setOrientation(512);
            } else {
                this.setOrientation(256);
            }
        }
        if (orientation == this.currentOrientation) {
            return;
        }
        int[] sashWeights = this.initialSashWeights;
        if (orientation == ToggleOrientationAction.Orientation.HORIZONTAL) {
            this.setOrientation(256);
        } else if (orientation == ToggleOrientationAction.Orientation.VERTICAL) {
            this.setOrientation(512);
        } else if (orientation == ToggleOrientationAction.Orientation.SINGLE) {
            int[] nArray = new int[2];
            nArray[0] = 100;
            sashWeights = nArray;
        }
        this.setWeights(sashWeights);
    }
}

