/*
 * Decompiled with CFR 0.152.
 */
package com.fusesource.ide.jvmmonitor.internal.ui.properties;

import com.fusesource.ide.jvmmonitor.internal.ui.properties.Messages;
import com.fusesource.ide.jvmmonitor.internal.ui.properties.PropertiesColumn;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.dialogs.FilteredTree;
import org.eclipse.ui.dialogs.PatternFilter;

public abstract class PropertiesFilteredTree
extends FilteredTree {
    private TreeViewerColumn valueColumn;
    List<Action> actions;

    public PropertiesFilteredTree(Composite parent, IActionBars actionBars) {
        super(parent, 65538, new PatternFilter(), true);
        this.setBackground(Display.getDefault().getSystemColor(1));
        this.configureTree();
        this.createContextMenu(actionBars);
        this.addListeners();
    }

    protected void createControl(Composite composite, int treeStyle) {
        super.createControl(composite, treeStyle);
        GridData data = (GridData)this.filterComposite.getLayoutData();
        data.horizontalIndent = 2;
        data.verticalIndent = 2;
        this.filterComposite.setLayoutData((Object)data);
    }

    public void setEditingSupport(EditingSupport editingSupport) {
        this.valueColumn.setEditingSupport(editingSupport);
    }

    protected abstract List<Action> createActions(IActionBars var1);

    protected abstract void menuAboutToshow();

    private void configureTree() {
        this.getViewer().getTree().setLinesVisible(true);
        this.getViewer().getTree().setHeaderVisible(true);
        PropertiesColumn[] propertiesColumnArray = PropertiesColumn.values();
        int n = propertiesColumnArray.length;
        int n2 = 0;
        while (n2 < n) {
            PropertiesColumn column = propertiesColumnArray[n2];
            TreeViewerColumn treeColumn = new TreeViewerColumn(this.getViewer(), 0);
            treeColumn.getColumn().setText(column.label);
            treeColumn.getColumn().setWidth(column.defalutWidth);
            treeColumn.getColumn().setAlignment(column.alignment);
            treeColumn.getColumn().setToolTipText(column.toolTip);
            if (Messages.valueColumnLabel.equals(column.label)) {
                this.valueColumn = treeColumn;
            }
            ++n2;
        }
    }

    private void createContextMenu(IActionBars actionBars) {
        this.actions = this.createActions(actionBars);
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                PropertiesFilteredTree.this.menuAboutToshow();
                for (Action action : PropertiesFilteredTree.this.actions) {
                    manager.add((IAction)action);
                }
            }
        });
        Menu menu = menuMgr.createContextMenu(this.getViewer().getControl());
        this.getViewer().getControl().setMenu(menu);
    }

    private void addListeners() {
        TreeViewer viewer = this.getViewer();
        for (Action action : this.actions) {
            if (!(action instanceof ISelectionChangedListener)) continue;
            viewer.addSelectionChangedListener((ISelectionChangedListener)action);
        }
    }
}

