/*
 * Decompiled with CFR 0.152.
 */
package com.fusesource.ide.jvmmonitor.internal.ui.properties.cpu;

import com.fusesource.ide.jvmmonitor.core.IActiveJvm;
import com.fusesource.ide.jvmmonitor.core.cpu.ICpuModelChangeListener;
import com.fusesource.ide.jvmmonitor.internal.ui.properties.cpu.AbstractFilteredTree;
import com.fusesource.ide.jvmmonitor.internal.ui.properties.cpu.CpuSection;
import com.fusesource.ide.jvmmonitor.internal.ui.properties.cpu.Messages;
import com.fusesource.ide.jvmmonitor.internal.ui.properties.cpu.actions.ConfigureCpuProfilerAction;
import java.util.List;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.ViewForm;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Hyperlink;
import org.eclipse.ui.part.PageBook;

public abstract class AbstractTabPage
extends PageBook {
    Composite messagePage;
    protected IActiveJvm jvm;
    protected ViewForm viewForm;
    private Label contentDescriptionLabel;
    protected ICpuModelChangeListener cpuModelChangeListener;
    CpuSection cpuSection;

    public AbstractTabPage(CpuSection cpuSection, CTabFolder tabFolder) {
        super((Composite)tabFolder, 0);
        this.cpuSection = cpuSection;
        this.createMessageLabel();
        this.createViewForm();
        this.showPage((Control)this.viewForm);
        this.createContentDescriptionLabel();
    }

    public void dispose() {
        super.dispose();
        if (this.jvm != null) {
            this.jvm.getCpuProfiler().getCpuModel().removeModelChangeListener(this.cpuModelChangeListener);
        }
    }

    protected void updatePage(boolean isPackageSpecified) {
        if (this.viewForm.isDisposed() || this.messagePage.isDisposed()) {
            return;
        }
        if (isPackageSpecified) {
            this.showPage((Control)this.viewForm);
        } else {
            this.showPage((Control)this.messagePage);
        }
    }

    protected void setContentDescription(String desctiption) {
        if (desctiption == null || desctiption.isEmpty()) {
            if (!this.viewForm.isDisposed()) {
                this.viewForm.setTopLeft(null);
            }
        } else if (!this.contentDescriptionLabel.isDisposed()) {
            this.contentDescriptionLabel.setText(desctiption);
            this.contentDescriptionLabel.setToolTipText(desctiption);
            this.viewForm.setTopLeft((Control)this.contentDescriptionLabel);
        }
    }

    protected void setInput(IActiveJvm newJvm) {
        if (!newJvm.equals(this.jvm)) {
            if (this.jvm != null) {
                this.jvm.getCpuProfiler().getCpuModel().removeModelChangeListener(this.cpuModelChangeListener);
            }
            this.jvm = newJvm;
            newJvm.getCpuProfiler().getCpuModel().addModelChangeListener(this.cpuModelChangeListener);
        }
    }

    protected abstract void refresh();

    protected abstract List<AbstractFilteredTree> getFilteredTrees();

    private void createMessageLabel() {
        this.messagePage = new Composite((Composite)this, 0);
        this.messagePage.setLayout((Layout)new GridLayout(3, false));
        this.messagePage.setBackground(Display.getDefault().getSystemColor(25));
        FormToolkit toolkit = new FormToolkit(Display.getDefault());
        toolkit.createLabel(this.messagePage, Messages.patckagesNotSpecifiedMsg);
        Hyperlink hyperlink = toolkit.createHyperlink(this.messagePage, Messages.selectPackagesMsg, 0);
        hyperlink.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                new ConfigureCpuProfilerAction(AbstractTabPage.this.cpuSection).run();
            }
        });
    }

    private void createViewForm() {
        this.viewForm = new ViewForm((Composite)this, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.verticalSpacing = 1;
        this.viewForm.setLayout((Layout)layout);
    }

    private void createContentDescriptionLabel() {
        this.contentDescriptionLabel = new Label((Composite)this.viewForm, 0);
        this.contentDescriptionLabel.setLayoutData((Object)new GridData(768));
    }
}

