/*
 * Decompiled with CFR 0.152.
 */
package com.fusesource.ide.jvmmonitor.internal.ui.properties.cpu;

import com.fusesource.ide.jvmmonitor.core.IActiveJvm;
import com.fusesource.ide.jvmmonitor.core.cpu.CpuModelEvent;
import com.fusesource.ide.jvmmonitor.core.cpu.ICallTreeNode;
import com.fusesource.ide.jvmmonitor.core.cpu.ICpuModel;
import com.fusesource.ide.jvmmonitor.core.cpu.ICpuModelChangeListener;
import com.fusesource.ide.jvmmonitor.core.cpu.IMethodNode;
import com.fusesource.ide.jvmmonitor.internal.ui.properties.cpu.AbstractContentProvider;
import com.fusesource.ide.jvmmonitor.internal.ui.properties.cpu.AbstractFilteredTree;
import com.fusesource.ide.jvmmonitor.internal.ui.properties.cpu.AbstractTabPage;
import com.fusesource.ide.jvmmonitor.internal.ui.properties.cpu.CpuSection;
import com.fusesource.ide.jvmmonitor.internal.ui.properties.cpu.HotSpotsFilteredTree;
import com.fusesource.ide.jvmmonitor.internal.ui.properties.cpu.HotSpotsLabelProvider;
import com.fusesource.ide.jvmmonitor.internal.ui.properties.cpu.Messages;
import com.fusesource.ide.jvmmonitor.internal.ui.properties.cpu.actions.ConfigureCpuProfilerAction;
import com.fusesource.ide.jvmmonitor.ui.Activator;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.PageBook;
import org.eclipse.ui.views.properties.PropertySheet;

public class CallerCalleeTabPage
extends AbstractTabPage {
    HotSpotsFilteredTree callerFilteredTree;
    HotSpotsFilteredTree calleeFilteredTree;
    private PageBook callersCalleesPageBook;
    private Image callerCalleeImage;

    public CallerCalleeTabPage(final CpuSection cpuSection, final CTabFolder tabFolder) {
        super(cpuSection, tabFolder);
        this.callersCalleesPageBook = new PageBook((Composite)this.viewForm, 0);
        Label messageLabel = new Label((Composite)this.callersCalleesPageBook, 64);
        messageLabel.setText(Messages.noCallersCalleesMessage);
        SashForm sashForm = new SashForm((Composite)this.callersCalleesPageBook, 0);
        sashForm.setOrientation(512);
        sashForm.setLayoutData((Object)new GridData(1808));
        this.createCallerViewer((Composite)sashForm);
        this.createCalleeViewer((Composite)sashForm);
        this.callersCalleesPageBook.showPage((Control)sashForm);
        this.viewForm.setContent((Control)this.callersCalleesPageBook);
        final CTabItem tabItem = cpuSection.getWidgetFactory().createTabItem(tabFolder, 0);
        tabItem.setText(Messages.callersCalleesTabLabel);
        tabItem.setImage(this.getCallerCalleeImage());
        tabItem.setControl((Control)this);
        this.cpuModelChangeListener = new ICpuModelChangeListener(){

            public void modelChanged(CpuModelEvent event) {
                if (event.state == CpuModelEvent.CpuModelState.CallersCalleesTargetChanged) {
                    CallerCalleeTabPage.this.refresh();
                    if (CallerCalleeTabPage.this.jvm.getCpuProfiler().getCpuModel().getCallersCalleesTarget() != null && !tabFolder.isDisposed()) {
                        tabFolder.setSelection(tabItem);
                        cpuSection.tabSelectionChanged(tabItem);
                    }
                }
            }
        };
    }

    @Override
    protected void setInput(IActiveJvm jvm) {
        super.setInput(jvm);
        this.callerFilteredTree.getViewer().setInput((Object)jvm.getCpuProfiler().getCpuModel());
        this.calleeFilteredTree.getViewer().setInput((Object)jvm.getCpuProfiler().getCpuModel());
    }

    @Override
    protected void refresh() {
        TreeViewer calleeViewer;
        TreeViewer callerViewer = this.callerFilteredTree.getViewer();
        if (!callerViewer.getControl().isDisposed()) {
            callerViewer.refresh();
            if (callerViewer.getTree().isFocusControl()) {
                this.callerFilteredTree.updateStatusLine((IStructuredSelection)callerViewer.getSelection());
            }
        }
        if (!(calleeViewer = this.calleeFilteredTree.getViewer()).getControl().isDisposed()) {
            calleeViewer.refresh();
            if (calleeViewer.getTree().isFocusControl()) {
                this.calleeFilteredTree.updateStatusLine((IStructuredSelection)calleeViewer.getSelection());
            }
        }
        this.refreshCallersCalleesPage();
        this.refreshContentDescription();
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this.callerCalleeImage != null) {
            this.callerCalleeImage.dispose();
        }
    }

    @Override
    protected List<AbstractFilteredTree> getFilteredTrees() {
        ArrayList<AbstractFilteredTree> trees = new ArrayList<AbstractFilteredTree>();
        trees.add(this.callerFilteredTree);
        trees.add(this.calleeFilteredTree);
        return trees;
    }

    private void createCallerViewer(Composite parent) {
        PropertySheet propertySheet = (PropertySheet)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActivePart();
        this.callerFilteredTree = new HotSpotsFilteredTree(parent, propertySheet.getViewSite().getActionBars()){

            @Override
            protected void addMenus(IMenuManager manager) {
                manager.add((IContributionItem)new Separator());
                manager.add((IAction)new ConfigureCpuProfilerAction(CallerCalleeTabPage.this.cpuSection));
            }

            @Override
            public AbstractFilteredTree.ViewerType getViewerType() {
                return AbstractFilteredTree.ViewerType.Caller;
            }

            @Override
            protected String getMethodColumnName() {
                return Messages.callerColumnLabel;
            }

            @Override
            protected String getMethodColumnToolTip() {
                return Messages.calleeColumnToolTip;
            }
        };
        TreeViewer callerViewer = this.callerFilteredTree.getViewer();
        callerViewer.setContentProvider((IContentProvider)new AbstractContentProvider(){

            public Object[] getElements(Object inputElement) {
                if (inputElement instanceof ICpuModel) {
                    return ((ICpuModel)inputElement).getCallers();
                }
                return new Object[0];
            }
        });
        callerViewer.setLabelProvider((IBaseLabelProvider)new HotSpotsLabelProvider(this.callerFilteredTree));
        callerViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                CallerCalleeTabPage.this.callerFilteredTree.updateStatusLine((IStructuredSelection)event.getSelection());
            }
        });
        this.callerFilteredTree.sortColumn(callerViewer.getTree().getColumn(1));
    }

    private void createCalleeViewer(Composite parent) {
        PropertySheet propertySheet = (PropertySheet)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActivePart();
        this.calleeFilteredTree = new HotSpotsFilteredTree(parent, propertySheet.getViewSite().getActionBars()){

            @Override
            protected void addMenus(IMenuManager manager) {
                manager.add((IContributionItem)new Separator());
                manager.add((IAction)new ConfigureCpuProfilerAction(CallerCalleeTabPage.this.cpuSection));
            }

            @Override
            public AbstractFilteredTree.ViewerType getViewerType() {
                return AbstractFilteredTree.ViewerType.Callee;
            }

            @Override
            protected String getMethodColumnName() {
                return Messages.calleeColumnLabel;
            }

            @Override
            protected String getMethodColumnToolTip() {
                return Messages.calleeColumnToolTip;
            }
        };
        TreeViewer calleeViewer = this.calleeFilteredTree.getViewer();
        calleeViewer.setContentProvider((IContentProvider)new AbstractContentProvider(){

            public Object[] getElements(Object inputElement) {
                if (inputElement instanceof ICpuModel) {
                    return ((ICpuModel)inputElement).getCallees();
                }
                return new Object[0];
            }
        });
        calleeViewer.setLabelProvider((IBaseLabelProvider)new HotSpotsLabelProvider(this.calleeFilteredTree));
        calleeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                CallerCalleeTabPage.this.calleeFilteredTree.updateStatusLine((IStructuredSelection)event.getSelection());
            }
        });
        this.calleeFilteredTree.sortColumn(calleeViewer.getTree().getColumn(1));
    }

    private void refreshContentDescription() {
        ICpuModel cpuModel;
        ICallTreeNode focusedNode;
        if (this.jvm == null) {
            return;
        }
        StringBuilder description = new StringBuilder();
        IMethodNode callersCalleesTarget = this.jvm.getCpuProfiler().getCpuModel().getCallersCalleesTarget();
        if (callersCalleesTarget != null) {
            description.append(NLS.bind((String)Messages.callersCalleesTargetIndicator, (Object)callersCalleesTarget.getName()));
        }
        if ((focusedNode = (cpuModel = this.jvm.getCpuProfiler().getCpuModel()).getFocusTarget()) != null && callersCalleesTarget != null) {
            description.append(NLS.bind((String)Messages.focusTargetIndicator, (Object)focusedNode.getNonqualifiedName()));
        }
        String thread = null;
        if (focusedNode != null) {
            thread = focusedNode.getThread();
        } else if (callersCalleesTarget != null) {
            thread = callersCalleesTarget.getThread();
        }
        if (description.length() > 0 && thread != null) {
            description.append(NLS.bind((String)Messages.threadIndicator, (Object)thread));
        }
        this.setContentDescription(description.toString());
    }

    private void refreshCallersCalleesPage() {
        Control control;
        if (this.jvm == null || this.callersCalleesPageBook.isDisposed()) {
            return;
        }
        Label label = null;
        SashForm sashForm = null;
        Control[] controlArray = this.callersCalleesPageBook.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            control = controlArray[n2];
            if (control instanceof Label) {
                label = (Label)control;
            } else if (control instanceof SashForm) {
                sashForm = (SashForm)control;
            }
            ++n2;
        }
        if (label == null || sashForm == null) {
            throw new IllegalStateException("label and sashform cannot be null");
        }
        control = this.jvm.getCpuProfiler().getCpuModel().getCallersCalleesTarget() == null ? label : sashForm;
        this.callersCalleesPageBook.showPage(control);
    }

    private Image getCallerCalleeImage() {
        if (this.callerCalleeImage == null || this.callerCalleeImage.isDisposed()) {
            this.callerCalleeImage = Activator.getImageDescriptor("icons/full/obj16/caller_callee.gif").createImage();
        }
        return this.callerCalleeImage;
    }
}

