/*
 * Decompiled with CFR 0.152.
 */
package com.fusesource.ide.jvmmonitor.internal.ui.properties.cpu;

import com.fusesource.ide.jvmmonitor.core.IActiveJvm;
import com.fusesource.ide.jvmmonitor.core.JvmCoreException;
import com.fusesource.ide.jvmmonitor.core.JvmModelEvent;
import com.fusesource.ide.jvmmonitor.core.cpu.CpuModelEvent;
import com.fusesource.ide.jvmmonitor.core.cpu.ICpuModelChangeListener;
import com.fusesource.ide.jvmmonitor.core.cpu.ICpuProfiler;
import com.fusesource.ide.jvmmonitor.internal.ui.IConstants;
import com.fusesource.ide.jvmmonitor.internal.ui.RefreshJob;
import com.fusesource.ide.jvmmonitor.internal.ui.actions.CopyAction;
import com.fusesource.ide.jvmmonitor.internal.ui.actions.OpenDeclarationAction;
import com.fusesource.ide.jvmmonitor.internal.ui.properties.AbstractJvmPropertySection;
import com.fusesource.ide.jvmmonitor.internal.ui.properties.cpu.AbstractFilteredTree;
import com.fusesource.ide.jvmmonitor.internal.ui.properties.cpu.AbstractTabPage;
import com.fusesource.ide.jvmmonitor.internal.ui.properties.cpu.CallTreeTabPage;
import com.fusesource.ide.jvmmonitor.internal.ui.properties.cpu.CallerCalleeTabPage;
import com.fusesource.ide.jvmmonitor.internal.ui.properties.cpu.HotSpotsTabPage;
import com.fusesource.ide.jvmmonitor.internal.ui.properties.cpu.Messages;
import com.fusesource.ide.jvmmonitor.internal.ui.properties.cpu.actions.ClearCpuProfilingDataAction;
import com.fusesource.ide.jvmmonitor.internal.ui.properties.cpu.actions.DumpCpuProfilingDataAction;
import com.fusesource.ide.jvmmonitor.internal.ui.properties.cpu.actions.FindAction;
import com.fusesource.ide.jvmmonitor.internal.ui.properties.cpu.actions.ResumeCpuProfilingAction;
import com.fusesource.ide.jvmmonitor.internal.ui.properties.cpu.actions.SuspendCpuProfilingAction;
import com.fusesource.ide.jvmmonitor.ui.Activator;
import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;

public class CpuSection
extends AbstractJvmPropertySection {
    static final Integer DEFAULT_SAMPLING_PERIOD = 50;
    private static final ICpuProfiler.ProfilerType DEFAULT_PROFILER_TYPE = ICpuProfiler.ProfilerType.SAMPLING;
    CallTreeTabPage callTree;
    HotSpotsTabPage hotSpots;
    CallerCalleeTabPage callerCallee;
    ResumeCpuProfilingAction resumeCpuProfilingAction;
    SuspendCpuProfilingAction suspendCpuProfilingAction = new SuspendCpuProfilingAction(this);
    ClearCpuProfilingDataAction clearCpuProfilingDataAction;
    DumpCpuProfilingDataAction dumpCpuProfilingDataAction;
    private Separator separator;
    private ICpuModelChangeListener cpuModelChangeListener;

    public CpuSection() {
        this.resumeCpuProfilingAction = new ResumeCpuProfilingAction(this);
        this.clearCpuProfilingDataAction = new ClearCpuProfilingDataAction(this);
        this.dumpCpuProfilingDataAction = new DumpCpuProfilingDataAction(this);
        this.separator = new Separator();
        this.cpuModelChangeListener = new ICpuModelChangeListener(){

            public void modelChanged(CpuModelEvent event) {
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        CpuSection.this.refreshViewers();
                    }
                });
            }
        };
    }

    @Override
    public void createControls(Composite parent) {
        this.contributeToActionBars();
        final CTabFolder tabFolder = this.getWidgetFactory().createTabFolder(parent, 0x800400);
        tabFolder.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CpuSection.this.tabSelectionChanged(tabFolder.getSelection());
            }
        });
        this.callTree = new CallTreeTabPage(this, tabFolder);
        this.hotSpots = new HotSpotsTabPage(this, tabFolder);
        this.callerCallee = new CallerCalleeTabPage(this, tabFolder);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "com.fusesource.ide.jvmmonitor.ui.cpu_page_content");
    }

    public void refresh() {
        if (!this.isSectionActivated) {
            return;
        }
        this.refresh(false);
    }

    private void refresh(final boolean initConfig) {
        new RefreshJob(NLS.bind((String)Messages.refeshCpuSectionJobLabel, (Object)this.getJvm().getPid()), ((Object)((Object)this)).toString()){
            private boolean isCpuProfilerReady;
            private boolean isPackageSpecified;
            private boolean isCpuProfilerRunning;

            @Override
            protected void refreshModel(IProgressMonitor monitor) {
                IActiveJvm jvm;
                this.isCpuProfilerReady = CpuSection.this.isCpuProfilerReady();
                this.isPackageSpecified = CpuSection.this.isPackageSpecified();
                this.isCpuProfilerRunning = CpuSection.this.isCpuProfilerRunning();
                if (initConfig) {
                    CpuSection.this.setProfiledPackages();
                    CpuSection.this.setProfilerSamplingPeriod();
                    CpuSection.this.setProfilerType();
                }
                if ((jvm = CpuSection.this.getJvm()) == null || !this.isCpuProfilerRunning) {
                    return;
                }
                try {
                    jvm.getCpuProfiler().refreshBciProfileCache(monitor);
                    jvm.getCpuProfiler().getCpuModel().refreshMaxValues();
                }
                catch (JvmCoreException e) {
                    Activator.log(Messages.refreshCpuProfileDataFailedMsg, (CoreException)((Object)e));
                }
            }

            @Override
            protected void refreshUI() {
                IActiveJvm jvm = CpuSection.this.getJvm();
                boolean isConnected = jvm != null && jvm.isConnected();
                CpuSection.this.updatePage(this.isPackageSpecified);
                CpuSection.this.suspendCpuProfilingAction.setEnabled(this.isCpuProfilerRunning && this.isCpuProfilerReady && isConnected);
                CpuSection.this.resumeCpuProfilingAction.setEnabled(!this.isCpuProfilerRunning && this.isCpuProfilerReady && this.isPackageSpecified && isConnected);
                CpuSection.this.clearCpuProfilingDataAction.setEnabled(this.isCpuProfilerReady && this.isPackageSpecified && isConnected);
                CpuSection.this.dumpCpuProfilingDataAction.setEnabled(!CpuSection.this.hasErrorMessage());
                if (!CpuSection.this.isDisposed()) {
                    CpuSection.this.refreshBackground(CpuSection.this.callTree.getChildren(), isConnected);
                    CpuSection.this.refreshBackground(CpuSection.this.hotSpots.getChildren(), isConnected);
                    CpuSection.this.refreshBackground(CpuSection.this.callerCallee.getChildren(), isConnected);
                    CpuSection.this.refreshViewers();
                }
            }
        }.schedule();
    }

    @Override
    public void jvmModelChanged(JvmModelEvent event) {
        super.jvmModelChanged(event);
        IActiveJvm jvm = this.getJvm();
        if (jvm == null || event.jvm == null || event.jvm.getPid() != jvm.getPid() || !(event.jvm instanceof IActiveJvm)) {
            return;
        }
        if (event.state == JvmModelEvent.State.JvmConnected) {
            this.refresh(true);
        }
    }

    @Override
    protected void setInput(IWorkbenchPart part, ISelection selection, IActiveJvm newJvm, IActiveJvm oldJvm) {
        if (oldJvm != null) {
            oldJvm.getCpuProfiler().getCpuModel().removeModelChangeListener(this.cpuModelChangeListener);
        }
        newJvm.getCpuProfiler().getCpuModel().addModelChangeListener(this.cpuModelChangeListener);
        if (newJvm.isConnected()) {
            this.refresh(true);
        }
        this.callTree.setInput(newJvm);
        this.hotSpots.setInput(newJvm);
        this.callerCallee.setInput(newJvm);
    }

    @Override
    protected void addToolBarActions(IToolBarManager manager) {
        this.suspendCpuProfilingAction.setEnabled(false);
        this.resumeCpuProfilingAction.setEnabled(false);
        this.clearCpuProfilingDataAction.setEnabled(false);
        manager.insertAfter("defaults", (IContributionItem)this.separator);
        if (manager.find(this.clearCpuProfilingDataAction.getId()) == null) {
            manager.insertAfter("defaults", (IAction)this.clearCpuProfilingDataAction);
        }
        if (manager.find(this.suspendCpuProfilingAction.getId()) == null) {
            manager.insertAfter("defaults", (IAction)this.suspendCpuProfilingAction);
        }
        if (manager.find(this.resumeCpuProfilingAction.getId()) == null) {
            manager.insertAfter("defaults", (IAction)this.resumeCpuProfilingAction);
        }
        if (manager.find(this.dumpCpuProfilingDataAction.getId()) == null) {
            manager.insertAfter("defaults", (IAction)this.dumpCpuProfilingDataAction);
        }
    }

    @Override
    protected void removeToolBarActions(IToolBarManager manager) {
        manager.remove(this.suspendCpuProfilingAction.getId());
        manager.remove(this.resumeCpuProfilingAction.getId());
        manager.remove(this.clearCpuProfilingDataAction.getId());
        manager.remove(this.dumpCpuProfilingDataAction.getId());
        manager.remove((IContributionItem)this.separator);
    }

    @Override
    protected void deactivateSection() {
        super.deactivateSection();
        Job.getJobManager().cancel((Object)((Object)((Object)this)).toString());
    }

    public void clear() {
        IActiveJvm jvm = this.getJvm();
        if (jvm != null) {
            try {
                jvm.getCpuProfiler().clear();
            }
            catch (JvmCoreException e) {
                Activator.log(Messages.clearCpuProfileDataFailedMsg, (CoreException)((Object)e));
            }
        }
    }

    protected void tabSelectionChanged(CTabItem tabItem) {
        this.clearStatusLine();
        AbstractTabPage page = (AbstractTabPage)tabItem.getControl();
        AbstractFilteredTree filteredTree = page.getFilteredTrees().get(0);
        FindAction findAction = (FindAction)this.getActionBars().getGlobalActionHandler(ActionFactory.FIND.getId());
        if (findAction != null) {
            findAction.setViewer(filteredTree.getViewer(), filteredTree.getViewerType());
        }
    }

    void updatePage(boolean isPackageSpecified) {
        if (!(this.callTree.isDisposed() || this.hotSpots.isDisposed() || this.callerCallee.isDisposed())) {
            this.callTree.updatePage(isPackageSpecified);
            this.hotSpots.updatePage(isPackageSpecified);
            this.callerCallee.updatePage(isPackageSpecified);
        }
    }

    void refreshViewers() {
        if (this.isSectionActivated && !this.isDisposed()) {
            this.callTree.refresh();
            this.hotSpots.refresh();
            this.callerCallee.refresh();
        }
    }

    boolean isDisposed() {
        return this.callTree == null || this.hotSpots == null || this.callerCallee == null || this.callTree.isDisposed() || this.hotSpots.isDisposed() || this.callerCallee.isDisposed();
    }

    private void contributeToActionBars() {
        IActionBars actionBars = this.getActionBars();
        OpenDeclarationAction.createOpenDeclarationAction(actionBars);
        actionBars.setGlobalActionHandler(ActionFactory.FIND.getId(), (IAction)new FindAction());
        CopyAction.createCopyAction(actionBars);
    }

    void setProfiledPackages() {
        IActiveJvm jvm = this.getJvm();
        if (jvm == null) {
            return;
        }
        LinkedHashSet<String> packages = new LinkedHashSet<String>();
        String packagesString = Activator.getDefault().getDialogSettings(CpuSection.class.getName()).get(IConstants.PACKAGES_KEY);
        if (packagesString != null) {
            if (packagesString.contains(",")) {
                String[] stringArray = packagesString.split(",");
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String item = stringArray[n2];
                    packages.add(item);
                    ++n2;
                }
            } else if (!packagesString.isEmpty()) {
                packages.add(packagesString);
            }
            try {
                jvm.getCpuProfiler().setProfiledPackages(packages);
            }
            catch (JvmCoreException e) {
                Activator.log(Messages.setProfiledPackagesFailedMsg, (CoreException)((Object)e));
            }
        }
    }

    void setProfilerSamplingPeriod() {
        IActiveJvm jvm = this.getJvm();
        if (jvm == null) {
            return;
        }
        Integer period = null;
        String periodString = Activator.getDefault().getDialogSettings(CpuSection.class.getName()).get(IConstants.PROFILER_SAMPLING_PERIOD_KEY);
        if (periodString != null) {
            try {
                period = Integer.valueOf(periodString);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        if (period == null) {
            period = DEFAULT_SAMPLING_PERIOD;
        }
        jvm.getCpuProfiler().setSamplingPeriod(period);
    }

    void setProfilerType() {
        IActiveJvm jvm = this.getJvm();
        if (jvm == null) {
            return;
        }
        ICpuProfiler.ProfilerType type = null;
        String typeString = Activator.getDefault().getDialogSettings(CpuSection.class.getName()).get(IConstants.PROFILER_TYPE_KEY);
        if (typeString != null) {
            ICpuProfiler.ProfilerType[] profilerTypeArray = ICpuProfiler.ProfilerType.values();
            int n = profilerTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                ICpuProfiler.ProfilerType profilerType = profilerTypeArray[n2];
                if (profilerType.name().equals(typeString)) {
                    type = profilerType;
                    break;
                }
                ++n2;
            }
        }
        if (type == null) {
            type = DEFAULT_PROFILER_TYPE;
        }
        jvm.getCpuProfiler().setProfilerType(type);
    }

    boolean isCpuProfilerReady() {
        IActiveJvm jvm = this.getJvm();
        return jvm != null && jvm.isConnected() && (jvm.getCpuProfiler().getState() == ICpuProfiler.ProfilerState.READY || jvm.getCpuProfiler().getState() == ICpuProfiler.ProfilerState.RUNNING);
    }

    boolean isCpuProfilerRunning() {
        IActiveJvm jvm = this.getJvm();
        return jvm != null && jvm.isConnected() && jvm.getCpuProfiler().getState() == ICpuProfiler.ProfilerState.RUNNING;
    }

    boolean isPackageSpecified() {
        IActiveJvm jvm = this.getJvm();
        if (jvm == null || jvm.getCpuProfiler().getState() == ICpuProfiler.ProfilerState.AGENT_NOT_LOADED) {
            return false;
        }
        try {
            Set packages = jvm.getCpuProfiler().getProfiledPackages();
            return packages != null && !packages.isEmpty();
        }
        catch (JvmCoreException e) {
            Activator.log(Messages.getProfiledPackagesFailedMsg, (CoreException)((Object)e));
            return false;
        }
    }
}

