/*
 * Decompiled with CFR 0.152.
 */
package com.fusesource.ide.jvmmonitor.internal.ui.properties.cpu;

import com.fusesource.ide.jvmmonitor.core.cpu.IMethodNode;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;

public class HotSpotsComparator
extends ViewerComparator {
    private int sortDirection;
    private ColumnType columnType;

    public HotSpotsComparator(ColumnType columnType) {
        this.columnType = columnType;
        this.sortDirection = columnType == ColumnType.Methods ? 128 : 1024;
    }

    public int compare(Viewer viewer, Object e1, Object e2) {
        int result = 0;
        if (!(e1 instanceof IMethodNode) || !(e2 instanceof IMethodNode)) {
            return result;
        }
        IMethodNode method1 = (IMethodNode)e1;
        IMethodNode method2 = (IMethodNode)e2;
        if (this.columnType == ColumnType.Methods) {
            result = method1.getName().compareTo(method2.getName());
        } else if (this.columnType == ColumnType.TimeMs) {
            result = method1.getSelfTime() > method2.getSelfTime() ? 1 : -1;
        } else if (this.columnType == ColumnType.TimePercentage) {
            result = method1.getSelfTimeInPercentage() > method2.getSelfTimeInPercentage() ? 1 : -1;
        } else if (this.columnType == ColumnType.Count) {
            int n = result = method1.getInvocationCount() > method2.getInvocationCount() ? 1 : -1;
        }
        if (this.sortDirection == 1024) {
            result *= -1;
        }
        return result;
    }

    protected void reverseSortDirection() {
        this.sortDirection = this.sortDirection == 128 ? 1024 : 128;
    }

    protected int getSortDirection() {
        return this.sortDirection;
    }

    public static enum ColumnType {
        Methods,
        TimeMs,
        TimePercentage,
        Count;

    }
}

