/*
 * Decompiled with CFR 0.152.
 */
package com.fusesource.ide.jvmmonitor.internal.ui.properties.cpu;

import com.fusesource.ide.jvmmonitor.core.IActiveJvm;
import com.fusesource.ide.jvmmonitor.core.cpu.CpuModelEvent;
import com.fusesource.ide.jvmmonitor.core.cpu.ICallTreeNode;
import com.fusesource.ide.jvmmonitor.core.cpu.ICpuModel;
import com.fusesource.ide.jvmmonitor.core.cpu.ICpuModelChangeListener;
import com.fusesource.ide.jvmmonitor.internal.ui.properties.cpu.AbstractContentProvider;
import com.fusesource.ide.jvmmonitor.internal.ui.properties.cpu.AbstractFilteredTree;
import com.fusesource.ide.jvmmonitor.internal.ui.properties.cpu.AbstractTabPage;
import com.fusesource.ide.jvmmonitor.internal.ui.properties.cpu.CpuSection;
import com.fusesource.ide.jvmmonitor.internal.ui.properties.cpu.HotSpotsFilteredTree;
import com.fusesource.ide.jvmmonitor.internal.ui.properties.cpu.HotSpotsLabelProvider;
import com.fusesource.ide.jvmmonitor.internal.ui.properties.cpu.Messages;
import com.fusesource.ide.jvmmonitor.internal.ui.properties.cpu.actions.ConfigureCpuProfilerAction;
import com.fusesource.ide.jvmmonitor.ui.Activator;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.views.properties.PropertySheet;

public class HotSpotsTabPage
extends AbstractTabPage {
    HotSpotsFilteredTree filteredTree;
    private Image hotSpotsImage;

    public HotSpotsTabPage(CpuSection cpuSection, CTabFolder tabFolder) {
        super(cpuSection, tabFolder);
        Composite composite = new Composite((Composite)this.viewForm, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        composite.setLayout((Layout)layout);
        composite.setBackground(Display.getDefault().getSystemColor(2));
        this.createHotSpotsViewer(composite);
        this.viewForm.setContent((Control)composite);
        CTabItem tabItem = cpuSection.getWidgetFactory().createTabItem(tabFolder, 0);
        tabItem.setText(Messages.hotSpotsTabLabel);
        tabItem.setImage(this.getHotSpotsImage());
        tabItem.setControl((Control)this);
        this.cpuModelChangeListener = new ICpuModelChangeListener(){

            public void modelChanged(CpuModelEvent event) {
                if (event.state == CpuModelEvent.CpuModelState.FocusedMethodChanged) {
                    HotSpotsTabPage.this.refresh();
                }
            }
        };
    }

    @Override
    protected void setInput(IActiveJvm jvm) {
        super.setInput(jvm);
        this.filteredTree.getViewer().setInput((Object)jvm.getCpuProfiler().getCpuModel());
    }

    @Override
    protected void refresh() {
        if (!this.filteredTree.getViewer().getControl().isDisposed()) {
            this.filteredTree.getViewer().refresh();
            this.filteredTree.updateStatusLine((IStructuredSelection)this.filteredTree.getViewer().getSelection());
        }
        this.refreshContentDescription();
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this.hotSpotsImage != null) {
            this.hotSpotsImage.dispose();
        }
    }

    @Override
    protected List<AbstractFilteredTree> getFilteredTrees() {
        ArrayList<AbstractFilteredTree> trees = new ArrayList<AbstractFilteredTree>();
        trees.add(this.filteredTree);
        return trees;
    }

    private void createHotSpotsViewer(Composite composite) {
        PropertySheet propertySheet = (PropertySheet)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActivePart();
        this.filteredTree = new HotSpotsFilteredTree(composite, propertySheet.getViewSite().getActionBars()){

            @Override
            protected void addMenus(IMenuManager manager) {
                manager.add((IContributionItem)new Separator());
                manager.add((IAction)new ConfigureCpuProfilerAction(HotSpotsTabPage.this.cpuSection));
            }
        };
        TreeViewer hotSpotsViewer = this.filteredTree.getViewer();
        hotSpotsViewer.setContentProvider((IContentProvider)new AbstractContentProvider(){

            public Object[] getElements(Object inputElement) {
                if (inputElement instanceof ICpuModel) {
                    return ((ICpuModel)inputElement).getHotSpotRoots();
                }
                return new Object[0];
            }
        });
        hotSpotsViewer.setLabelProvider((IBaseLabelProvider)new HotSpotsLabelProvider(this.filteredTree));
        hotSpotsViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                HotSpotsTabPage.this.filteredTree.updateStatusLine((IStructuredSelection)event.getSelection());
            }
        });
        this.filteredTree.sortColumn(hotSpotsViewer.getTree().getColumn(1));
    }

    private void refreshContentDescription() {
        if (this.jvm == null) {
            return;
        }
        ICallTreeNode focusedNode = this.jvm.getCpuProfiler().getCpuModel().getFocusTarget();
        StringBuilder description = new StringBuilder();
        if (focusedNode != null) {
            description.append(NLS.bind((String)Messages.focusTargetIndicator, (Object)focusedNode.getNonqualifiedName())).append(NLS.bind((String)Messages.threadIndicator, (Object)focusedNode.getThread()));
        }
        this.setContentDescription(description.toString());
    }

    private Image getHotSpotsImage() {
        if (this.hotSpotsImage == null || this.hotSpotsImage.isDisposed()) {
            this.hotSpotsImage = Activator.getImageDescriptor("icons/full/obj16/hot_spots.gif").createImage();
        }
        return this.hotSpotsImage;
    }
}

