/*
 * Decompiled with CFR 0.152.
 */
package com.fusesource.ide.jvmmonitor.internal.ui.properties.cpu.actions;

import com.fusesource.ide.jvmmonitor.core.Activator;
import com.fusesource.ide.jvmmonitor.internal.ui.properties.cpu.PackageLabelProvider;
import com.fusesource.ide.jvmmonitor.internal.ui.properties.cpu.actions.Messages;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaModel;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.AbstractElementListSelectionDialog;

public class AddPackageDialog
extends AbstractElementListSelectionDialog {
    private static final String SEPARATOR = ",";
    private static final String EXTERNAL_PLUGIN_LIBRARIES = "External Plug-in Libraries";
    private Object[] filteringPackages;
    private Object[] elements;
    private Button enableTextButton;

    public AddPackageDialog(Shell parent, Object[] filteringPackages) {
        super(parent, (ILabelProvider)new PackageLabelProvider());
        this.filteringPackages = filteringPackages;
        IJavaModel javaModel = JavaCore.create((IWorkspaceRoot)ResourcesPlugin.getWorkspace().getRoot());
        this.elements = this.getPackageFragments(javaModel);
        this.setMultipleSelection(true);
        this.setMessage(Messages.selectPackagesMessage);
    }

    protected Control createDialogArea(Composite parent) {
        Composite container = (Composite)super.createDialogArea(parent);
        this.createMessageArea(container);
        this.createFilterText(container);
        this.createFilteredList(container);
        this.setListElements(this.elements);
        this.createPackageControls(container);
        this.setSelection(this.getInitialElementSelections().toArray());
        this.getShell().setText(Messages.addPackageDialogTitle);
        return container;
    }

    protected void computeResult() {
        if (!this.enableTextButton.getSelection()) {
            this.setResult(Arrays.asList(this.getSelectedElements()));
        }
    }

    protected void updateButtonsEnableState(IStatus status) {
        if (!this.enableTextButton.getSelection()) {
            super.updateButtonsEnableState(status);
        }
    }

    private void createPackageControls(Composite parent) {
        Composite contanier = new Composite(parent, 0);
        contanier.setLayoutData((Object)new GridData(768));
        GridLayout layout = new GridLayout(1, false);
        layout.marginTop = 10;
        contanier.setLayout((Layout)layout);
        this.enableTextButton = new Button(contanier, 32);
        this.enableTextButton.setText(Messages.enterPackageName);
        this.enableTextButton.setSelection(false);
        Composite container = new Composite(contanier, 0);
        container.setLayoutData((Object)new GridData(768));
        layout = new GridLayout(2, false);
        layout.marginWidth = 15;
        container.setLayout((Layout)layout);
        final Label packageNameLabel = new Label(container, 0);
        packageNameLabel.setText(Messages.packageNameLabel);
        packageNameLabel.setEnabled(false);
        final Text packageText = this.createPackageText(container);
        this.enableTextButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean enabled = AddPackageDialog.this.enableTextButton.getSelection();
                int color = enabled ? 22 : 25;
                AddPackageDialog.this.fFilteredList.getChildren()[0].setBackground(Display.getDefault().getSystemColor(color));
                AddPackageDialog.this.fFilteredList.setSelection(new Object[0]);
                AddPackageDialog.this.fFilteredList.setEnabled(!enabled);
                packageNameLabel.setEnabled(enabled);
                packageText.setEnabled(enabled);
                AddPackageDialog.this.validate(packageText.getText());
            }
        });
    }

    private Text createPackageText(Composite parent) {
        final Text packageText = new Text(parent, 2048);
        packageText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String packageName = packageText.getText();
                if (AddPackageDialog.this.validate(packageName)) {
                    AddPackageDialog.this.setSelectionResult(packageName.split(AddPackageDialog.SEPARATOR));
                }
            }
        });
        packageText.setLayoutData((Object)new GridData(768));
        packageText.setEnabled(false);
        return packageText;
    }

    boolean validate(String packageName) {
        boolean isValid = !packageName.isEmpty();
        this.getOkButton().setEnabled(isValid);
        return isValid;
    }

    private Object[] getPackageFragments(IJavaModel javaModel) {
        IJavaProject[] projects;
        HashSet<String> packageElements = new HashSet<String>();
        try {
            projects = javaModel.getJavaProjects();
        }
        catch (JavaModelException e) {
            Activator.log((int)4, (String)Messages.getJavaModelFailedMsg, (Throwable)e);
            return new Object[0];
        }
        Object[] objectArray = projects;
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            block10: {
                IJavaProject project = objectArray[n2];
                if (!EXTERNAL_PLUGIN_LIBRARIES.equals(project.getResource().getName())) {
                    IPackageFragmentRoot[] packageFragmentRoots;
                    try {
                        packageFragmentRoots = project.getPackageFragmentRoots();
                    }
                    catch (JavaModelException javaModelException) {
                        break block10;
                    }
                    IPackageFragmentRoot[] iPackageFragmentRootArray = packageFragmentRoots;
                    int n3 = packageFragmentRoots.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IPackageFragmentRoot packageFragment = iPackageFragmentRootArray[n4];
                        try {
                            this.addPackage(packageElements, (IJavaElement)packageFragment);
                        }
                        catch (JavaModelException javaModelException) {}
                        ++n4;
                    }
                }
            }
            ++n2;
        }
        objectArray = this.filteringPackages;
        n = this.filteringPackages.length;
        n2 = 0;
        while (n2 < n) {
            IJavaProject packageName = objectArray[n2];
            packageElements.remove(packageName);
            ++n2;
        }
        return packageElements.toArray(new String[0]);
    }

    private void addPackage(Set<String> packageElements, IJavaElement element) throws JavaModelException {
        int n;
        int kind;
        if (element instanceof IPackageFragmentRoot && (kind = ((IPackageFragmentRoot)element).getKind()) == 1) {
            IJavaElement[] children;
            IJavaElement[] iJavaElementArray = children = ((IPackageFragmentRoot)element).getChildren();
            int n2 = children.length;
            n = 0;
            while (n < n2) {
                IJavaElement child = iJavaElementArray[n];
                this.addPackage(packageElements, child);
                ++n;
            }
        }
        if (element instanceof IPackageFragment) {
            IJavaElement[] children;
            IJavaElement[] iJavaElementArray = children = ((IPackageFragment)element).getChildren();
            n = children.length;
            int n3 = 0;
            while (n3 < n) {
                IJavaElement child = iJavaElementArray[n3];
                if (5 == child.getElementType()) {
                    packageElements.add(element.getElementName());
                    break;
                }
                ++n3;
            }
        }
    }
}

