/*
 * Decompiled with CFR 0.152.
 */
package com.fusesource.ide.jvmmonitor.internal.ui.properties.cpu.actions;

import com.fusesource.ide.jvmmonitor.core.IActiveJvm;
import com.fusesource.ide.jvmmonitor.core.JvmCoreException;
import com.fusesource.ide.jvmmonitor.core.cpu.ICpuProfiler;
import com.fusesource.ide.jvmmonitor.internal.ui.IConstants;
import com.fusesource.ide.jvmmonitor.internal.ui.properties.cpu.CpuSection;
import com.fusesource.ide.jvmmonitor.internal.ui.properties.cpu.actions.ClearCpuProfilingDataAction;
import com.fusesource.ide.jvmmonitor.internal.ui.properties.cpu.actions.ConfigurationDialog;
import com.fusesource.ide.jvmmonitor.internal.ui.properties.cpu.actions.Messages;
import com.fusesource.ide.jvmmonitor.internal.ui.properties.cpu.actions.SuspendCpuProfilingAction;
import com.fusesource.ide.jvmmonitor.ui.Activator;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.swt.widgets.Display;

public class ConfigureCpuProfilerAction
extends Action {
    Set<String> packages;
    CpuSection cpuSection;

    public ConfigureCpuProfilerAction(CpuSection cpuSection) {
        this.cpuSection = cpuSection;
        this.setText(Messages.configureCpuProfilerLabel);
    }

    public void run() {
        final Job getProfiledPackagesJob = new Job(Messages.getProfiledPackagesJobLabel){

            protected IStatus run(IProgressMonitor monitor) {
                IActiveJvm jvm = ConfigureCpuProfilerAction.this.cpuSection.getJvm();
                if (jvm == null) {
                    return Status.CANCEL_STATUS;
                }
                try {
                    ConfigureCpuProfilerAction.this.packages = jvm.getCpuProfiler().getProfiledPackages();
                }
                catch (JvmCoreException e) {
                    Activator.log(Messages.getProfiledPackagesFailedMsg, (CoreException)((Object)e));
                }
                return Status.OK_STATUS;
            }
        };
        getProfiledPackagesJob.schedule();
        Job openDialogJob = new Job(Messages.openDialogJobLabel){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    getProfiledPackagesJob.join();
                    Display.getDefault().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            ConfigureCpuProfilerAction.this.openDialog();
                        }
                    });
                }
                catch (InterruptedException interruptedException) {
                    return Status.CANCEL_STATUS;
                }
                return Status.OK_STATUS;
            }
        };
        openDialogJob.schedule();
    }

    void openDialog() {
        IActiveJvm jvm = this.cpuSection.getJvm();
        if (jvm == null) {
            return;
        }
        final ConfigurationDialog dialog = new ConfigurationDialog(this.cpuSection.getPart().getSite().getShell(), jvm.getCpuProfiler().getProfilerType(), jvm.getCpuProfiler().getSamplingPeriod(), jvm.getCpuProfiler().getState(ICpuProfiler.ProfilerType.BCI), this.packages);
        if (dialog.open() != 0) {
            return;
        }
        new Job(Messages.configureProfilerJobLabel){

            protected IStatus run(IProgressMonitor monitor) {
                return ConfigureCpuProfilerAction.this.doConfigure(monitor, dialog);
            }
        }.schedule();
    }

    IStatus doConfigure(IProgressMonitor monitor, ConfigurationDialog dialog) {
        IActiveJvm jvm = this.cpuSection.getJvm();
        if (jvm == null) {
            return Status.CANCEL_STATUS;
        }
        IDialogSettings dialogSettings = Activator.getDefault().getDialogSettings(CpuSection.class.getName());
        ICpuProfiler.ProfilerType type = dialog.getProfilerType();
        if (jvm.getCpuProfiler().getProfilerType() != type) {
            if (jvm.getCpuProfiler().getState() == ICpuProfiler.ProfilerState.RUNNING) {
                new SuspendCpuProfilingAction(this.cpuSection).run();
            }
            new ClearCpuProfilingDataAction(this.cpuSection).run();
            jvm.getCpuProfiler().setProfilerType(type);
        }
        if (type == ICpuProfiler.ProfilerType.SAMPLING) {
            int samplingPeriod = dialog.getSamplingPeriod();
            jvm.getCpuProfiler().setSamplingPeriod(Integer.valueOf(samplingPeriod));
            dialogSettings.put(IConstants.PROFILER_SAMPLING_PERIOD_KEY, samplingPeriod);
        }
        String packageString = this.setPackages(dialog.getPackages(), monitor);
        dialogSettings.put(IConstants.PACKAGES_KEY, packageString);
        dialogSettings.put(IConstants.PROFILER_TYPE_KEY, type.name());
        return Status.OK_STATUS;
    }

    String setPackages(Set<String> packages, IProgressMonitor monitor) {
        IActiveJvm jvm = this.cpuSection.getJvm();
        if (jvm != null) {
            try {
                jvm.getCpuProfiler().setProfiledPackages(packages);
                if (jvm.getCpuProfiler().getProfilerType() == ICpuProfiler.ProfilerType.BCI && jvm.getCpuProfiler().getState() == ICpuProfiler.ProfilerState.RUNNING) {
                    jvm.getCpuProfiler().transformClasses(monitor);
                }
            }
            catch (JvmCoreException e) {
                Activator.log(Messages.setProfiledPackagesFailedMsg, (CoreException)((Object)e));
            }
            catch (InterruptedException interruptedException) {}
        }
        StringBuffer buffer = new StringBuffer();
        for (String item : packages) {
            if (buffer.length() > 0) {
                buffer.append(',');
            }
            buffer.append(item);
        }
        return buffer.toString();
    }
}

