/*
 * Decompiled with CFR 0.152.
 */
package com.fusesource.ide.jvmmonitor.internal.ui.properties.cpu.actions;

import com.fusesource.ide.jvmmonitor.core.cpu.ICpuModel;
import com.fusesource.ide.jvmmonitor.core.cpu.ITreeNode;
import com.fusesource.ide.jvmmonitor.internal.ui.properties.cpu.AbstractFilteredTree;
import com.fusesource.ide.jvmmonitor.internal.ui.properties.cpu.actions.Messages;
import com.fusesource.ide.jvmmonitor.ui.Activator;
import java.util.ArrayList;
import java.util.Collections;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class FindDialog
extends Dialog {
    private static final String FIND_HISTORY_KEY = String.valueOf(Activator.getDefault().getBundle().getBundleId()) + ".find";
    private Combo findText;
    private Button forwardButton;
    private Button findButton;
    private boolean startSearch;
    private TreeViewer viewer;
    private AbstractFilteredTree.ViewerType viewerType;

    public FindDialog(TreeViewer viewer, AbstractFilteredTree.ViewerType viewerType) {
        super(viewer.getTree().getShell());
        this.viewer = viewer;
        this.viewerType = viewerType;
        this.setShellStyle(this.getShellStyle() ^ 0x10000);
    }

    public void create() {
        super.create();
        this.getShell().setText(Messages.findTitle);
        this.validate();
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)newShell, "com.fusesource.ide.jvmmonitor.ui.find_dialog_content");
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(1, true));
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        this.addFindTextField(composite);
        this.addDirectionSelection(composite);
        FindDialog.applyDialogFont((Control)composite);
        return composite;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.findButton = this.createButton(parent, 1024, Messages.findButtonLabel, true);
        this.findButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FindDialog.this.doFind();
            }
        });
        this.createButton(parent, 1, IDialogConstants.CLOSE_LABEL, false);
    }

    protected boolean isResizable() {
        return true;
    }

    private void addFindTextField(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(2, false));
        composite.setLayoutData((Object)new GridData(4, 0, true, false));
        Label label = new Label(composite, 0);
        label.setText(Messages.findTextLabel);
        this.findText = new Combo(composite, 2048);
        String[] items = Activator.getDefault().getDialogSettings(((Object)((Object)this)).getClass().getName()).getArray(FIND_HISTORY_KEY);
        if (items != null) {
            this.findText.setItems(items);
            this.findText.select(0);
        }
        this.findText.setLayoutData((Object)new GridData(4, 0, true, false));
        this.findText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                FindDialog.this.validate();
            }
        });
    }

    private void addDirectionSelection(Composite parent) {
        Group group = new Group(parent, 0);
        group.setLayout((Layout)new GridLayout(1, true));
        group.setLayoutData((Object)new GridData(4, 0, true, false));
        group.setText(Messages.directionLabel);
        this.forwardButton = new Button((Composite)group, 16);
        this.forwardButton.setText(Messages.forwardLabel);
        this.forwardButton.setSelection(true);
        Button backwardButton = new Button((Composite)group, 16);
        backwardButton.setText(Messages.backwardLabel);
    }

    void validate() {
        if (this.findText.getText().isEmpty()) {
            this.findButton.setEnabled(false);
        } else {
            this.findButton.setEnabled(true);
        }
    }

    private void addHistory(String searchText) {
        if (searchText.isEmpty()) {
            return;
        }
        IDialogSettings dialogSettings = Activator.getDefault().getDialogSettings(((Object)((Object)this)).getClass().getName());
        String[] items = dialogSettings.getArray(FIND_HISTORY_KEY);
        if (items == null) {
            items = new String[]{searchText};
        } else {
            ArrayList<String> list = new ArrayList<String>();
            Collections.addAll(list, items);
            if (list.contains(searchText)) {
                list.remove(searchText);
            }
            Collections.reverse(list);
            list.add(searchText);
            Collections.reverse(list);
            items = list.toArray(new String[0]);
        }
        dialogSettings.put(FIND_HISTORY_KEY, items);
        this.findText.setItems(items);
        this.findText.select(0);
    }

    void doFind() {
        String searchText = this.findText.getText();
        this.addHistory(searchText);
        ITreeNode treeNode = null;
        ITreeNode[] nodes = null;
        ICpuModel cpuModel = (ICpuModel)this.viewer.getInput();
        if (this.viewerType == AbstractFilteredTree.ViewerType.CallTree) {
            nodes = cpuModel.getCallTreeRoots();
        } else if (this.viewerType == AbstractFilteredTree.ViewerType.HotSpots) {
            nodes = cpuModel.getHotSpotRoots();
        } else if (this.viewerType == AbstractFilteredTree.ViewerType.Caller) {
            nodes = cpuModel.getCallers();
        } else if (this.viewerType == AbstractFilteredTree.ViewerType.Callee) {
            nodes = cpuModel.getCallees();
        }
        if (nodes == null) {
            return;
        }
        ITreeNode selectedNode = this.getSelectedNode();
        this.startSearch = selectedNode == null;
        treeNode = this.forwardButton.getSelection() ? this.searchTreeNodeInForward(nodes, selectedNode, searchText) : this.searchTreeNodeInBackward(nodes, selectedNode, searchText);
        if (treeNode != null) {
            StructuredSelection newSelection = new StructuredSelection((Object)treeNode);
            this.viewer.setSelection((ISelection)newSelection);
        }
        this.findButton.forceFocus();
    }

    private ITreeNode getSelectedNode() {
        TreeSelection treeSelection;
        Object element;
        ISelection selection = this.viewer.getSelection();
        if (selection instanceof TreeSelection && (element = (treeSelection = (TreeSelection)selection).getFirstElement()) instanceof ITreeNode) {
            return (ITreeNode)element;
        }
        return null;
    }

    private ITreeNode searchTreeNodeInForward(ITreeNode[] nodes, ITreeNode selectedNode, String searchText) {
        ITreeNode[] sortedNodes;
        ITreeNode[] iTreeNodeArray = sortedNodes = this.getSortedNodes(nodes);
        int n = sortedNodes.length;
        int n2 = 0;
        while (n2 < n) {
            ITreeNode foundTreeNode;
            ITreeNode treeNode = iTreeNodeArray[n2];
            if (this.startSearch && treeNode.getName().contains(searchText)) {
                return treeNode;
            }
            if (treeNode.equals(selectedNode)) {
                this.startSearch = true;
            }
            if (treeNode.hasChildren() && (foundTreeNode = this.searchTreeNodeInForward(treeNode.getChildren().toArray(new ITreeNode[0]), selectedNode, searchText)) != null) {
                return foundTreeNode;
            }
            ++n2;
        }
        return null;
    }

    private ITreeNode searchTreeNodeInBackward(ITreeNode[] nodes, ITreeNode selectedNode, String searchText) {
        ITreeNode[] sortedNodes = this.getSortedNodes(nodes);
        int i = sortedNodes.length - 1;
        while (i >= 0) {
            ITreeNode foundTreeNode;
            ITreeNode treeNode = sortedNodes[i];
            if (treeNode.hasChildren() && (foundTreeNode = this.searchTreeNodeInBackward(treeNode.getChildren().toArray(new ITreeNode[0]), selectedNode, searchText)) != null) {
                return foundTreeNode;
            }
            if (this.startSearch && treeNode.getName().contains(searchText)) {
                return treeNode;
            }
            if (treeNode.equals(selectedNode)) {
                this.startSearch = true;
            }
            --i;
        }
        return null;
    }

    private ITreeNode[] getSortedNodes(ITreeNode[] nodes) {
        ViewerComparator comparator = this.viewer.getComparator();
        if (comparator != null) {
            comparator.sort((Viewer)this.viewer, (Object[])nodes);
        }
        return nodes;
    }
}

