/*
 * Decompiled with CFR 0.152.
 */
package com.fusesource.ide.jvmmonitor.internal.ui.properties.cpu.actions;

import com.fusesource.ide.jvmmonitor.core.cpu.ICallTreeNode;
import com.fusesource.ide.jvmmonitor.core.cpu.ICpuModel;
import com.fusesource.ide.jvmmonitor.internal.ui.properties.cpu.AbstractFilteredTree;
import com.fusesource.ide.jvmmonitor.internal.ui.properties.cpu.actions.Messages;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.TreeSelection;

public class FocusOnAction
extends Action {
    private ICallTreeNode selectedNode;
    private AbstractFilteredTree filteredTree;

    public FocusOnAction(AbstractFilteredTree filteredTree) {
        this.filteredTree = filteredTree;
        this.setText(Messages.focusOnLabel);
        this.setEnabled(false);
    }

    public void run() {
        boolean focused;
        ICpuModel cpuModel = (ICpuModel)this.filteredTree.getViewer().getInput();
        boolean bl = focused = cpuModel.getFocusTarget() != null;
        if (!focused) {
            cpuModel.setFocusTarget(this.selectedNode);
        } else {
            cpuModel.setFocusTarget(null);
            this.updateMenu();
        }
        this.filteredTree.getViewer().refresh();
    }

    public void aboutToShow() {
        ICpuModel cpuModel = (ICpuModel)this.filteredTree.getViewer().getInput();
        boolean focused = cpuModel.getFocusTarget() != null;
        this.setChecked(focused);
        Object element = ((TreeSelection)this.filteredTree.getViewer().getSelection()).getFirstElement();
        if (element instanceof ICallTreeNode) {
            this.selectedNode = (ICallTreeNode)element;
            this.setEnabled(true);
            if (!focused) {
                this.updateMenu();
            }
            return;
        }
        this.selectedNode = this.filteredTree.getViewerType() == AbstractFilteredTree.ViewerType.CallTree ? null : cpuModel.getFocusTarget();
        this.setEnabled(focused);
        this.updateMenu();
    }

    private void updateMenu() {
        StringBuffer text = new StringBuffer();
        text.append(Messages.focusOnLabel);
        if (this.selectedNode != null) {
            text.append(" '").append(this.selectedNode.getNonqualifiedName()).append("'");
        }
        this.setText(text.toString());
    }
}

