/*
 * Decompiled with CFR 0.152.
 */
package com.fusesource.ide.jvmmonitor.internal.ui.properties.cpu.actions;

import com.fusesource.ide.jvmmonitor.core.IActiveJvm;
import com.fusesource.ide.jvmmonitor.core.JvmCoreException;
import com.fusesource.ide.jvmmonitor.core.cpu.ICpuProfiler;
import com.fusesource.ide.jvmmonitor.internal.ui.properties.AbstractJvmPropertySection;
import com.fusesource.ide.jvmmonitor.internal.ui.properties.cpu.actions.Messages;
import com.fusesource.ide.jvmmonitor.ui.Activator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.Action;

public class ResumeCpuProfilingAction
extends Action {
    AbstractJvmPropertySection section;

    public ResumeCpuProfilingAction(AbstractJvmPropertySection section) {
        this.setText(Messages.resumeCpuProfilingLabel);
        this.setImageDescriptor(Activator.getImageDescriptor("icons/full/elcl16/resume_co.gif"));
        this.setDisabledImageDescriptor(Activator.getImageDescriptor("icons/full/dlcl16/resume.gif"));
        this.setId(((Object)((Object)this)).getClass().getName());
        this.section = section;
    }

    public void run() {
        new Job(Messages.resumeCpuProfilingJob){

            protected IStatus run(IProgressMonitor monitor) {
                IActiveJvm jvm = ResumeCpuProfilingAction.this.section.getJvm();
                if (jvm == null) {
                    return Status.CANCEL_STATUS;
                }
                if (jvm.getCpuProfiler().getProfilerType() == ICpuProfiler.ProfilerType.BCI) {
                    try {
                        jvm.getCpuProfiler().transformClasses(monitor);
                    }
                    catch (JvmCoreException e) {
                        Activator.log(Messages.resumeCpuProfilingFailedMsg, (CoreException)((Object)e));
                    }
                    catch (InterruptedException interruptedException) {
                        return Status.CANCEL_STATUS;
                    }
                }
                try {
                    jvm.getCpuProfiler().resume();
                }
                catch (JvmCoreException e) {
                    Activator.log(Messages.resumeCpuProfilingFailedMsg, (CoreException)((Object)e));
                }
                return Status.OK_STATUS;
            }
        }.schedule();
    }
}

