/*
 * Decompiled with CFR 0.152.
 */
package com.fusesource.ide.jvmmonitor.internal.ui.properties.mbean;

import com.fusesource.ide.jvmmonitor.internal.ui.properties.PropertiesColumn;
import com.fusesource.ide.jvmmonitor.internal.ui.properties.mbean.AttributeNode;
import com.fusesource.ide.jvmmonitor.internal.ui.properties.timeline.MBeanAttribute;
import com.fusesource.ide.jvmmonitor.ui.Activator;
import org.eclipse.jface.resource.CompositeImageDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Tree;

public class AttributeLabelProvider
extends LabelProvider
implements ITableLabelProvider {
    private static final int IMAGE_HEIGHT = 16;
    private static final int IMAGE_WIDTH = 24;
    private Image attributeImage;
    private Image attributeFolderImage;
    private Image writeOverlayImage;
    private TreeViewer viewer;

    public AttributeLabelProvider(TreeViewer viewer) {
        this.viewer = viewer;
    }

    public Image getColumnImage(Object element, int columnIndex) {
        if (columnIndex == this.getColumnIndex(PropertiesColumn.PROPERTY) && element instanceof AttributeNode) {
            if (((AttributeNode)element).hasChildren()) {
                return this.getAttributeFolderImage();
            }
            if (((AttributeNode)element).isWritable()) {
                return this.getWriteOverlayImage();
            }
            return this.getAttributeImage();
        }
        return null;
    }

    public String getColumnText(Object element, int columnIndex) {
        if (element instanceof AttributeNode) {
            return this.getColumnText((AttributeNode)element, columnIndex);
        }
        throw new IllegalArgumentException("unknown input");
    }

    public String getText(Object obj) {
        if (obj instanceof MBeanAttribute) {
            return this.getColumnText(obj, this.getColumnIndex(PropertiesColumn.PROPERTY));
        }
        return super.getText(obj);
    }

    public void dispose() {
        if (this.attributeImage != null) {
            this.attributeImage.dispose();
        }
        if (this.attributeFolderImage != null) {
            this.attributeFolderImage.dispose();
        }
        if (this.writeOverlayImage != null) {
            this.writeOverlayImage.dispose();
        }
    }

    private String getColumnText(AttributeNode attribute, int columnIndex) {
        if (columnIndex == this.getColumnIndex(PropertiesColumn.PROPERTY)) {
            return attribute.getName();
        }
        if (columnIndex == this.getColumnIndex(PropertiesColumn.VALUE)) {
            Object value = attribute.getValue();
            if (value == null) {
                return "<not supported>";
            }
            if (attribute.isValidLeaf()) {
                return value.toString();
            }
            return "";
        }
        throw new IllegalArgumentException("unknown column");
    }

    private int getColumnIndex(PropertiesColumn column) {
        Tree tree = this.viewer.getTree();
        int i = 0;
        while (i < tree.getColumnCount()) {
            if (tree.getColumn(i).getText().equals(column.label)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private Image getAttributeImage() {
        if (this.attributeImage == null || this.attributeImage.isDisposed()) {
            ImageData imageData = Activator.getImageDescriptor("icons/full/obj16/attribute.gif").getImageData();
            this.attributeImage = new OverlayImageDescriptor(imageData, new ImageDescriptor[0], new Point(24, 16)).createImage();
        }
        return this.attributeImage;
    }

    private Image getAttributeFolderImage() {
        if (this.attributeFolderImage == null || this.attributeFolderImage.isDisposed()) {
            ImageData imageData = Activator.getImageDescriptor("icons/full/obj16/attribute_folder.gif").getImageData();
            this.attributeFolderImage = new OverlayImageDescriptor(imageData, new ImageDescriptor[0], new Point(24, 16)).createImage();
        }
        return this.attributeFolderImage;
    }

    private Image getWriteOverlayImage() {
        if (this.writeOverlayImage == null || this.writeOverlayImage.isDisposed()) {
            ImageDescriptor[] descriptors = new ImageDescriptor[4];
            descriptors[1] = Activator.getImageDescriptor("icons/full/ovr16/write.gif");
            ImageData imageData = Activator.getImageDescriptor("icons/full/obj16/attribute.gif").getImageData();
            this.writeOverlayImage = new OverlayImageDescriptor(imageData, descriptors, new Point(24, 16)).createImage();
        }
        return this.writeOverlayImage;
    }

    public static class OverlayImageDescriptor
    extends CompositeImageDescriptor {
        private ImageDescriptor[] imageDescriptors;
        private Point imageSize;
        private ImageData baseImageData;

        public OverlayImageDescriptor(ImageData baseImageData, ImageDescriptor[] imageDescriptors, Point imageSize) {
            this.baseImageData = baseImageData;
            this.imageSize = imageSize;
            this.imageDescriptors = imageDescriptors;
        }

        protected void drawCompositeImage(int width, int height) {
            this.drawImage(this.baseImageData, 0, 0);
            int i = 0;
            while (i < this.imageDescriptors.length) {
                ImageDescriptor descriptor = this.imageDescriptors[i];
                if (descriptor != null) {
                    ImageData imageData = descriptor.getImageData();
                    if (imageData == null) {
                        imageData = ImageDescriptor.getMissingImageDescriptor().getImageData();
                    }
                    switch (i) {
                        case 0: {
                            this.drawImage(imageData, 0, 0);
                            break;
                        }
                        case 1: {
                            this.drawImage(imageData, this.imageSize.x - imageData.width, 0);
                            break;
                        }
                        case 2: {
                            this.drawImage(imageData, 0, this.imageSize.y - imageData.height);
                            break;
                        }
                        case 3: {
                            this.drawImage(imageData, this.imageSize.x - imageData.width, this.imageSize.y - imageData.height);
                        }
                    }
                }
                ++i;
            }
        }

        protected Point getSize() {
            return this.imageSize;
        }
    }
}

