/*
 * Decompiled with CFR 0.152.
 */
package com.fusesource.ide.jvmmonitor.internal.ui.properties.mbean;

import java.util.ArrayList;
import java.util.List;

public class AttributeNode {
    private String name;
    private Object value;
    private List<AttributeNode> children;
    private AttributeNode parent;
    private boolean writable;

    public AttributeNode(String name, AttributeNode parent, Object value) {
        this.name = name;
        this.parent = parent;
        this.value = value;
        this.writable = false;
        this.children = new ArrayList<AttributeNode>();
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer(this.name);
        if (this.isValidLeaf()) {
            buffer.append('\t').append(this.value);
        }
        return buffer.toString();
    }

    protected String getName() {
        return this.name;
    }

    protected Object getValue() {
        return this.value;
    }

    protected void setValue(Object value) {
        this.value = value;
    }

    protected void addChild(AttributeNode node) {
        this.children.add(node);
    }

    protected List<AttributeNode> getChildren() {
        return this.children;
    }

    protected boolean hasChildren() {
        return this.children.size() > 0;
    }

    protected AttributeNode getParent() {
        return this.parent;
    }

    protected void removeChildren() {
        this.children.clear();
    }

    protected boolean isWritable() {
        return this.writable && this.value != null;
    }

    protected void setWritable(boolean writable) {
        this.writable = writable;
    }

    protected boolean isValidLeaf() {
        return this.value instanceof Number || this.value instanceof String || this.value instanceof Boolean;
    }
}

