/*
 * Decompiled with CFR 0.152.
 */
package com.fusesource.ide.jvmmonitor.internal.ui.properties.mbean;

import com.fusesource.ide.jvmmonitor.internal.ui.properties.mbean.AttributeNode;
import java.util.ArrayList;
import java.util.List;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.TabularData;

public class AttributeParser {
    protected void parseObject(StringBuffer buffer, Object object, int indentation) {
        int indent = indentation;
        if (object instanceof CompositeData) {
            CompositeData compositeData = (CompositeData)object;
            for (String key : compositeData.getCompositeType().keySet()) {
                Object value = compositeData.get(key);
                if (value instanceof CompositeData) {
                    buffer.append(key).append(":\n");
                    this.parseObject(buffer, value, ++indent);
                    continue;
                }
                int i = 0;
                while (i < indent) {
                    buffer.append('\t');
                    ++i;
                }
                buffer.append(key).append(": ").append(value).append('\n');
            }
        }
    }

    protected void refreshAttribute(AttributeNode node) {
        Object value = node.getValue();
        if (value instanceof CompositeData) {
            this.refreshCompositeData(node);
        } else if (value instanceof TabularData) {
            this.refreshTabularData(node);
        } else if (value instanceof CompositeData[]) {
            this.refreshCompositeDataArray(node);
        } else if (value instanceof Object[]) {
            this.refreshObjectArray(node);
        } else if (value instanceof byte[] || value instanceof short[] || value instanceof int[] || value instanceof long[] || value instanceof float[] || value instanceof double[]) {
            this.refreshPrimitiveArray(node);
        }
    }

    private void refreshCompositeData(AttributeNode node) {
        ArrayList<AttributeNode> children = new ArrayList<AttributeNode>();
        CompositeData compositeData = (CompositeData)node.getValue();
        CompositeType type = compositeData.getCompositeType();
        for (String key : type.keySet()) {
            AttributeNode attribute = null;
            for (AttributeNode child : node.getChildren()) {
                if (!child.getName().equals(key)) continue;
                attribute = child;
                attribute.setValue(compositeData.get(key));
                break;
            }
            if (attribute == null) {
                attribute = new AttributeNode(key, node, compositeData.get(key));
            }
            children.add(attribute);
        }
        node.removeChildren();
        for (AttributeNode child : children) {
            node.addChild(child);
            this.refreshAttribute(child);
        }
    }

    private void refreshCompositeDataArray(AttributeNode node) {
        ArrayList<AttributeNode> children = new ArrayList<AttributeNode>();
        CompositeData[] values = (CompositeData[])node.getValue();
        int i = 0;
        while (i < values.length) {
            String name = String.valueOf(CompositeData.class.getSimpleName()) + "[" + i + "]";
            AttributeNode attribute = null;
            for (AttributeNode child : node.getChildren()) {
                if (!child.getName().equals(name)) continue;
                attribute = child;
                attribute.setValue(values[i]);
                break;
            }
            if (attribute == null) {
                attribute = new AttributeNode(name, node, values[i]);
            }
            children.add(attribute);
            ++i;
        }
        node.removeChildren();
        for (AttributeNode child : children) {
            node.addChild(child);
            this.refreshAttribute(child);
        }
    }

    private void refreshTabularData(AttributeNode node) {
        ArrayList<AttributeNode> children = new ArrayList<AttributeNode>();
        TabularData tabularData = (TabularData)node.getValue();
        for (Object keyList : tabularData.keySet()) {
            Object[] keys = ((List)keyList).toArray(new Object[0]);
            AttributeNode attribute = null;
            for (AttributeNode child : node.getChildren()) {
                if (!child.getName().equals(String.valueOf(keys[0]))) continue;
                attribute = child;
                attribute.setValue(tabularData.get(keys));
                break;
            }
            if (attribute == null) {
                attribute = new AttributeNode(String.valueOf(keys[0]), node, tabularData.get(keys));
            }
            children.add(attribute);
        }
        node.removeChildren();
        for (AttributeNode child : children) {
            node.addChild(child);
            this.refreshAttribute(child);
        }
    }

    private void refreshPrimitiveArray(AttributeNode node) {
        ArrayList<AttributeNode> children = new ArrayList<AttributeNode>();
        Object value = node.getValue();
        Number[] numbers = this.getNumbers(value);
        int i = 0;
        while (i < numbers.length) {
            AttributeNode attribute = null;
            String name = String.valueOf(value.getClass().getComponentType().getSimpleName()) + "[" + i + "]";
            for (AttributeNode child : node.getChildren()) {
                if (!child.getName().equals(name)) continue;
                attribute = child;
                attribute.setValue(numbers[i]);
                break;
            }
            if (attribute == null) {
                attribute = new AttributeNode(name, node, numbers[i]);
            }
            children.add(attribute);
            ++i;
        }
        node.removeChildren();
        for (AttributeNode child : children) {
            node.addChild(child);
            this.refreshAttribute(child);
        }
    }

    private void refreshObjectArray(AttributeNode node) {
        ArrayList<AttributeNode> children = new ArrayList<AttributeNode>();
        Object[] objects = (Object[])node.getValue();
        int i = 0;
        while (i < objects.length) {
            AttributeNode attribute = null;
            String name = String.valueOf(objects.getClass().getComponentType().getSimpleName()) + "[" + i + "]";
            for (AttributeNode child : node.getChildren()) {
                if (!child.getName().equals(name)) continue;
                attribute = child;
                attribute.setValue(objects[i]);
                break;
            }
            if (attribute == null) {
                attribute = new AttributeNode(name, node, objects[i]);
            }
            children.add(attribute);
            ++i;
        }
        node.removeChildren();
        for (AttributeNode child : children) {
            node.addChild(child);
            this.refreshAttribute(child);
        }
    }

    private Number[] getNumbers(Object value) {
        Number[] numbers;
        block7: {
            block11: {
                block10: {
                    block9: {
                        block8: {
                            block6: {
                                numbers = null;
                                if (!(value instanceof byte[])) break block6;
                                byte[] array = (byte[])value;
                                numbers = new Number[array.length];
                                int i = 0;
                                while (i < array.length) {
                                    numbers[i] = array[i];
                                    ++i;
                                }
                                break block7;
                            }
                            if (!(value instanceof short[])) break block8;
                            short[] array = (short[])value;
                            numbers = new Number[array.length];
                            int i = 0;
                            while (i < array.length) {
                                numbers[i] = array[i];
                                ++i;
                            }
                            break block7;
                        }
                        if (!(value instanceof int[])) break block9;
                        int[] array = (int[])value;
                        numbers = new Number[array.length];
                        int i = 0;
                        while (i < array.length) {
                            numbers[i] = array[i];
                            ++i;
                        }
                        break block7;
                    }
                    if (!(value instanceof long[])) break block10;
                    long[] array = (long[])value;
                    numbers = new Number[array.length];
                    int i = 0;
                    while (i < array.length) {
                        numbers[i] = array[i];
                        ++i;
                    }
                    break block7;
                }
                if (!(value instanceof float[])) break block11;
                float[] array = (float[])value;
                numbers = new Number[array.length];
                int i = 0;
                while (i < array.length) {
                    numbers[i] = Float.valueOf(array[i]);
                    ++i;
                }
                break block7;
            }
            if (!(value instanceof double[])) break block7;
            double[] array = (double[])value;
            numbers = new Number[array.length];
            int i = 0;
            while (i < array.length) {
                numbers[i] = array[i];
                ++i;
            }
        }
        return numbers;
    }
}

