/*
 * Decompiled with CFR 0.152.
 */
package com.fusesource.ide.jvmmonitor.internal.ui.properties.mbean;

import com.fusesource.ide.jvmmonitor.core.IActiveJvm;
import com.fusesource.ide.jvmmonitor.core.JvmCoreException;
import com.fusesource.ide.jvmmonitor.internal.ui.RefreshJob;
import com.fusesource.ide.jvmmonitor.internal.ui.actions.CopyAction;
import com.fusesource.ide.jvmmonitor.internal.ui.actions.ShowInTimelineAction;
import com.fusesource.ide.jvmmonitor.internal.ui.properties.AbstractJvmPropertySection;
import com.fusesource.ide.jvmmonitor.internal.ui.properties.PropertiesFilteredTree;
import com.fusesource.ide.jvmmonitor.internal.ui.properties.mbean.AttributeContentProvider;
import com.fusesource.ide.jvmmonitor.internal.ui.properties.mbean.AttributeLabelProvider;
import com.fusesource.ide.jvmmonitor.internal.ui.properties.mbean.AttributeNode;
import com.fusesource.ide.jvmmonitor.internal.ui.properties.mbean.MBeanName;
import com.fusesource.ide.jvmmonitor.internal.ui.properties.mbean.MBeanType;
import com.fusesource.ide.jvmmonitor.internal.ui.properties.mbean.Messages;
import com.fusesource.ide.jvmmonitor.internal.ui.properties.timeline.MBeanAttribute;
import com.fusesource.ide.jvmmonitor.ui.Activator;
import java.util.ArrayList;
import java.util.List;
import javax.management.Attribute;
import javax.management.ObjectName;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellEditorListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.views.properties.PropertySheet;

public class AttributesTab
extends Composite {
    static final String[] BOOLEAN_ITEMS = new String[]{Boolean.TRUE.toString(), Boolean.FALSE.toString()};
    TreeViewer viewer;
    boolean selected;
    boolean editorActivated;
    AttributeContentProvider contentProvider;
    ObjectName objectName;
    private Image attributeImage;
    protected AbstractJvmPropertySection section;

    public AttributesTab(CTabFolder tabFolder, AbstractJvmPropertySection section) {
        super((Composite)tabFolder, 0);
        this.section = section;
        final CTabItem tabItem = new CTabItem(tabFolder, 0);
        tabItem.setText(Messages.attributesTabLabel);
        tabItem.setImage(this.getAttributeImage());
        tabItem.setControl((Control)this);
        tabFolder.setSelection(tabItem);
        this.selected = true;
        this.editorActivated = false;
        tabFolder.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (e.item instanceof CTabItem) {
                    CTabItem item = (CTabItem)e.item;
                    AttributesTab.this.selected = item.equals(tabItem);
                }
            }
        });
        this.createViewer();
    }

    public void dispose() {
        super.dispose();
        if (this.attributeImage != null) {
            this.attributeImage.dispose();
        }
    }

    protected void selectionChanged(ISelection selection) {
        if (selection instanceof IStructuredSelection) {
            Object element = ((IStructuredSelection)selection).getFirstElement();
            this.objectName = this.getObjectName(element);
        }
        this.refresh(true);
    }

    protected void refresh() {
        this.refresh(false);
    }

    protected void deactivated() {
        Job.getJobManager().cancel((Object)this.toString());
    }

    private void createViewer() {
        this.setLayout((Layout)new FillLayout());
        Composite composite = new Composite((Composite)this, 0);
        GridLayout layout = new GridLayout(1, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        composite.setLayout((Layout)layout);
        PropertySheet propertySheet = (PropertySheet)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActivePart();
        PropertiesFilteredTree filteredTree = new PropertiesFilteredTree(composite, propertySheet.getViewSite().getActionBars()){
            private ShowInTimelineAction showInTimelineAction;

            @Override
            protected List<Action> createActions(IActionBars actionBars) {
                ArrayList<Action> actions = new ArrayList<Action>();
                CopyAction copyAction = CopyAction.createCopyAction(actionBars);
                actions.add(copyAction);
                this.showInTimelineAction = new MyShowInTimelineAction(AttributesTab.this.section);
                actions.add(this.showInTimelineAction);
                return actions;
            }

            @Override
            public void menuAboutToshow() {
            }
        };
        this.viewer = filteredTree.getViewer();
        filteredTree.setEditingSupport(new MyEditingSupport((ColumnViewer)this.viewer));
        this.contentProvider = new AttributeContentProvider();
        this.viewer.setContentProvider((IContentProvider)this.contentProvider);
        this.viewer.setLabelProvider((IBaseLabelProvider)new AttributeLabelProvider(this.viewer));
        this.viewer.setInput(new Object());
    }

    private ObjectName getObjectName(Object element) {
        if (element instanceof MBeanType) {
            MBeanName[] mBeanNames = ((MBeanType)element).getMBeanNames();
            if (mBeanNames.length == 1) {
                return mBeanNames[0].getObjectName();
            }
        } else if (element instanceof MBeanName) {
            return ((MBeanName)element).getObjectName();
        }
        return null;
    }

    private void refresh(boolean force) {
        if (!(force || this.selected && !this.editorActivated)) {
            return;
        }
        new RefreshJob(Messages.refreshAttributeTabJobLabel, this.toString()){

            @Override
            protected void refreshModel(IProgressMonitor monitor) {
                IActiveJvm jvm = AttributesTab.this.section.getJvm();
                if (jvm != null && AttributesTab.this.objectName != null && jvm.isConnected() && !AttributesTab.this.section.isRefreshSuspended()) {
                    AttributesTab.this.contentProvider.refresh(jvm, AttributesTab.this.objectName);
                }
            }

            @Override
            protected void refreshUI() {
                if (!AttributesTab.this.viewer.getControl().isDisposed()) {
                    AttributesTab.this.viewer.refresh();
                }
            }
        }.schedule();
    }

    private Image getAttributeImage() {
        if (this.attributeImage == null || this.attributeImage.isDisposed()) {
            this.attributeImage = Activator.getImageDescriptor("icons/full/obj16/attribute.gif").createImage();
        }
        return this.attributeImage;
    }

    private class MyEditingSupport
    extends EditingSupport {
        public MyEditingSupport(ColumnViewer viewer) {
            super(viewer);
        }

        protected CellEditor getCellEditor(Object element) {
            AttributesTab.this.editorActivated = true;
            if (element instanceof AttributeNode) {
                AttributeNode node = (AttributeNode)element;
                Object editor = node.getValue() instanceof Boolean ? new ComboBoxCellEditor((Composite)AttributesTab.this.viewer.getTree(), BOOLEAN_ITEMS) : new TextCellEditor((Composite)AttributesTab.this.viewer.getTree());
                editor.addListener(new ICellEditorListener(){

                    public void editorValueChanged(boolean oldValidState, boolean newValidState) {
                    }

                    public void cancelEditor() {
                        ((MyEditingSupport)MyEditingSupport.this).AttributesTab.this.editorActivated = false;
                    }

                    public void applyEditorValue() {
                        ((MyEditingSupport)MyEditingSupport.this).AttributesTab.this.editorActivated = false;
                    }
                });
                return editor;
            }
            return null;
        }

        protected boolean canEdit(Object element) {
            if (element instanceof AttributeNode) {
                AttributeNode node = (AttributeNode)element;
                return node.isWritable();
            }
            return false;
        }

        protected Object getValue(Object element) {
            if (element instanceof AttributeNode) {
                AttributeNode node = (AttributeNode)element;
                Object value = node.getValue();
                if (value instanceof Boolean) {
                    return Boolean.TRUE.equals(value) ? 0 : 1;
                }
                return String.valueOf(value);
            }
            return element;
        }

        protected void setValue(Object element, final Object value) {
            if (!(element instanceof AttributeNode)) {
                return;
            }
            final AttributeNode node = (AttributeNode)element;
            new RefreshJob(Messages.setPropertyValueJobLabel, String.valueOf(value.hashCode())){

                @Override
                protected void refreshModel(IProgressMonitor monitor) {
                    Object adjustedValue = value;
                    try {
                        if (node.getValue() instanceof Boolean) {
                            adjustedValue = (Integer)value == 0 ? Boolean.TRUE : Boolean.FALSE;
                        } else if (node.getValue() instanceof Number) {
                            try {
                                adjustedValue = MyEditingSupport.this.getNumber(node.getValue().getClass(), (String)value);
                            }
                            catch (NumberFormatException numberFormatException) {
                                return;
                            }
                        }
                        IActiveJvm jvm = ((MyEditingSupport)MyEditingSupport.this).AttributesTab.this.section.getJvm();
                        if (jvm == null) {
                            return;
                        }
                        jvm.getMBeanServer().setAttribute(((MyEditingSupport)MyEditingSupport.this).AttributesTab.this.objectName, new Attribute(node.getName(), adjustedValue));
                    }
                    catch (JvmCoreException e) {
                        Activator.log(Messages.setMBeanAttributeFailedMsg, (CoreException)((Object)e));
                    }
                }

                @Override
                protected void refreshUI() {
                    AttributesTab.this.refresh();
                }
            }.schedule();
        }

        protected Number getNumber(Class<?> clazz, String value) {
            if (clazz == Byte.class) {
                return Byte.valueOf(value);
            }
            if (clazz == Short.class) {
                return Short.valueOf(value);
            }
            if (clazz == Integer.class) {
                return Integer.valueOf(value);
            }
            if (clazz == Long.class) {
                return Long.valueOf(value);
            }
            if (clazz == Float.class) {
                return Float.valueOf(value);
            }
            if (clazz == Double.class) {
                return Double.valueOf(value);
            }
            return null;
        }
    }

    private class MyShowInTimelineAction
    extends ShowInTimelineAction {
        public MyShowInTimelineAction(AbstractJvmPropertySection section) {
            super(section);
        }

        @Override
        public MBeanAttribute getMBeanAttribute(Object element) {
            if (!(element instanceof AttributeNode)) {
                return null;
            }
            AttributeNode node = (AttributeNode)element;
            String qualifiedName = node.getName();
            while (node.getParent() != null) {
                node = node.getParent();
                qualifiedName = String.valueOf(node.getName()) + '.' + qualifiedName;
            }
            return new MBeanAttribute(AttributesTab.this.objectName, qualifiedName, this.getRGB(qualifiedName));
        }

        @Override
        protected boolean getEnabled(Object element) {
            if (!(element instanceof AttributeNode)) {
                return false;
            }
            AttributeNode attribute = (AttributeNode)element;
            return attribute.getValue() instanceof Number;
        }

        private RGB getRGB(String string) {
            int hashCode = string.hashCode();
            int r = (hashCode >> 3) % 256;
            int g = (hashCode >> 1) % 256;
            int b = hashCode % 256;
            return new RGB(Math.abs(r), Math.abs(g), Math.abs(b));
        }
    }
}

