/*
 * Decompiled with CFR 0.152.
 */
package com.fusesource.ide.jvmmonitor.internal.ui.properties.mbean;

import com.fusesource.ide.jvmmonitor.core.Activator;
import com.fusesource.ide.jvmmonitor.core.IActiveJvm;
import com.fusesource.ide.jvmmonitor.core.JvmCoreException;
import com.fusesource.ide.jvmmonitor.internal.ui.properties.mbean.JMXUtils;
import com.fusesource.ide.jvmmonitor.internal.ui.properties.mbean.MBeanDomain;
import com.fusesource.ide.jvmmonitor.internal.ui.properties.mbean.MBeanName;
import com.fusesource.ide.jvmmonitor.internal.ui.properties.mbean.MBeanType;
import com.fusesource.ide.jvmmonitor.internal.ui.properties.mbean.Messages;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.management.MBeanInfo;
import javax.management.ObjectName;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;

public class MBeanContentProvider
implements ITreeContentProvider {
    private Map<String, MBeanDomain> domains = new HashMap<String, MBeanDomain>();

    public Object[] getElements(Object inputElement) {
        return this.domains.values().toArray(new MBeanDomain[0]);
    }

    public Object[] getChildren(Object parentElement) {
        if (parentElement instanceof MBeanDomain) {
            return ((MBeanDomain)parentElement).getMBeanTypes();
        }
        if (parentElement instanceof MBeanType) {
            return ((MBeanType)parentElement).getMBeanNames();
        }
        return null;
    }

    public Object getParent(Object element) {
        if (element instanceof MBeanType) {
            return ((MBeanType)element).getMBeanDomain();
        }
        return null;
    }

    public boolean hasChildren(Object element) {
        if (element instanceof MBeanDomain) {
            return true;
        }
        if (element instanceof MBeanType) {
            return ((MBeanType)element).getMBeanNames().length > 1;
        }
        return false;
    }

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        this.domains.clear();
    }

    public void refresh(IActiveJvm jvm) {
        HashMap<String, MBeanDomain> newDomains = new HashMap<String, MBeanDomain>();
        for (ObjectName objectName : this.getObjectNames(jvm)) {
            MBeanDomain domain;
            String domainName = objectName.getDomain();
            if (this.domains.containsKey(domainName)) {
                domain = this.domains.get(domainName);
                newDomains.put(domainName, domain);
            } else if (newDomains.containsKey(domainName)) {
                domain = (MBeanDomain)newDomains.get(domainName);
            } else {
                domain = new MBeanDomain(domainName);
                newDomains.put(domainName, domain);
            }
            String typeName = JMXUtils.getTypeName(objectName);
            MBeanType type = domain.getMBeanType(typeName);
            if (type == null) {
                type = new MBeanType(jvm, typeName, domain);
                domain.putMBeanType(typeName, type);
            } else {
                type.setJvm(jvm);
            }
            MBeanName mBeanName = type.getMBeanName(objectName);
            if (mBeanName == null) {
                MBeanInfo info = this.getMBeanInfo(jvm, objectName);
                mBeanName = new MBeanName(objectName, jvm, info.getNotifications().length > 0);
            }
            type.addMBeanName(mBeanName);
        }
        this.domains = newDomains;
    }

    private Set<ObjectName> getObjectNames(IActiveJvm jvm) {
        try {
            return jvm.getMBeanServer().queryNames(null);
        }
        catch (JvmCoreException e) {
            Activator.log((int)4, (String)Messages.getMBeanObjectNamesFailedMsg, (Throwable)e);
            return new HashSet<ObjectName>();
        }
    }

    private MBeanInfo getMBeanInfo(IActiveJvm jvm, ObjectName objectName) {
        try {
            return jvm.getMBeanServer().getMBeanInfo(objectName);
        }
        catch (JvmCoreException e) {
            Activator.log((int)4, (String)Messages.getMBeanInfoFailedMsg, (Throwable)e);
            return null;
        }
    }
}

