/*
 * Decompiled with CFR 0.152.
 */
package com.fusesource.ide.jvmmonitor.internal.ui.properties.mbean;

import com.fusesource.ide.jvmmonitor.core.IActiveJvm;
import com.fusesource.ide.jvmmonitor.internal.ui.properties.mbean.MBeanDomain;
import com.fusesource.ide.jvmmonitor.internal.ui.properties.mbean.MBeanName;
import com.fusesource.ide.jvmmonitor.internal.ui.properties.mbean.MBeanType;
import com.fusesource.ide.jvmmonitor.ui.Activator;
import javax.management.ObjectName;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.swt.graphics.Image;

public class MBeanLabelProvider
implements DelegatingStyledCellLabelProvider.IStyledLabelProvider {
    private static final String NAME_PROPERTY = "name=";
    private Image mBeanImage;
    private Image mBeanFolderImage;

    public StyledString getStyledText(Object element) {
        StyledString text = new StyledString();
        boolean appendSuffix = false;
        ObjectName objectName = null;
        IActiveJvm jvm = null;
        if (element instanceof MBeanDomain) {
            text.append(((MBeanDomain)element).getDomainName());
        } else if (element instanceof MBeanType) {
            MBeanName[] mBeanNames = ((MBeanType)element).getMBeanNames();
            text.append(((MBeanType)element).getName());
            if (mBeanNames.length == 1 && mBeanNames[0].isNotificationSubsctibed()) {
                appendSuffix = true;
                objectName = mBeanNames[0].getObjectName();
                jvm = ((MBeanType)element).getJvm();
            }
        } else if (element instanceof MBeanName) {
            objectName = ((MBeanName)element).getObjectName();
            text.append(this.getName(objectName));
            if (((MBeanName)element).isNotificationSubsctibed()) {
                appendSuffix = true;
                jvm = ((MBeanName)element).getJvm();
            }
        }
        if (appendSuffix && jvm != null) {
            int notificationCount = jvm.getMBeanServer().getMBeanNotification().getNotifications(objectName).length;
            String suffix = " [notifications: " + notificationCount + "]";
            int offset = text.length();
            text.append(suffix);
            text.setStyle(offset, suffix.length(), StyledString.DECORATIONS_STYLER);
        }
        return text;
    }

    public Image getImage(Object element) {
        if (element instanceof MBeanDomain) {
            return this.getMBeanFolderImage();
        }
        if (element instanceof MBeanType) {
            MBeanName[] mBeanNames = ((MBeanType)element).getMBeanNames();
            if (mBeanNames.length > 1) {
                return this.getMBeanFolderImage();
            }
            return this.getMBeanImage();
        }
        if (element instanceof MBeanName) {
            return this.getMBeanImage();
        }
        return null;
    }

    public void dispose() {
        if (this.mBeanImage != null) {
            this.mBeanImage.dispose();
        }
        if (this.mBeanFolderImage != null) {
            this.mBeanFolderImage.dispose();
        }
    }

    public void addListener(ILabelProviderListener listener) {
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void removeListener(ILabelProviderListener listener) {
    }

    private String getName(ObjectName objectName) {
        String canonicalName = objectName.getCanonicalName();
        if (!canonicalName.contains(NAME_PROPERTY)) {
            return canonicalName;
        }
        String type = canonicalName.split(NAME_PROPERTY)[1];
        return type.split(",")[0];
    }

    private Image getMBeanImage() {
        if (this.mBeanImage == null || this.mBeanImage.isDisposed()) {
            this.mBeanImage = Activator.getImageDescriptor("icons/full/obj16/mbean.gif").createImage();
        }
        return this.mBeanImage;
    }

    private Image getMBeanFolderImage() {
        if (this.mBeanFolderImage == null || this.mBeanFolderImage.isDisposed()) {
            this.mBeanFolderImage = Activator.getImageDescriptor("icons/full/obj16/mbean_folder.gif").createImage();
        }
        return this.mBeanFolderImage;
    }
}

