/*
 * Decompiled with CFR 0.152.
 */
package com.fusesource.ide.jvmmonitor.internal.ui.properties.mbean;

import com.fusesource.ide.jvmmonitor.core.IActiveJvm;
import com.fusesource.ide.jvmmonitor.internal.ui.RefreshJob;
import com.fusesource.ide.jvmmonitor.internal.ui.properties.AbstractJvmPropertySection;
import com.fusesource.ide.jvmmonitor.internal.ui.properties.AbstractSashForm;
import com.fusesource.ide.jvmmonitor.internal.ui.properties.mbean.MBeanContentProvider;
import com.fusesource.ide.jvmmonitor.internal.ui.properties.mbean.MBeanFilteredTree;
import com.fusesource.ide.jvmmonitor.internal.ui.properties.mbean.MBeanLabelProvider;
import com.fusesource.ide.jvmmonitor.internal.ui.properties.mbean.MBeanTabFolder;
import com.fusesource.ide.jvmmonitor.internal.ui.properties.mbean.Messages;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.viewers.DecoratingStyledCellLabelProvider;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.PlatformUI;

public class MBeanSashForm
extends AbstractSashForm {
    private static final int[] SASH_WEIGHTS = new int[]{40, 60};
    TreeViewer mBeanViewer;
    MBeanTabFolder mBeanTabFolder;
    MBeanContentProvider mBeanContentProvider;
    ISelectionChangedListener selectionChangedListener;
    AbstractJvmPropertySection section;

    public MBeanSashForm(Composite parent, AbstractJvmPropertySection section) {
        super(parent, section.getActionBars(), SASH_WEIGHTS);
        this.section = section;
        this.createSashFormControls(this, section.getActionBars());
        this.setWeights(this.initialSashWeights);
    }

    @Override
    protected void createSashFormControls(SashForm sashForm, IActionBars actionBars) {
        this.mBeanViewer = new MBeanFilteredTree((Composite)sashForm, this.section).getViewer();
        this.mBeanContentProvider = new MBeanContentProvider();
        this.mBeanViewer.setContentProvider((IContentProvider)this.mBeanContentProvider);
        this.mBeanViewer.setLabelProvider((IBaseLabelProvider)new MyDecoratingStyledCellLabelProvider());
        this.selectionChangedListener = new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                MBeanSashForm.this.mBeanTabFolder.selectionChanged(event.getSelection());
            }
        };
        this.mBeanViewer.addSelectionChangedListener(this.selectionChangedListener);
        this.mBeanViewer.setInput(new Object());
        this.mBeanTabFolder = new MBeanTabFolder(sashForm, this.section);
    }

    protected void refresh() {
        new RefreshJob(Messages.refreshMBeanSectionJobLabel, this.toString()){

            @Override
            protected void refreshModel(IProgressMonitor monitor) {
                IActiveJvm jvm = MBeanSashForm.this.section.getJvm();
                if (jvm != null && jvm.isConnected()) {
                    MBeanSashForm.this.mBeanContentProvider.refresh(jvm);
                }
            }

            @Override
            protected void refreshUI() {
                if (MBeanSashForm.this.mBeanViewer.getControl().isDisposed() || MBeanSashForm.this.mBeanTabFolder.isDisposed()) {
                    return;
                }
                MBeanSashForm.this.mBeanViewer.refresh();
                MBeanSashForm.this.mBeanTabFolder.refresh();
                IActiveJvm jvm = MBeanSashForm.this.section.getJvm();
                if (jvm == null || !jvm.isConnected()) {
                    MBeanSashForm.this.mBeanViewer.removeSelectionChangedListener(MBeanSashForm.this.selectionChangedListener);
                    return;
                }
                MBeanSashForm.this.mBeanViewer.addSelectionChangedListener(MBeanSashForm.this.selectionChangedListener);
                if (MBeanSashForm.this.mBeanViewer.getSelection().isEmpty()) {
                    TreeItem[] items = MBeanSashForm.this.mBeanViewer.getTree().getItems();
                    if (items != null && items.length > 0) {
                        MBeanSashForm.this.mBeanViewer.getTree().select(items[0]);
                        MBeanSashForm.this.mBeanTabFolder.selectionChanged(MBeanSashForm.this.mBeanViewer.getSelection());
                    } else {
                        MBeanSashForm.this.mBeanTabFolder.selectionChanged(null);
                    }
                }
            }
        }.schedule();
    }

    protected void deactivated() {
        Job.getJobManager().cancel((Object)this.toString());
        if (!this.mBeanTabFolder.isDisposed()) {
            this.mBeanTabFolder.deactivated();
        }
    }

    private static class MyDecoratingStyledCellLabelProvider
    extends DecoratingStyledCellLabelProvider
    implements ILabelProvider {
        public MyDecoratingStyledCellLabelProvider() {
            super((DelegatingStyledCellLabelProvider.IStyledLabelProvider)new MBeanLabelProvider(), PlatformUI.getWorkbench().getDecoratorManager().getLabelDecorator(), null);
        }

        public String getText(Object element) {
            return this.getStyledStringProvider().getStyledText(element).toString();
        }
    }
}

