/*
 * Decompiled with CFR 0.152.
 */
package com.fusesource.ide.jvmmonitor.internal.ui.properties.mbean;

import com.fusesource.ide.jvmmonitor.internal.ui.properties.AbstractJvmPropertySection;
import com.fusesource.ide.jvmmonitor.internal.ui.properties.mbean.AttributesTab;
import com.fusesource.ide.jvmmonitor.internal.ui.properties.mbean.MBeanDomain;
import com.fusesource.ide.jvmmonitor.internal.ui.properties.mbean.MBeanName;
import com.fusesource.ide.jvmmonitor.internal.ui.properties.mbean.MBeanType;
import com.fusesource.ide.jvmmonitor.internal.ui.properties.mbean.Messages;
import com.fusesource.ide.jvmmonitor.internal.ui.properties.mbean.NotificationsTab;
import com.fusesource.ide.jvmmonitor.internal.ui.properties.mbean.OperationsTab;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.ui.part.PageBook;

public class MBeanTabFolder
extends PageBook {
    private AttributesTab attributeTab;
    private OperationsTab operationsTab;
    private NotificationsTab notificationTab;
    private Label message;
    private CTabFolder folder = new CTabFolder((Composite)this, 1024);

    public MBeanTabFolder(SashForm sashForm, AbstractJvmPropertySection propertySection) {
        super((Composite)sashForm, 0);
        this.attributeTab = new AttributesTab(this.folder, propertySection);
        this.operationsTab = new OperationsTab(this.folder, propertySection);
        this.notificationTab = new NotificationsTab(this.folder, propertySection);
        this.message = new Label((Composite)this, 0);
        this.message.setText(Messages.mBeanNotSelectedMessage);
        this.message.setBackground(Display.getDefault().getSystemColor(25));
        this.showPage((Control)this.message);
    }

    public void selectionChanged(ISelection selection) {
        if (this.isFolderSelected(selection)) {
            this.showPage((Control)this.message);
        } else {
            this.showPage((Control)this.folder);
            this.attributeTab.selectionChanged(selection);
            this.operationsTab.selectionChanged(selection);
            this.notificationTab.selectionChanged(selection);
        }
    }

    protected void refresh() {
        this.attributeTab.refresh();
        this.operationsTab.refresh();
        this.notificationTab.refresh();
    }

    protected void deactivated() {
        this.attributeTab.deactivated();
        this.operationsTab.deactivated();
        this.notificationTab.deactivated();
    }

    private boolean isFolderSelected(ISelection selection) {
        if (!(selection instanceof StructuredSelection)) {
            return false;
        }
        Object firstElement = ((StructuredSelection)selection).getFirstElement();
        if (firstElement instanceof MBeanDomain) {
            return true;
        }
        if (firstElement instanceof MBeanName) {
            return false;
        }
        if (firstElement instanceof MBeanType) {
            MBeanType mbeanType = (MBeanType)firstElement;
            return mbeanType.getMBeanNames().length > 1;
        }
        return false;
    }
}

