/*
 * Decompiled with CFR 0.152.
 */
package com.fusesource.ide.jvmmonitor.internal.ui.properties.mbean;

import com.fusesource.ide.jvmmonitor.core.IActiveJvm;
import com.fusesource.ide.jvmmonitor.internal.ui.properties.mbean.MBeanDomain;
import com.fusesource.ide.jvmmonitor.internal.ui.properties.mbean.MBeanName;
import java.util.HashSet;
import java.util.Set;
import javax.management.ObjectName;

public class MBeanType {
    private String mBeanType;
    private Set<MBeanName> mBeanNames;
    private MBeanDomain mBeanDomain;
    private IActiveJvm jvm;

    public MBeanType(IActiveJvm jvm, String type, MBeanDomain mBeanDomain) {
        this.jvm = jvm;
        this.mBeanType = type;
        this.mBeanDomain = mBeanDomain;
        this.mBeanNames = new HashSet<MBeanName>();
    }

    public MBeanDomain getMBeanDomain() {
        return this.mBeanDomain;
    }

    public MBeanName[] getMBeanNames() {
        return this.mBeanNames.toArray(new MBeanName[0]);
    }

    public void addMBeanName(MBeanName mBeanName) {
        this.mBeanNames.add(mBeanName);
    }

    public MBeanName getMBeanName(ObjectName objectName) {
        for (MBeanName mBean : this.mBeanNames) {
            if (!mBean.getObjectName().getCanonicalName().equals(objectName.getCanonicalName())) continue;
            return mBean;
        }
        return null;
    }

    protected String getName() {
        return this.mBeanType;
    }

    protected IActiveJvm getJvm() {
        return this.jvm;
    }

    protected void setJvm(IActiveJvm jvm) {
        this.jvm = jvm;
    }
}

