/*
 * Decompiled with CFR 0.152.
 */
package com.fusesource.ide.jvmmonitor.internal.ui.properties.mbean;

import com.fusesource.ide.jvmmonitor.core.IActiveJvm;
import com.fusesource.ide.jvmmonitor.internal.ui.actions.CopyAction;
import com.fusesource.ide.jvmmonitor.internal.ui.properties.AbstractJvmPropertySection;
import com.fusesource.ide.jvmmonitor.internal.ui.properties.mbean.Messages;
import com.fusesource.ide.jvmmonitor.internal.ui.properties.mbean.NotificationColumn;
import com.fusesource.ide.jvmmonitor.internal.ui.properties.mbean.NotificationComparator;
import com.fusesource.ide.jvmmonitor.internal.ui.properties.mbean.NotificationDetailsDialogAction;
import com.fusesource.ide.jvmmonitor.internal.ui.properties.mbean.NotificationsContentProvider;
import com.fusesource.ide.jvmmonitor.internal.ui.properties.mbean.NotificationsLabelProvider;
import com.fusesource.ide.jvmmonitor.internal.ui.properties.mbean.NotificationsTab;
import com.fusesource.ide.jvmmonitor.internal.ui.properties.thread.ConfigurableFilteredTree;
import com.fusesource.rider.commons.ui.IConfigurableColumns;
import com.fusesource.rider.commons.ui.Trees;
import com.fusesource.rider.commons.ui.actions.ConfigureColumnsAction;
import com.fusesource.rider.commons.ui.config.ColumnConfiguration;
import java.util.ArrayList;
import java.util.List;
import javax.management.Notification;
import javax.management.ObjectName;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.dialogs.PatternFilter;

public class NotificationFilteredTree
extends ConfigurableFilteredTree
implements IConfigurableColumns,
IDoubleClickListener {
    ConfigureColumnsAction configureColumnsAction;
    Action clearAction;
    NotificationDetailsDialogAction detailsAction;
    NotificationsTab notificationsTab;
    private AbstractJvmPropertySection section;

    protected NotificationFilteredTree(NotificationsTab notificationsTab, AbstractJvmPropertySection section) {
        super((Composite)notificationsTab, 65538, new PatternFilter(), true);
        this.notificationsTab = notificationsTab;
        this.section = section;
        this.treeViewer.setLabelProvider((IBaseLabelProvider)new NotificationsLabelProvider(this.treeViewer));
        this.treeViewer.setContentProvider((IContentProvider)new NotificationsContentProvider());
        this.treeViewer.addDoubleClickListener((IDoubleClickListener)this);
        GridData gridData = new GridData(1808);
        gridData.horizontalIndent = 0;
        this.setLayoutData(gridData);
        this.configureTree();
        this.createContextMenu(section.getActionBars());
        this.setBackground(Display.getDefault().getSystemColor(1));
    }

    protected void createControl(Composite composite, int treeStyle) {
        super.createControl(composite, treeStyle);
        GridData data = (GridData)this.filterComposite.getLayoutData();
        data.horizontalIndent = 2;
        data.verticalIndent = 2;
        this.filterComposite.setLayoutData((Object)data);
    }

    public List<String> getColumns() {
        NotificationColumn[] values;
        ArrayList<String> columnLabels = new ArrayList<String>();
        NotificationColumn[] notificationColumnArray = values = NotificationColumn.values();
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            NotificationColumn value = notificationColumnArray[n2];
            columnLabels.add(value.label);
            ++n2;
        }
        return columnLabels;
    }

    public void updateColumnConfiguration() {
        this.configureTree();
    }

    public String getId() {
        return ((Object)((Object)this)).getClass().getName();
    }

    public boolean getDefaultVisibility(String column) {
        return NotificationColumn.getColumn((String)column).initialVisibility;
    }

    public void doubleClick(DoubleClickEvent event) {
        this.detailsAction.run();
    }

    public void setInput(ObjectName objectName) {
        IActiveJvm jvm = this.section.getJvm();
        if (objectName == null || jvm == null) {
            this.treeViewer.setInput(null);
            return;
        }
        this.treeViewer.setInput((Object)jvm.getMBeanServer().getMBeanNotification().getNotifications(objectName));
    }

    protected Notification getPrevItem() {
        Object selectedItem = ((StructuredSelection)this.getViewer().getSelection()).getFirstElement();
        TreeItem[] items = this.getViewer().getTree().getItems();
        int i = 0;
        while (i < items.length) {
            if (items[i].getData().equals(selectedItem) && i > 0) {
                return (Notification)items[i - 1].getData();
            }
            ++i;
        }
        return null;
    }

    protected Notification getNextItem() {
        Object selectedItem = ((StructuredSelection)this.getViewer().getSelection()).getFirstElement();
        TreeItem[] items = this.getViewer().getTree().getItems();
        int i = 0;
        while (i < items.length) {
            if (items[i].getData().equals(selectedItem) && i < items.length - 1) {
                return (Notification)items[i + 1].getData();
            }
            ++i;
        }
        return null;
    }

    protected void selectPrevItem() {
        Notification prevItem = this.getPrevItem();
        if (prevItem != null) {
            this.getViewer().setSelection((ISelection)new StructuredSelection((Object)prevItem), true);
        }
    }

    protected void selectNextItem() {
        Notification nextItem = this.getNextItem();
        if (nextItem != null) {
            this.getViewer().setSelection((ISelection)new StructuredSelection((Object)nextItem), true);
        }
    }

    @Override
    protected void configureTree() {
        Trees.disposeColumns((TreeViewer)this.getViewer());
        Tree tree = this.getViewer().getTree();
        tree.setLinesVisible(true);
        tree.setHeaderVisible(true);
        List columns = this.getConfiguration().getColumnConfigurations();
        for (ColumnConfiguration config : columns) {
            if (!config.isVisible()) continue;
            NotificationColumn column = NotificationColumn.getColumn(config.getName());
            TreeColumn treeColumn = new TreeColumn(this.getViewer().getTree(), 0);
            treeColumn.setText(column.label);
            treeColumn.setWidth(column.defalutWidth);
            treeColumn.setAlignment(column.initialAlignment);
            treeColumn.setToolTipText(column.toolTip);
            treeColumn.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    if (e.widget instanceof TreeColumn) {
                        NotificationFilteredTree.this.sortColumn((TreeColumn)e.widget);
                    }
                }
            });
        }
        this.getConfiguration().addColumnListeners(this.getViewer());
    }

    void sortColumn(TreeColumn treeColumn) {
        int columnIndex = this.getViewer().getTree().indexOf(treeColumn);
        NotificationComparator sorter = (NotificationComparator)this.getViewer().getComparator();
        if (sorter != null && columnIndex == sorter.getColumnIndex()) {
            sorter.reverseSortDirection();
        } else {
            sorter = new NotificationComparator(columnIndex);
            this.getViewer().setComparator((ViewerComparator)sorter);
        }
        this.getViewer().getTree().setSortColumn(treeColumn);
        this.getViewer().getTree().setSortDirection(sorter.getSortDirection());
        this.getViewer().refresh();
    }

    private void createContextMenu(IActionBars actionBars) {
        final CopyAction copyAction = CopyAction.createCopyAction(actionBars);
        this.clearAction = new Action(Messages.clearLabel){

            public void run() {
                NotificationFilteredTree.this.notificationsTab.clear();
            }
        };
        this.detailsAction = new NotificationDetailsDialogAction(this);
        this.configureColumnsAction = new ConfigureColumnsAction((IConfigurableColumns)this);
        this.getViewer().addSelectionChangedListener((ISelectionChangedListener)copyAction);
        this.getViewer().addSelectionChangedListener((ISelectionChangedListener)this.detailsAction);
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                manager.add((IAction)copyAction);
                manager.add((IContributionItem)new Separator());
                manager.add((IAction)NotificationFilteredTree.this.clearAction);
                manager.add((IContributionItem)new Separator());
                manager.add((IAction)NotificationFilteredTree.this.configureColumnsAction);
                manager.add((IContributionItem)new Separator());
                manager.add((IAction)NotificationFilteredTree.this.detailsAction);
            }
        });
        Menu menu = menuMgr.createContextMenu(this.getViewer().getControl());
        this.getViewer().getControl().setMenu(menu);
    }
}

