/*
 * Decompiled with CFR 0.152.
 */
package com.fusesource.ide.jvmmonitor.internal.ui.properties.mbean;

import com.fusesource.ide.jvmmonitor.core.IActiveJvm;
import com.fusesource.ide.jvmmonitor.internal.ui.RefreshJob;
import com.fusesource.ide.jvmmonitor.internal.ui.properties.AbstractJvmPropertySection;
import com.fusesource.ide.jvmmonitor.internal.ui.properties.mbean.MBeanName;
import com.fusesource.ide.jvmmonitor.internal.ui.properties.mbean.MBeanType;
import com.fusesource.ide.jvmmonitor.internal.ui.properties.mbean.Messages;
import com.fusesource.ide.jvmmonitor.internal.ui.properties.mbean.NotificationFilteredTree;
import com.fusesource.ide.jvmmonitor.internal.ui.properties.mbean.SubscribeAction;
import com.fusesource.ide.jvmmonitor.ui.Activator;
import javax.management.ObjectName;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Hyperlink;
import org.eclipse.ui.part.PageBook;

public class NotificationsTab
extends PageBook {
    TreeViewer treeViewer;
    CTabItem tabItem;
    private CTabFolder tabFolder;
    NotificationFilteredTree tree;
    Composite messagePage;
    ObjectName objectName;
    SubscribeAction subscribeAction;
    private Image notificationImage;
    AbstractJvmPropertySection section;

    public NotificationsTab(CTabFolder tabFolder, AbstractJvmPropertySection section) {
        super((Composite)tabFolder, 0);
        this.tabFolder = tabFolder;
        this.section = section;
        this.addTabItem();
        this.tree = new NotificationFilteredTree(this, section);
        this.tree.setLayoutData(null);
        this.treeViewer = this.tree.getViewer();
        this.messagePage = new Composite((Composite)this, 0);
        this.messagePage.setLayout((Layout)new GridLayout(3, false));
        FormToolkit toolkit = new FormToolkit(Display.getDefault());
        toolkit.createLabel(this.messagePage, Messages.notificationsNotSubscribedMsg);
        Hyperlink hyperlink = toolkit.createHyperlink(this.messagePage, Messages.subscribeLinkLabel, 0);
        toolkit.createLabel(this.messagePage, Messages.notificationsLabel);
        hyperlink.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                NotificationsTab.this.subscribeAction.run();
            }
        });
        this.messagePage.setBackground(Display.getDefault().getSystemColor(25));
        this.showPage((Control)this.tree);
        this.subscribeAction = new SubscribeAction(section);
    }

    public void dispose() {
        super.dispose();
        if (this.notificationImage != null) {
            this.notificationImage.dispose();
        }
    }

    public void selectionChanged(ISelection selection) {
        if (!(selection instanceof StructuredSelection)) {
            return;
        }
        this.objectName = this.getObjectName((StructuredSelection)selection);
        if (this.objectName == null) {
            return;
        }
        this.tree.setInput(this.objectName);
        this.subscribeAction.setSelection(this.objectName);
        this.refresh();
    }

    protected void refresh() {
        new RefreshJob(Messages.refreshNotificationTabJobLabel, this.toString()){
            private boolean isSubscribed;
            private boolean isSupported;

            @Override
            protected void refreshModel(IProgressMonitor monitor) {
                IActiveJvm jvm = NotificationsTab.this.section.getJvm();
                if (NotificationsTab.this.objectName == null || jvm == null || !jvm.isConnected()) {
                    return;
                }
                this.isSupported = jvm.getMBeanServer().getMBeanNotification().isSupported(NotificationsTab.this.objectName);
                if (this.isSupported) {
                    this.isSubscribed = jvm.getMBeanServer().getMBeanNotification().isSubscribed(NotificationsTab.this.objectName);
                }
            }

            @Override
            protected void refreshUI() {
                if (NotificationsTab.this.tree.isDisposed() || NotificationsTab.this.messagePage.isDisposed()) {
                    return;
                }
                if (!this.isSupported) {
                    NotificationsTab.this.tabItem.dispose();
                    return;
                }
                if (NotificationsTab.this.tabItem.isDisposed() && this.isSupported) {
                    NotificationsTab.this.addTabItem();
                }
                NotificationsTab.this.tree.setInput(NotificationsTab.this.objectName);
                NotificationsTab.this.treeViewer.refresh();
                NotificationsTab.this.updatePage(this.isSubscribed);
            }
        }.schedule();
    }

    protected void clear() {
        IActiveJvm jvm = this.section.getJvm();
        if (jvm != null) {
            jvm.getMBeanServer().getMBeanNotification().clear(this.objectName);
        }
    }

    protected void deactivated() {
        Job.getJobManager().cancel((Object)this.toString());
    }

    void addTabItem() {
        this.tabItem = new CTabItem(this.tabFolder, 0);
        this.tabItem.setText(Messages.notificationsTabLabel);
        this.tabItem.setImage(this.getNotificationImage());
        this.tabItem.setControl((Control)this);
    }

    void updatePage(boolean isSubscribed) {
        if (isSubscribed) {
            this.showPage((Control)this.tree);
        } else {
            this.showPage((Control)this.messagePage);
        }
    }

    private ObjectName getObjectName(StructuredSelection selection) {
        Object element = selection.getFirstElement();
        if (element instanceof MBeanType) {
            MBeanName[] mBeanNames = ((MBeanType)element).getMBeanNames();
            if (mBeanNames != null && mBeanNames.length == 1) {
                return mBeanNames[0].getObjectName();
            }
        } else if (element instanceof MBeanName) {
            return ((MBeanName)element).getObjectName();
        }
        return null;
    }

    private Image getNotificationImage() {
        if (this.notificationImage == null || this.notificationImage.isDisposed()) {
            this.notificationImage = Activator.getImageDescriptor("icons/full/obj16/notification.png").createImage();
        }
        return this.notificationImage;
    }
}

