/*
 * Decompiled with CFR 0.152.
 */
package com.fusesource.ide.jvmmonitor.internal.ui.properties.mbean;

import com.fusesource.ide.jvmmonitor.core.IActiveJvm;
import com.fusesource.ide.jvmmonitor.core.JvmCoreException;
import com.fusesource.ide.jvmmonitor.internal.ui.RefreshJob;
import com.fusesource.ide.jvmmonitor.internal.ui.properties.AbstractJvmPropertySection;
import com.fusesource.ide.jvmmonitor.internal.ui.properties.mbean.InvokeAction;
import com.fusesource.ide.jvmmonitor.internal.ui.properties.mbean.MBeanName;
import com.fusesource.ide.jvmmonitor.internal.ui.properties.mbean.MBeanType;
import com.fusesource.ide.jvmmonitor.internal.ui.properties.mbean.Messages;
import com.fusesource.ide.jvmmonitor.internal.ui.properties.mbean.OperationsContentProvider;
import com.fusesource.ide.jvmmonitor.internal.ui.properties.mbean.OperationsLabelProvider;
import com.fusesource.ide.jvmmonitor.ui.Activator;
import javax.management.MBeanInfo;
import javax.management.MBeanOperationInfo;
import javax.management.ObjectName;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

public class OperationsTab
extends Composite {
    TableViewer tableViewer;
    InvokeAction invokeAction;
    CTabItem tabItem;
    private CTabFolder tabFolder;
    OperationsContentProvider contentProvider;
    ObjectName objectName;
    AbstractJvmPropertySection section;
    private Image methodImage;

    public OperationsTab(CTabFolder tabFolder, AbstractJvmPropertySection section) {
        super((Composite)tabFolder, 0);
        this.tabFolder = tabFolder;
        this.section = section;
        this.addTabItem();
        this.setLayout((Layout)new FillLayout());
        this.tableViewer = new TableViewer((Composite)this, 0);
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new OperationsLabelProvider());
        this.contentProvider = new OperationsContentProvider();
        this.tableViewer.setContentProvider((IContentProvider)this.contentProvider);
        this.createContextMenu();
        this.configureTable();
    }

    public void dispose() {
        super.dispose();
        if (this.methodImage != null) {
            this.methodImage.dispose();
        }
    }

    public void selectionChanged(ISelection selection) {
        if (!(selection instanceof StructuredSelection)) {
            return;
        }
        this.objectName = this.getObjectName((StructuredSelection)selection);
        if (this.objectName == null) {
            return;
        }
        this.tableViewer.setInput((Object)this.objectName);
        this.invokeAction.selectionChanged(this.objectName);
        this.contentProvider.refresh(null);
        this.tableViewer.refresh();
        this.refresh();
    }

    protected void refresh() {
        new RefreshJob(Messages.refreshOperationsTabJobLabel, this.toString()){
            private MBeanOperationInfo[] operations;

            @Override
            protected void refreshModel(IProgressMonitor monitor) {
                IActiveJvm jvm = OperationsTab.this.section.getJvm();
                if (jvm == null || !jvm.isConnected()) {
                    return;
                }
                MBeanInfo info = null;
                if (OperationsTab.this.objectName != null) {
                    try {
                        info = jvm.getMBeanServer().getMBeanInfo(OperationsTab.this.objectName);
                    }
                    catch (JvmCoreException e) {
                        Activator.log(Messages.getMBeanInfoFailedMsg, (CoreException)((Object)e));
                        return;
                    }
                }
                if (info != null) {
                    this.operations = info.getOperations();
                    OperationsTab.this.contentProvider.refresh(this.operations);
                }
            }

            @Override
            protected void refreshUI() {
                if (this.operations == null || this.operations.length == 0) {
                    OperationsTab.this.tabItem.dispose();
                    return;
                }
                if (OperationsTab.this.tabItem.isDisposed()) {
                    OperationsTab.this.addTabItem();
                }
                if (!OperationsTab.this.tableViewer.getControl().isDisposed()) {
                    OperationsTab.this.tableViewer.refresh();
                }
            }
        }.schedule();
    }

    protected void deactivated() {
        Job.getJobManager().cancel((Object)this.toString());
    }

    void addTabItem() {
        this.tabItem = new CTabItem(this.tabFolder, 0);
        this.tabItem.setText(Messages.operationsTabLabel);
        this.tabItem.setImage(this.getMethodImage());
        this.tabItem.setControl((Control)this);
    }

    private ObjectName getObjectName(StructuredSelection selection) {
        Object element = selection.getFirstElement();
        if (element instanceof MBeanType) {
            MBeanName[] mBeanName = ((MBeanType)element).getMBeanNames();
            if (mBeanName != null && mBeanName.length == 1) {
                return mBeanName[0].getObjectName();
            }
        } else if (element instanceof MBeanName) {
            return ((MBeanName)element).getObjectName();
        }
        return null;
    }

    private void configureTable() {
        Table table = this.tableViewer.getTable();
        if (table.isDisposed()) {
            return;
        }
        table.setLinesVisible(true);
        table.setHeaderVisible(true);
        TableColumn column = new TableColumn(table, 0);
        column.setText(Messages.operationColumnLabel);
        column.setWidth(300);
        column.setToolTipText(Messages.operationColumnToolTip);
    }

    private void createContextMenu() {
        this.invokeAction = new InvokeAction(this.tableViewer, this.section);
        this.tableViewer.addSelectionChangedListener((ISelectionChangedListener)this.invokeAction);
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                manager.add((IAction)OperationsTab.this.invokeAction);
            }
        });
        Menu menu = menuMgr.createContextMenu(this.tableViewer.getControl());
        this.tableViewer.getControl().setMenu(menu);
    }

    private Image getMethodImage() {
        if (this.methodImage == null || this.methodImage.isDisposed()) {
            this.methodImage = Activator.getImageDescriptor("icons/full/obj16/method_obj.gif").createImage();
        }
        return this.methodImage;
    }
}

