/*
 * Decompiled with CFR 0.152.
 */
package com.fusesource.ide.jvmmonitor.internal.ui.properties.mbean;

import com.fusesource.ide.jvmmonitor.core.IActiveJvm;
import com.fusesource.ide.jvmmonitor.core.JvmCoreException;
import com.fusesource.ide.jvmmonitor.internal.ui.properties.AbstractJvmPropertySection;
import com.fusesource.ide.jvmmonitor.internal.ui.properties.mbean.MBeanName;
import com.fusesource.ide.jvmmonitor.internal.ui.properties.mbean.MBeanType;
import com.fusesource.ide.jvmmonitor.internal.ui.properties.mbean.Messages;
import com.fusesource.ide.jvmmonitor.ui.Activator;
import javax.management.ObjectName;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ITreeSelection;

public class SubscribeAction
extends Action {
    ObjectName objectName;
    AbstractJvmPropertySection section;

    public SubscribeAction(AbstractJvmPropertySection section) {
        super(Messages.subscribeLabel, 2);
        this.section = section;
    }

    public SubscribeAction(ISelection selection, AbstractJvmPropertySection section) {
        this(section);
        this.setSelection(selection);
        this.refresh();
    }

    private void refresh() {
        new Job(Messages.refreshSubscribeActionStateJobLabel){

            protected IStatus run(IProgressMonitor monitor) {
                IActiveJvm jvm = SubscribeAction.this.section.getJvm();
                boolean enabled = jvm != null && jvm.isConnected() && SubscribeAction.this.objectName != null && jvm.getMBeanServer().getMBeanNotification().isSupported(SubscribeAction.this.objectName);
                SubscribeAction.this.setEnabled(enabled);
                if (enabled && jvm != null) {
                    SubscribeAction.this.setChecked(jvm.getMBeanServer().getMBeanNotification().isSubscribed(SubscribeAction.this.objectName));
                }
                return Status.OK_STATUS;
            }
        }.schedule();
    }

    public void run() {
        new Job(Messages.subscribeNotificationJobLabel){

            protected IStatus run(IProgressMonitor monitor) {
                IActiveJvm jvm = SubscribeAction.this.section.getJvm();
                if (jvm == null) {
                    return Status.CANCEL_STATUS;
                }
                try {
                    if (jvm.getMBeanServer().getMBeanNotification().isSubscribed(SubscribeAction.this.objectName)) {
                        jvm.getMBeanServer().getMBeanNotification().unsubscribe(SubscribeAction.this.objectName);
                    } else {
                        jvm.getMBeanServer().getMBeanNotification().subscribe(SubscribeAction.this.objectName);
                    }
                }
                catch (JvmCoreException e) {
                    Activator.log(Messages.subscribeNotificationFailedMsg, (CoreException)((Object)e));
                }
                return Status.OK_STATUS;
            }
        }.schedule();
    }

    protected void setSelection(ObjectName objectName) {
        this.objectName = objectName;
        this.refresh();
    }

    private void setSelection(ISelection selection) {
        this.objectName = null;
        if (selection instanceof ITreeSelection) {
            ITreeSelection new_name = (ITreeSelection)selection;
            Object element = new_name.getFirstElement();
            if (element instanceof MBeanType) {
                MBeanName[] mBeanNames = ((MBeanType)element).getMBeanNames();
                if (mBeanNames != null && mBeanNames.length == 1) {
                    this.objectName = mBeanNames[0].getObjectName();
                }
            } else if (element instanceof MBeanName) {
                this.objectName = ((MBeanName)element).getObjectName();
            }
        }
    }
}

