/*
 * Decompiled with CFR 0.152.
 */
package com.fusesource.ide.jvmmonitor.internal.ui.properties.memory;

import com.fusesource.ide.jvmmonitor.core.IActiveJvm;
import com.fusesource.ide.jvmmonitor.core.JvmCoreException;
import com.fusesource.ide.jvmmonitor.internal.ui.properties.AbstractJvmPropertySection;
import com.fusesource.ide.jvmmonitor.internal.ui.properties.memory.Messages;
import com.fusesource.ide.jvmmonitor.internal.ui.views.OpenSnapshotAction;
import com.fusesource.ide.jvmmonitor.ui.Activator;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.Action;

public class DumpHeapAction
extends Action {
    AbstractJvmPropertySection section;

    public DumpHeapAction(AbstractJvmPropertySection section) {
        this.setText(Messages.dumpHeapLabel);
        this.setImageDescriptor(Activator.getImageDescriptor("icons/full/elcl16/take_heap_dump.gif"));
        this.setDisabledImageDescriptor(Activator.getImageDescriptor("icons/full/dlcl16/take_heap_dump.gif"));
        this.setId(((Object)((Object)this)).getClass().getName());
        this.section = section;
    }

    public void run() {
        new Job(Messages.dumpHeapDataJobLabel){

            protected IStatus run(IProgressMonitor monitor) {
                IActiveJvm jvm = DumpHeapAction.this.section.getJvm();
                if (jvm == null) {
                    return Status.CANCEL_STATUS;
                }
                IFileStore fileStore = null;
                try {
                    fileStore = jvm.getMBeanServer().dumpHeap();
                }
                catch (JvmCoreException e) {
                    Activator.log(Messages.dumpHeapDataFailedMsg, (CoreException)((Object)e));
                    return Status.CANCEL_STATUS;
                }
                DumpHeapAction.this.section.setPinned(true);
                OpenSnapshotAction.openEditor(fileStore);
                return Status.OK_STATUS;
            }
        }.schedule();
    }
}

