/*
 * Decompiled with CFR 0.152.
 */
package com.fusesource.ide.jvmmonitor.internal.ui.properties.memory;

import com.fusesource.ide.jvmmonitor.core.IHeapElement;
import com.fusesource.ide.jvmmonitor.internal.ui.properties.memory.HeapColumn;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.widgets.Tree;

public class HeapComparator
extends ViewerComparator {
    private int sortDirection;
    private int columnIndex;

    public HeapComparator(int columnIndex) {
        this.columnIndex = columnIndex;
        this.sortDirection = columnIndex == 0 ? 128 : 1024;
    }

    public int compare(Viewer treeViewer, Object e1, Object e2) {
        int result = 0;
        if (!(e1 instanceof IHeapElement && e2 instanceof IHeapElement && treeViewer instanceof TreeViewer)) {
            return result;
        }
        IHeapElement element1 = (IHeapElement)e1;
        IHeapElement element2 = (IHeapElement)e2;
        Tree tree = ((TreeViewer)treeViewer).getTree();
        if (this.columnIndex == this.getColumnIndex(tree, HeapColumn.CLASS)) {
            result = super.compare(treeViewer, (Object)element1.getClassName(), (Object)element2.getClassName());
        } else if (this.columnIndex == this.getColumnIndex(tree, HeapColumn.SIZE)) {
            long size2;
            long size1 = element1.getSize();
            result = size1 > (size2 = element2.getSize()) ? 1 : -1;
        } else if (this.columnIndex == this.getColumnIndex(tree, HeapColumn.COUNT)) {
            long count2;
            long count1 = element1.getCount();
            result = count1 > (count2 = element2.getCount()) ? 1 : -1;
        } else if (this.columnIndex == this.getColumnIndex(tree, HeapColumn.DELTA)) {
            long delta2;
            long delta1 = element1.getSize() - element1.getBaseSize();
            int n = result = delta1 > (delta2 = element2.getSize() - element2.getBaseSize()) ? 1 : -1;
        }
        if (this.sortDirection == 1024) {
            result *= -1;
        }
        return result;
    }

    protected void reverseSortDirection() {
        this.sortDirection = this.sortDirection == 128 ? 1024 : 128;
    }

    protected int getSortDirection() {
        return this.sortDirection;
    }

    protected int getColumnIndex() {
        return this.columnIndex;
    }

    private int getColumnIndex(Tree tree, HeapColumn column) {
        int i = 0;
        while (i < tree.getColumnCount()) {
            if (tree.getColumn(i).getText().equals(column.label)) {
                return i;
            }
            ++i;
        }
        return -1;
    }
}

