/*
 * Decompiled with CFR 0.152.
 */
package com.fusesource.ide.jvmmonitor.internal.ui.properties.memory;

import com.fusesource.ide.jvmmonitor.core.IActiveJvm;
import com.fusesource.ide.jvmmonitor.core.JvmCoreException;
import com.fusesource.ide.jvmmonitor.internal.ui.RefreshJob;
import com.fusesource.ide.jvmmonitor.internal.ui.actions.CopyAction;
import com.fusesource.ide.jvmmonitor.internal.ui.actions.OpenDeclarationAction;
import com.fusesource.ide.jvmmonitor.internal.ui.actions.RefreshAction;
import com.fusesource.ide.jvmmonitor.internal.ui.properties.memory.ClearHeapDeltaAction;
import com.fusesource.ide.jvmmonitor.internal.ui.properties.memory.DumpHeapAction;
import com.fusesource.ide.jvmmonitor.internal.ui.properties.memory.DumpHprofAction;
import com.fusesource.ide.jvmmonitor.internal.ui.properties.memory.GarbageCollectorAction;
import com.fusesource.ide.jvmmonitor.internal.ui.properties.memory.HeapColumn;
import com.fusesource.ide.jvmmonitor.internal.ui.properties.memory.HeapComparator;
import com.fusesource.ide.jvmmonitor.internal.ui.properties.memory.HeapContentProvider;
import com.fusesource.ide.jvmmonitor.internal.ui.properties.memory.HeapFilteredTree;
import com.fusesource.ide.jvmmonitor.internal.ui.properties.memory.HeapLabelProvider;
import com.fusesource.ide.jvmmonitor.internal.ui.properties.memory.IHeapInput;
import com.fusesource.ide.jvmmonitor.internal.ui.properties.memory.MemorySection;
import com.fusesource.ide.jvmmonitor.internal.ui.properties.memory.Messages;
import com.fusesource.ide.jvmmonitor.ui.Activator;
import com.fusesource.rider.commons.ui.IConfigurableColumns;
import com.fusesource.rider.commons.ui.Trees;
import com.fusesource.rider.commons.ui.actions.ConfigureColumnsAction;
import com.fusesource.rider.commons.ui.config.ColumnConfiguration;
import com.fusesource.rider.commons.ui.config.TableConfiguration;
import java.lang.management.ManagementFactory;
import java.lang.management.OperatingSystemMXBean;
import java.lang.management.RuntimeMXBean;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IOpenListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.ui.IActionBars;

public class HeapHistogramPage
extends Composite
implements IConfigurableColumns {
    private static final String ARCH_64BIT = "64";
    private TableConfiguration configuration;
    TreeViewer viewer;
    private Separator separator;
    RefreshAction refreshAction;
    GarbageCollectorAction garbageCollectorAction;
    ClearHeapDeltaAction clearHeapDeltaAction;
    DumpHeapAction dumpHeapAction;
    DumpHprofAction dumpHprofAction;
    ConfigureColumnsAction configureColumnsAction;
    MemorySection section;

    public HeapHistogramPage(MemorySection section, Composite parent, final CTabFolder tabFolder, IActionBars actionBars) {
        super(parent, 0);
        this.section = section;
        final CTabItem tabItem = section.getWidgetFactory().createTabItem(tabFolder, 0);
        tabItem.setText(Messages.heapHistogramLabel);
        tabItem.setControl((Control)parent);
        tabFolder.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                HeapHistogramPage.this.refreshBackground();
                HeapHistogramPage.this.updateLocalToolBar(tabFolder.getSelection().equals(tabItem));
            }
        });
        this.init(actionBars);
    }

    public HeapHistogramPage(Composite parent, IActionBars actionBars) {
        super(parent, 0);
        this.init(actionBars);
    }

    public List<String> getColumns() {
        HeapColumn[] values;
        ArrayList<String> columnLabels = new ArrayList<String>();
        HeapColumn[] heapColumnArray = values = HeapColumn.values();
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            HeapColumn value = heapColumnArray[n2];
            columnLabels.add(value.label);
            ++n2;
        }
        return columnLabels;
    }

    public String getId() {
        return ((Object)((Object)this)).getClass().getName();
    }

    public boolean getDefaultVisibility(String column) {
        return true;
    }

    public TableConfiguration getConfiguration() {
        if (this.configuration == null) {
            this.configuration = TableConfiguration.loadConfiguration((String)this.getId());
            this.configuration.addDefaultColumns(this.getColumns());
        }
        return this.configuration;
    }

    public void updateColumnConfiguration(TableConfiguration configuration) {
        this.configuration = configuration;
        if (this.getViewer().getTree().isDisposed()) {
            return;
        }
        this.configureTree();
        this.getViewer().refresh();
    }

    public void dispose() {
        super.dispose();
        this.getConfiguration().removeListener((IConfigurableColumns)this);
    }

    public TreeViewer getViewer() {
        return this.viewer;
    }

    public void setInput(IHeapInput heapInput) {
        this.viewer.setInput((Object)heapInput);
    }

    public void refresh() {
        if (this.section == null) {
            return;
        }
        final boolean isVisible = this.isVisible();
        new RefreshJob(NLS.bind((String)Messages.refreshMemorySectionJobLabel, (Object)this.section.getJvm().getPid()), this.getId()){

            @Override
            protected void refreshModel(IProgressMonitor monitor) {
                if (!HeapHistogramPage.this.isSupported() || !isVisible) {
                    return;
                }
                try {
                    IActiveJvm jvm = HeapHistogramPage.this.section.getJvm();
                    if (jvm != null && jvm.isConnected() && !jvm.isRemote() && !HeapHistogramPage.this.section.isRefreshSuspended()) {
                        jvm.getMBeanServer().refreshHeapCache();
                    }
                }
                catch (JvmCoreException e) {
                    Activator.log(Messages.refreshHeapDataFailedMsg, (CoreException)((Object)e));
                }
            }

            @Override
            protected void refreshUI() {
                IActiveJvm jvm = HeapHistogramPage.this.section.getJvm();
                boolean isConnected = jvm != null && jvm.isConnected();
                boolean isRemote = jvm != null && jvm.isRemote();
                boolean isSupported = HeapHistogramPage.this.isSupported();
                if (!HeapHistogramPage.this.viewer.getControl().isDisposed() && HeapHistogramPage.this.viewer.getControl().isVisible() && isSupported) {
                    HeapHistogramPage.this.viewer.refresh();
                }
                HeapHistogramPage.this.refreshBackground();
                HeapHistogramPage.this.dumpHprofAction.setEnabled(isConnected);
                HeapHistogramPage.this.dumpHeapAction.setEnabled(!HeapHistogramPage.this.section.hasErrorMessage() && !isRemote && isSupported);
                HeapHistogramPage.this.refreshAction.setEnabled(isConnected && !isRemote && isSupported);
                HeapHistogramPage.this.garbageCollectorAction.setEnabled(isConnected);
                HeapHistogramPage.this.clearHeapDeltaAction.setEnabled(isConnected && !isRemote && isSupported);
            }
        }.schedule();
    }

    protected void deactivated() {
        Job.getJobManager().cancel((Object)this.getId());
    }

    void refreshBackground() {
        IActiveJvm jvm = this.section.getJvm();
        boolean isConnected = jvm != null && jvm.isConnected();
        boolean isRemote = jvm != null && jvm.isRemote();
        this.section.refreshBackground(this.getChildren(), isConnected && !isRemote);
    }

    void addToolBarActions(IToolBarManager manager) {
        manager.insertAfter("defaults", (IContributionItem)this.separator);
        if (manager.find(this.refreshAction.getId()) == null) {
            manager.insertAfter("defaults", (IAction)this.refreshAction);
        }
        if (manager.find(this.garbageCollectorAction.getId()) == null) {
            manager.insertAfter("defaults", (IAction)this.garbageCollectorAction);
        }
        if (manager.find(this.clearHeapDeltaAction.getId()) == null) {
            manager.insertAfter("defaults", (IAction)this.clearHeapDeltaAction);
        }
        if (manager.find(this.dumpHeapAction.getId()) == null) {
            manager.insertAfter("defaults", (IAction)this.dumpHeapAction);
        }
        if (manager.find(this.dumpHprofAction.getId()) == null) {
            manager.insertAfter("defaults", (IAction)this.dumpHprofAction);
        }
        manager.update(true);
    }

    void removeToolBarActions(IToolBarManager manager) {
        manager.remove((IContributionItem)this.separator);
        manager.remove(this.refreshAction.getId());
        manager.remove(this.garbageCollectorAction.getId());
        manager.remove(this.clearHeapDeltaAction.getId());
        manager.remove(this.dumpHeapAction.getId());
        manager.remove(this.dumpHprofAction.getId());
        manager.update(true);
    }

    void updateLocalToolBar(boolean activated) {
        IToolBarManager manager = this.section.getActionBars().getToolBarManager();
        if (activated) {
            this.addToolBarActions(manager);
        } else {
            this.removeToolBarActions(manager);
        }
    }

    private void init(IActionBars actionBars) {
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.setLayout((Layout)layout);
        this.viewer = new HeapFilteredTree(this).getViewer();
        this.viewer.setContentProvider((IContentProvider)new HeapContentProvider(this.viewer));
        this.viewer.setLabelProvider((IBaseLabelProvider)new HeapLabelProvider(this.viewer));
        this.configureTree();
        this.createActions();
        this.createContextMenu(actionBars);
        this.getConfiguration().addListener((IConfigurableColumns)this);
    }

    boolean isSupported() {
        IActiveJvm jvm = this.section.getJvm();
        if (jvm == null) {
            return false;
        }
        OperatingSystemMXBean osMBean = ManagementFactory.getOperatingSystemMXBean();
        RuntimeMXBean runtimeMBean = ManagementFactory.getRuntimeMXBean();
        return !osMBean.getArch().contains(ARCH_64BIT) || !runtimeMBean.getName().contains(String.valueOf(jvm.getPid()));
    }

    private void createContextMenu(IActionBars actionBars) {
        final OpenDeclarationAction openAction = OpenDeclarationAction.createOpenDeclarationAction(actionBars);
        final CopyAction copyAction = CopyAction.createCopyAction(actionBars);
        this.configureColumnsAction = new ConfigureColumnsAction((IConfigurableColumns)this);
        this.viewer.addSelectionChangedListener((ISelectionChangedListener)openAction);
        this.viewer.getControl().addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent e) {
                HeapHistogramPage.this.viewer.removeSelectionChangedListener((ISelectionChangedListener)copyAction);
            }

            public void focusGained(FocusEvent e) {
                HeapHistogramPage.this.viewer.addSelectionChangedListener((ISelectionChangedListener)copyAction);
            }
        });
        this.viewer.addOpenListener(new IOpenListener(){

            public void open(OpenEvent event) {
                openAction.run();
            }
        });
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                manager.add((IAction)openAction);
                manager.add((IAction)copyAction);
                manager.add((IContributionItem)new Separator());
                manager.add((IAction)HeapHistogramPage.this.configureColumnsAction);
            }
        });
        Menu menu = menuMgr.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
    }

    private void createActions() {
        this.refreshAction = new RefreshAction(this.section);
        this.garbageCollectorAction = new GarbageCollectorAction(this.section);
        this.clearHeapDeltaAction = new ClearHeapDeltaAction(this, this.section);
        this.dumpHeapAction = new DumpHeapAction(this.section);
        this.dumpHprofAction = new DumpHprofAction(this.section);
        this.separator = new Separator();
    }

    protected void configureTree() {
        Tree tree = this.viewer.getTree();
        if (tree.isDisposed()) {
            return;
        }
        Trees.disposeColumns((TreeViewer)this.getViewer());
        tree.setLinesVisible(true);
        tree.setHeaderVisible(true);
        List columns = this.getConfiguration().getColumnConfigurations();
        for (ColumnConfiguration config : columns) {
            if (!config.isVisible()) continue;
            HeapColumn column = HeapColumn.getColumn(config.getName());
            TreeColumn treeColumn = new TreeColumn(this.getViewer().getTree(), 0);
            treeColumn.setText(column.label);
            treeColumn.setWidth(column.defalutWidth);
            treeColumn.setAlignment(column.alignment);
            treeColumn.setToolTipText(column.toolTip);
            treeColumn.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    if (e.widget instanceof TreeColumn) {
                        HeapHistogramPage.this.sortColumn((TreeColumn)e.widget);
                    }
                }
            });
        }
        this.getConfiguration().addColumnListeners(this.getViewer());
    }

    void sortColumn(TreeColumn treeColumn) {
        Tree tree = this.viewer.getTree();
        int columnIndex = tree.indexOf(treeColumn);
        HeapComparator sorter = (HeapComparator)this.viewer.getComparator();
        if (sorter != null && columnIndex == sorter.getColumnIndex()) {
            sorter.reverseSortDirection();
        } else {
            sorter = new HeapComparator(columnIndex);
            this.viewer.setComparator((ViewerComparator)sorter);
        }
        tree.setSortColumn(treeColumn);
        tree.setSortDirection(sorter.getSortDirection());
        this.refresh();
    }
}

