/*
 * Decompiled with CFR 0.152.
 */
package com.fusesource.ide.jvmmonitor.internal.ui.properties.memory;

import com.fusesource.ide.jvmmonitor.core.IHeapElement;
import com.fusesource.ide.jvmmonitor.internal.ui.properties.memory.HeapColumn;
import com.fusesource.ide.jvmmonitor.ui.Activator;
import java.text.NumberFormat;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Tree;

public class HeapLabelProvider
extends LabelProvider
implements ITableLabelProvider {
    private Image classImage;
    private TreeViewer treeViewer;

    public HeapLabelProvider(TreeViewer tableViewer) {
        this.treeViewer = tableViewer;
    }

    public Image getColumnImage(Object element, int columnIndex) {
        if (columnIndex == this.getColumnIndex(HeapColumn.CLASS)) {
            return this.getClassImage();
        }
        return null;
    }

    public String getColumnText(Object element, int columnIndex) {
        if (element instanceof IHeapElement) {
            return this.getColumnText((IHeapElement)element, columnIndex);
        }
        return super.getText(element);
    }

    public String getText(Object obj) {
        if (obj instanceof IHeapElement) {
            return this.getColumnText((IHeapElement)obj, this.getColumnIndex(HeapColumn.CLASS));
        }
        return super.getText(obj);
    }

    public void dispose() {
        super.dispose();
        if (this.classImage != null) {
            this.classImage.dispose();
        }
    }

    private String getColumnText(IHeapElement element, int columnIndex) {
        if (columnIndex == this.getColumnIndex(HeapColumn.CLASS)) {
            return element.getClassName();
        }
        if (columnIndex == this.getColumnIndex(HeapColumn.SIZE)) {
            return NumberFormat.getInstance().format(element.getSize());
        }
        if (columnIndex == this.getColumnIndex(HeapColumn.COUNT)) {
            return NumberFormat.getInstance().format(element.getCount());
        }
        if (columnIndex == this.getColumnIndex(HeapColumn.DELTA)) {
            return NumberFormat.getInstance().format(element.getSize() - element.getBaseSize());
        }
        return "";
    }

    private int getColumnIndex(HeapColumn column) {
        Tree table = this.treeViewer.getTree();
        int i = 0;
        while (i < table.getColumnCount()) {
            if (table.getColumn(i).getText().equals(column.label)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private Image getClassImage() {
        if (this.classImage == null || this.classImage.isDisposed()) {
            this.classImage = Activator.getImageDescriptor("icons/full/obj16/class_obj.gif").createImage();
        }
        return this.classImage;
    }
}

