/*
 * Decompiled with CFR 0.152.
 */
package com.fusesource.ide.jvmmonitor.internal.ui.properties.memory;

import com.fusesource.ide.jvmmonitor.core.IActiveJvm;
import com.fusesource.ide.jvmmonitor.core.IHeapElement;
import com.fusesource.ide.jvmmonitor.core.ISWTResourceElement;
import com.fusesource.ide.jvmmonitor.internal.ui.RefreshJob;
import com.fusesource.ide.jvmmonitor.internal.ui.properties.AbstractJvmPropertySection;
import com.fusesource.ide.jvmmonitor.internal.ui.properties.memory.HeapHistogramPage;
import com.fusesource.ide.jvmmonitor.internal.ui.properties.memory.IHeapInput;
import com.fusesource.ide.jvmmonitor.internal.ui.properties.memory.ISWTResorceInput;
import com.fusesource.ide.jvmmonitor.internal.ui.properties.memory.Messages;
import com.fusesource.ide.jvmmonitor.internal.ui.properties.memory.SWTResourcesPage;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.PageBook;

public class MemorySection
extends AbstractJvmPropertySection {
    static int defaultTabHeight;
    HeapHistogramPage heapHistogramPage;
    SWTResourcesPage swtResourcePage;
    CTabFolder tabFolder;
    private PageBook heapHistogramPageBook;
    private Label heapHistogramMessageLabel;

    @Override
    public void createControls(Composite parent) {
        this.tabFolder = this.getWidgetFactory().createTabFolder(parent, 0x800400);
        this.heapHistogramPageBook = new PageBook((Composite)this.tabFolder, 0);
        this.heapHistogramMessageLabel = new Label((Composite)this.heapHistogramPageBook, 0);
        this.heapHistogramPage = new HeapHistogramPage(this, (Composite)this.heapHistogramPageBook, this.tabFolder, this.getActionBars());
        this.swtResourcePage = new SWTResourcesPage(this, this.tabFolder, this.getActionBars());
        defaultTabHeight = this.tabFolder.getTabHeight();
        this.tabFolder.setTabHeight(0);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "com.fusesource.ide.jvmmonitor.ui.memory_page_content");
    }

    public void refresh() {
        if (!this.isSectionActivated) {
            return;
        }
        this.heapHistogramPage.refresh();
        this.swtResourcePage.refresh(false);
    }

    @Override
    protected void setInput(IWorkbenchPart part, ISelection selection, final IActiveJvm newJvm, IActiveJvm oldJvm) {
        this.updateTabHeight(newJvm);
        this.heapHistogramPage.setInput(new IHeapInput(){

            @Override
            public IHeapElement[] getHeapListElements() {
                return newJvm.getMBeanServer().getHeapCache();
            }
        });
        this.swtResourcePage.setInput(new ISWTResorceInput(){

            @Override
            public ISWTResourceElement[] getSWTResourceElements() {
                return newJvm.getSWTResourceMonitor().getResources();
            }
        });
    }

    @Override
    protected void addToolBarActions(IToolBarManager manager) {
        if (this.tabFolder.getSelectionIndex() == 0) {
            this.heapHistogramPage.addToolBarActions(manager);
        } else {
            this.swtResourcePage.addToolBarActions(manager);
        }
    }

    @Override
    protected void removeToolBarActions(IToolBarManager manager) {
        if (this.tabFolder.getSelectionIndex() == 0) {
            this.heapHistogramPage.removeToolBarActions(manager);
        } else {
            this.swtResourcePage.removeToolBarActions(manager);
        }
    }

    @Override
    protected void addLocalMenus(IMenuManager manager) {
        if (this.tabFolder.getSelectionIndex() == 1) {
            this.swtResourcePage.addLocalMenus(manager);
        }
    }

    @Override
    protected void removeLocalMenus(IMenuManager manager) {
        if (this.tabFolder.getSelectionIndex() == 1) {
            this.swtResourcePage.removeLocalMenus(manager);
        }
    }

    @Override
    protected void activateSection() {
        super.activateSection();
        this.heapHistogramPage.updateLocalToolBar(this.tabFolder.getSelectionIndex() == 0);
        this.swtResourcePage.updateLocalToolBar(this.tabFolder.getSelectionIndex() == 1);
    }

    @Override
    protected void deactivateSection() {
        super.deactivateSection();
        Job.getJobManager().cancel((Object)((Object)((Object)this)).toString());
        this.heapHistogramPage.deactivated();
        this.swtResourcePage.deactivated();
    }

    @Override
    protected void updatePage() {
        super.updatePage();
        IActiveJvm jvm = this.getJvm();
        if (jvm != null && jvm.isConnected()) {
            if (jvm.isRemote()) {
                this.setMessageLabel(Messages.notSupportedOnRemoteHostMsg);
            } else if (!this.heapHistogramPage.isSupported()) {
                this.setMessageLabel(Messages.notSupportedForEclipseItselfOn64bitOS);
            } else {
                this.setMessageLabel("");
            }
            this.heapHistogramPageBook.showPage((Control)(this.heapHistogramMessageLabel.getText().isEmpty() ? this.heapHistogramPage : this.heapHistogramMessageLabel));
        }
    }

    private void updateTabHeight(final IActiveJvm jvm) {
        new RefreshJob(NLS.bind((String)Messages.refreshMemorySectionJobLabel, (Object)jvm.getPid()), ((Object)((Object)this)).toString()){
            private boolean isSupported;

            @Override
            protected void refreshModel(IProgressMonitor monitor) {
                this.isSupported = jvm.getSWTResourceMonitor().isSupported();
            }

            @Override
            protected void refreshUI() {
                int tabHeight;
                if (this.isSupported) {
                    tabHeight = defaultTabHeight;
                } else {
                    tabHeight = 0;
                    MemorySection.this.tabFolder.setSelection(0);
                }
                MemorySection.this.tabFolder.setTabHeight(tabHeight);
                MemorySection.this.tabFolder.layout();
            }
        }.schedule();
    }

    private void setMessageLabel(String message) {
        if (!this.heapHistogramMessageLabel.isDisposed() && !this.heapHistogramPageBook.isDisposed()) {
            this.heapHistogramMessageLabel.setText(message);
            this.heapHistogramPageBook.showPage((Control)this.heapHistogramMessageLabel);
        }
    }
}

