/*
 * Decompiled with CFR 0.152.
 */
package com.fusesource.ide.jvmmonitor.internal.ui.properties.memory;

import com.fusesource.ide.jvmmonitor.core.ISWTResourceElement;
import com.fusesource.ide.jvmmonitor.internal.ui.actions.CopyAction;
import com.fusesource.ide.jvmmonitor.internal.ui.properties.memory.Messages;
import com.fusesource.rider.commons.ui.Trees;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.StatusLineContributionItem;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.dialogs.FilteredTree;
import org.eclipse.ui.dialogs.PatternFilter;

public class SWTResourceFilteredTree
extends FilteredTree {
    private IActionBars actionBars;

    protected SWTResourceFilteredTree(Composite parent, IActionBars actionBars) {
        super(parent, 65538, new PatternFilter(), true);
        this.actionBars = actionBars;
        this.configureTree();
        this.createContextMenu();
        this.setBackground(Display.getDefault().getSystemColor(1));
    }

    protected void createControl(Composite composite, int treeStyle) {
        super.createControl(composite, treeStyle);
        GridData data = (GridData)this.filterComposite.getLayoutData();
        data.horizontalIndent = 2;
        data.verticalIndent = 2;
        this.filterComposite.setLayoutData((Object)data);
    }

    public void updateStatusLine(ISWTResourceElement[] resourceElements) {
        IStatusLineManager manager = this.actionBars.getStatusLineManager();
        IContributionItem[] items = manager.getItems();
        StatusLineContributionItem resourceCountContributionItem = null;
        IContributionItem[] iContributionItemArray = items;
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            IContributionItem item = iContributionItemArray[n2];
            if (item instanceof StatusLineContributionItem) {
                resourceCountContributionItem = (StatusLineContributionItem)item;
            }
            ++n2;
        }
        if (resourceCountContributionItem == null) {
            resourceCountContributionItem = new StatusLineContributionItem("ResourceCountContributionItem");
            manager.add((IContributionItem)resourceCountContributionItem);
        }
        if (resourceElements == null) {
            resourceCountContributionItem.setText("");
            return;
        }
        HashMap<String, Integer> resources = new HashMap<String, Integer>();
        ISWTResourceElement[] iSWTResourceElementArray = resourceElements;
        int n3 = resourceElements.length;
        n = 0;
        while (n < n3) {
            int n4;
            ISWTResourceElement resourceElement = iSWTResourceElementArray[n];
            String name = resourceElement.getName().split(" ")[0];
            Integer count = (Integer)resources.get(name);
            if (count == null) {
                n4 = 1;
            } else {
                count = count + 1;
                n4 = count;
            }
            resources.put(name, n4);
            ++n;
        }
        ArrayList list = new ArrayList(resources.keySet());
        Collections.sort(list);
        StringBuffer buffer = new StringBuffer();
        buffer.append("Total: ").append(resourceElements.length);
        for (String name : list) {
            buffer.append(", ").append(name);
            buffer.append(": ").append(resources.get(name));
        }
        resourceCountContributionItem.setText(buffer.toString());
    }

    private void configureTree() {
        Trees.disposeColumns((TreeViewer)this.getViewer());
        this.getViewer().getTree().setLinesVisible(true);
        this.getViewer().getTree().setHeaderVisible(true);
        TreeColumn treeColumn = new TreeColumn(this.getViewer().getTree(), 0);
        treeColumn.setText(Messages.nameColumnLabel);
        treeColumn.setWidth(500);
        treeColumn.setAlignment(16384);
        treeColumn.setToolTipText(Messages.nameColumnToolTip);
    }

    private void createContextMenu() {
        final CopyAction copyAction = CopyAction.createCopyAction(this.actionBars);
        this.getViewer().getControl().addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent e) {
                SWTResourceFilteredTree.this.getViewer().removeSelectionChangedListener((ISelectionChangedListener)copyAction);
            }

            public void focusGained(FocusEvent e) {
                SWTResourceFilteredTree.this.getViewer().addSelectionChangedListener((ISelectionChangedListener)copyAction);
            }
        });
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                manager.add((IAction)copyAction);
            }
        });
        Menu menu = menuMgr.createContextMenu(this.getViewer().getControl());
        this.getViewer().getControl().setMenu(menu);
    }
}

