/*
 * Decompiled with CFR 0.152.
 */
package com.fusesource.ide.jvmmonitor.internal.ui.properties.memory;

import com.fusesource.ide.jvmmonitor.core.IActiveJvm;
import com.fusesource.ide.jvmmonitor.core.JvmCoreException;
import com.fusesource.ide.jvmmonitor.internal.ui.RefreshJob;
import com.fusesource.ide.jvmmonitor.internal.ui.actions.PreferencesAction;
import com.fusesource.ide.jvmmonitor.internal.ui.actions.RefreshAction;
import com.fusesource.ide.jvmmonitor.internal.ui.actions.ToggleOrientationAction;
import com.fusesource.ide.jvmmonitor.internal.ui.properties.AbstractSashForm;
import com.fusesource.ide.jvmmonitor.internal.ui.properties.StackTraceViewer;
import com.fusesource.ide.jvmmonitor.internal.ui.properties.memory.ClearSWTResourceAction;
import com.fusesource.ide.jvmmonitor.internal.ui.properties.memory.ISWTResorceInput;
import com.fusesource.ide.jvmmonitor.internal.ui.properties.memory.MemorySection;
import com.fusesource.ide.jvmmonitor.internal.ui.properties.memory.Messages;
import com.fusesource.ide.jvmmonitor.internal.ui.properties.memory.SWTResourceContentProvider;
import com.fusesource.ide.jvmmonitor.internal.ui.properties.memory.SWTResourceFilteredTree;
import com.fusesource.ide.jvmmonitor.internal.ui.properties.memory.SWTResourceLabelProvider;
import com.fusesource.ide.jvmmonitor.ui.Activator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IActionBars;

public class SWTResourcesPage
extends AbstractSashForm {
    private static final int[] SASH_WEIGHTS = new int[]{45, 55};
    private static final String LAYOUT_MENU_ID = "layout";
    SWTResourceFilteredTree resourceFilteredTree;
    StackTraceViewer stackTraceViewer;
    MemorySection section;
    private Separator separator;
    RefreshAction refreshAction;
    ClearSWTResourceAction clearSWTResourceAction;
    private MenuManager layoutMenu;

    public SWTResourcesPage(MemorySection section, final CTabFolder tabFolder, IActionBars actionBars) {
        super((Composite)tabFolder, actionBars, SASH_WEIGHTS);
        this.section = section;
        this.createSashFormControls(this, actionBars);
        this.setWeights(this.initialSashWeights);
        this.createActions();
        final CTabItem tabItem = section.getWidgetFactory().createTabItem(tabFolder, 0);
        tabItem.setText(Messages.swtResourcesLabel);
        tabItem.setControl((Control)this);
        tabFolder.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean tabSelected = tabFolder.getSelection().equals(tabItem);
                SWTResourcesPage.this.refreshBackground();
                SWTResourcesPage.this.updateLocalToolBar(tabSelected);
                SWTResourcesPage.this.updateLocalMenus(tabSelected);
                if (!tabSelected) {
                    SWTResourcesPage.this.resourceFilteredTree.updateStatusLine(null);
                }
            }
        });
    }

    @Override
    protected void createSashFormControls(SashForm sashForm, IActionBars actionBars) {
        this.resourceFilteredTree = new SWTResourceFilteredTree((Composite)sashForm, actionBars);
        TreeViewer resourceViewer = this.resourceFilteredTree.getViewer();
        resourceViewer.setContentProvider((IContentProvider)new SWTResourceContentProvider(resourceViewer));
        resourceViewer.setLabelProvider((IBaseLabelProvider)new SWTResourceLabelProvider());
        resourceViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ISelection selection = event.getSelection();
                if (selection.isEmpty()) {
                    selection = null;
                }
                SWTResourcesPage.this.stackTraceViewer.setInput(selection);
            }
        });
        this.stackTraceViewer = new StackTraceViewer((Composite)sashForm, actionBars);
    }

    protected void refresh(final boolean force) {
        final boolean isVisible = this.isVisible();
        new RefreshJob(NLS.bind((String)Messages.refreshMemorySectionJobLabel, (Object)this.section.getJvm().getPid()), this.toString()){

            @Override
            protected void refreshModel(IProgressMonitor monitor) {
                try {
                    IActiveJvm jvm = SWTResourcesPage.this.section.getJvm();
                    if (isVisible && jvm != null && jvm.isConnected() && !SWTResourcesPage.this.section.isRefreshSuspended() && jvm.getSWTResourceMonitor().isSupported()) {
                        jvm.getSWTResourceMonitor().refreshResourcesCache();
                    }
                }
                catch (JvmCoreException e) {
                    Activator.log(Messages.refreshHeapDataFailedMsg, (CoreException)((Object)e));
                }
            }

            @Override
            protected void refreshUI() {
                IActiveJvm jvm = SWTResourcesPage.this.section.getJvm();
                boolean isConnected = jvm != null && jvm.isConnected();
                SWTResourcesPage.this.refreshBackground();
                SWTResourcesPage.this.refreshAction.setEnabled(isConnected);
                SWTResourcesPage.this.clearSWTResourceAction.setEnabled(isConnected);
                if (!force && SWTResourcesPage.this.section.isRefreshSuspended() || !isVisible) {
                    return;
                }
                TreeViewer resourceViewer = SWTResourcesPage.this.resourceFilteredTree.getViewer();
                if (!resourceViewer.getControl().isDisposed()) {
                    resourceViewer.refresh();
                    if (jvm != null) {
                        SWTResourcesPage.this.resourceFilteredTree.updateStatusLine(jvm.getSWTResourceMonitor().getResources());
                    }
                    if (resourceViewer.getSelection().isEmpty()) {
                        TreeItem[] items = resourceViewer.getTree().getItems();
                        if (items != null && items.length > 0) {
                            resourceViewer.getTree().select(items[0]);
                            SWTResourcesPage.this.stackTraceViewer.setInput(resourceViewer.getSelection());
                        } else {
                            SWTResourcesPage.this.stackTraceViewer.setInput(null);
                        }
                    }
                }
                if (!SWTResourcesPage.this.stackTraceViewer.getControl().isDisposed()) {
                    SWTResourcesPage.this.stackTraceViewer.refresh();
                }
            }
        }.schedule();
    }

    protected void setInput(ISWTResorceInput input) {
        if (!this.section.isRefreshSuspended()) {
            this.resourceFilteredTree.getViewer().setInput((Object)input);
        }
    }

    protected void deactivated() {
        Job.getJobManager().cancel((Object)this.toString());
    }

    void refreshBackground() {
        IActiveJvm jvm = this.section.getJvm();
        boolean isConnected = jvm != null && jvm.isConnected();
        this.section.refreshBackground(this.getChildren(), isConnected);
    }

    void updateLocalToolBar(boolean activated) {
        IToolBarManager manager = this.section.getActionBars().getToolBarManager();
        if (activated) {
            this.addToolBarActions(manager);
        } else {
            this.removeToolBarActions(manager);
        }
    }

    void updateLocalMenus(boolean activated) {
        IMenuManager manager = this.section.getActionBars().getMenuManager();
        if (activated) {
            this.addLocalMenus(manager);
        } else {
            this.removeLocalMenus(manager);
        }
    }

    void addToolBarActions(IToolBarManager manager) {
        manager.insertAfter("defaults", (IContributionItem)this.separator);
        if (manager.find(this.refreshAction.getId()) == null) {
            manager.insertAfter("defaults", (IAction)this.refreshAction);
        }
        if (manager.find(this.clearSWTResourceAction.getId()) == null) {
            manager.insertAfter("defaults", (IAction)this.clearSWTResourceAction);
        }
        manager.update(true);
    }

    void removeToolBarActions(IToolBarManager manager) {
        manager.remove((IContributionItem)this.separator);
        manager.remove(this.refreshAction.getId());
        manager.remove(this.clearSWTResourceAction.getId());
        manager.update(true);
    }

    void addLocalMenus(IMenuManager manager) {
        if (manager.find(this.layoutMenu.getId()) == null) {
            if (manager.find(PreferencesAction.class.getName()) != null) {
                manager.insertBefore(PreferencesAction.class.getName(), (IContributionItem)this.layoutMenu);
            } else {
                manager.add((IContributionItem)this.layoutMenu);
            }
            for (ToggleOrientationAction action : this.getOrientationActions()) {
                if (this.layoutMenu.find(action.getId()) != null) continue;
                this.layoutMenu.add((IAction)action);
            }
        }
    }

    void removeLocalMenus(IMenuManager manager) {
        manager.remove((IContributionItem)this.layoutMenu);
    }

    private void createActions() {
        this.refreshAction = new RefreshAction(this.section){};
        this.clearSWTResourceAction = new ClearSWTResourceAction(this, this.section);
        this.separator = new Separator();
        this.layoutMenu = new MenuManager(Messages.layoutLabel, LAYOUT_MENU_ID);
    }
}

