/*
 * Decompiled with CFR 0.152.
 */
package com.fusesource.ide.jvmmonitor.internal.ui.properties.overview;

import com.fusesource.ide.jvmmonitor.core.IActiveJvm;
import com.fusesource.ide.jvmmonitor.core.JvmCoreException;
import com.fusesource.ide.jvmmonitor.internal.ui.properties.overview.IFormat;
import com.fusesource.ide.jvmmonitor.internal.ui.properties.overview.Messages;
import com.fusesource.ide.jvmmonitor.internal.ui.properties.overview.OverviewCategory;
import com.fusesource.ide.jvmmonitor.internal.ui.properties.overview.OverviewProperty;
import com.fusesource.ide.jvmmonitor.ui.Activator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.management.JMException;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.osgi.util.NLS;

public class OverviewProperties {
    private Map<OverviewCategory, List<OverviewProperty>> overviewProperties = new HashMap<OverviewCategory, List<OverviewProperty>>();
    private IActiveJvm activeJvm;

    public OverviewProperty[] getOverviewProperties(OverviewCategory category) {
        List<OverviewProperty> list = this.overviewProperties.get((Object)category);
        if (list != null) {
            return list.toArray(new OverviewProperty[0]);
        }
        return new OverviewProperty[0];
    }

    public void refresh(IActiveJvm jvm) {
        if (!jvm.equals(this.activeJvm)) {
            this.activeJvm = jvm;
            this.addPropertyItems();
        }
        this.refreshPropertyValues();
    }

    private void refreshPropertyValues() {
        for (List<OverviewProperty> properties : this.overviewProperties.values()) {
            for (OverviewProperty property : properties) {
                try {
                    ObjectName objectName = ObjectName.getInstance(property.getObjectName());
                    String attributeName = property.getAttributeName();
                    Object attribute = this.activeJvm.getMBeanServer().getAttribute(objectName, attributeName);
                    property.setValue(attribute);
                }
                catch (JvmCoreException e) {
                    Activator.log(Messages.getMBeanAttributeFailedMsg, (CoreException)((Object)e));
                }
                catch (JMException e) {
                    Activator.log(4, Messages.getMBeanAttributeFailedMsg, e);
                }
            }
        }
    }

    private void addPropertyItems() {
        this.addRuntimeProperties();
        this.addMemoryProperties();
        this.addThreadProperties();
        this.addClassLoadingProperties();
        this.addCompilationProperties();
        this.addGarbageCollectionProperties();
        this.addOperatingSystemProperties();
    }

    private void addRuntimeProperties() {
        ArrayList<OverviewProperty> list = new ArrayList<OverviewProperty>();
        list.add(new OverviewProperty(OverviewCategory.Runtime, Messages.runtimeNameLabel, "Name", false));
        list.add(new OverviewProperty(OverviewCategory.Runtime, Messages.inputArtumentsLabel, "InputArguments", false));
        list.add(new OverviewProperty(OverviewCategory.Runtime, Messages.systemPropertiesLabel, "SystemProperties", false));
        list.add(new OverviewProperty(OverviewCategory.Runtime, Messages.uptimeLabel, "Uptime", IFormat.MILLISEC_FORMAT, false));
        list.add(new OverviewProperty(OverviewCategory.Runtime, Messages.classPathLabel, "ClassPath", false));
        list.add(new OverviewProperty(OverviewCategory.Runtime, Messages.libraryPathLabel, "LibraryPath", false));
        list.add(new OverviewProperty(OverviewCategory.Runtime, Messages.bootClassPathLabel, "BootClassPath", false));
        list.add(new OverviewProperty(OverviewCategory.Runtime, Messages.vmVendorLabel, "VmVendor", false));
        list.add(new OverviewProperty(OverviewCategory.Runtime, Messages.vmNameLabel, "VmName", false));
        list.add(new OverviewProperty(OverviewCategory.Runtime, Messages.vmVersionLabel, "VmVersion", false));
        this.overviewProperties.put(OverviewCategory.Runtime, list);
    }

    private void addMemoryProperties() {
        ArrayList<OverviewProperty> list = new ArrayList<OverviewProperty>();
        list.add(new OverviewProperty(OverviewCategory.Memory, Messages.heapMemoryUsageLabel, "HeapMemoryUsage.used", IFormat.BYTES_FORMAT, true));
        list.add(new OverviewProperty(OverviewCategory.Memory, Messages.maxHeapHemoryLabel, "HeapMemoryUsage.max", IFormat.BYTES_FORMAT, true));
        list.add(new OverviewProperty(OverviewCategory.Memory, Messages.committedHeapMemoryLabel, "HeapMemoryUsage.committed", IFormat.BYTES_FORMAT, true));
        list.add(new OverviewProperty(OverviewCategory.Memory, Messages.usedNonHeapMemoryLabel, "NonHeapMemoryUsage.used", IFormat.BYTES_FORMAT, true));
        list.add(new OverviewProperty(OverviewCategory.Memory, Messages.maxNonHeapMemoryLabel, "NonHeapMemoryUsage.max", IFormat.BYTES_FORMAT, true));
        list.add(new OverviewProperty(OverviewCategory.Memory, Messages.committedNonHeapMemoryLabel, "NonHeapMemoryUsage.committed", IFormat.BYTES_FORMAT, true));
        list.add(new OverviewProperty(OverviewCategory.Memory, Messages.objectPendingFinalizationCountLabel, "ObjectPendingFinalizationCount", true));
        this.overviewProperties.put(OverviewCategory.Memory, list);
    }

    private void addThreadProperties() {
        ArrayList<OverviewProperty> list = new ArrayList<OverviewProperty>();
        list.add(new OverviewProperty(OverviewCategory.Threading, Messages.totalStartedThreadCountLabel, "TotalStartedThreadCount", true));
        list.add(new OverviewProperty(OverviewCategory.Threading, Messages.threadCountLabel, "ThreadCount", true));
        list.add(new OverviewProperty(OverviewCategory.Threading, Messages.peakThreadCountLabel, "PeakThreadCount", true));
        list.add(new OverviewProperty(OverviewCategory.Threading, Messages.daemonThreadCountLabel, "DaemonThreadCount", true));
        this.overviewProperties.put(OverviewCategory.Threading, list);
    }

    private void addClassLoadingProperties() {
        ArrayList<OverviewProperty> list = new ArrayList<OverviewProperty>();
        list.add(new OverviewProperty(OverviewCategory.ClassLoading, Messages.totalLoadedClassCountLabel, "TotalLoadedClassCount", true));
        list.add(new OverviewProperty(OverviewCategory.ClassLoading, Messages.loadedClassCountLabel, "LoadedClassCount", true));
        list.add(new OverviewProperty(OverviewCategory.ClassLoading, Messages.unloadedClassCountLabel, "UnloadedClassCount", true));
        this.overviewProperties.put(OverviewCategory.ClassLoading, list);
    }

    private void addCompilationProperties() {
        ArrayList<OverviewProperty> list = new ArrayList<OverviewProperty>();
        list.add(new OverviewProperty(OverviewCategory.Compilation, Messages.totalCompilationTimeLabel, "TotalCompilationTime", false));
        list.add(new OverviewProperty(OverviewCategory.Compilation, Messages.compilerNameLabel, "Name", false));
        this.overviewProperties.put(OverviewCategory.Compilation, list);
    }

    private void addGarbageCollectionProperties() {
        ArrayList<OverviewProperty> list = new ArrayList<OverviewProperty>();
        try {
            ObjectName queryObjectName = ObjectName.getInstance("java.lang:type=GarbageCollector,name=*");
            Set objectNames = this.activeJvm.getMBeanServer().queryNames(queryObjectName);
            for (ObjectName objectName : objectNames) {
                String name = objectName.getKeyProperty("name");
                list.add(new OverviewProperty(OverviewCategory.GarbageCollector, NLS.bind((String)Messages.collectionCountLabel, (Object)name), "CollectionCount", name, null, true));
                list.add(new OverviewProperty(OverviewCategory.GarbageCollector, NLS.bind((String)Messages.collectionTimeLabel, (Object)name), "CollectionTime", name, IFormat.MILLISEC_FORMAT, true));
            }
        }
        catch (MalformedObjectNameException e) {
            Activator.log(4, Messages.getObjectNameFailedMsg, e);
        }
        catch (JvmCoreException e) {
            Activator.log(Messages.getObjectNameFailedMsg, (CoreException)((Object)e));
        }
        this.overviewProperties.put(OverviewCategory.GarbageCollector, list);
    }

    private void addOperatingSystemProperties() {
        ArrayList<OverviewProperty> list = new ArrayList<OverviewProperty>();
        list.add(new OverviewProperty(OverviewCategory.OperatingSystem, Messages.totalPhysicalMemorySizeLabel, "TotalPhysicalMemorySize", IFormat.BYTES_FORMAT, true));
        list.add(new OverviewProperty(OverviewCategory.OperatingSystem, Messages.freePhysicalMemorySizeLabel, "FreePhysicalMemorySize", IFormat.BYTES_FORMAT, true));
        list.add(new OverviewProperty(OverviewCategory.OperatingSystem, Messages.totalSwapMemorySizeLabel, "TotalSwapSpaceSize", IFormat.BYTES_FORMAT, true));
        list.add(new OverviewProperty(OverviewCategory.OperatingSystem, Messages.freeSwapMemorySizeLabel, "FreeSwapSpaceSize", IFormat.BYTES_FORMAT, true));
        list.add(new OverviewProperty(OverviewCategory.OperatingSystem, Messages.committedVirtualMemorySizeLabel, "CommittedVirtualMemorySize", IFormat.BYTES_FORMAT, true));
        list.add(new OverviewProperty(OverviewCategory.OperatingSystem, Messages.processCpuTimeLabel, "ProcessCpuTime", IFormat.NANOSEC_FORMAT, true));
        list.add(new OverviewProperty(OverviewCategory.OperatingSystem, Messages.operationSystemNameLabel, "Name", false));
        list.add(new OverviewProperty(OverviewCategory.OperatingSystem, Messages.operationSystemVersionLabel, "Version", false));
        list.add(new OverviewProperty(OverviewCategory.OperatingSystem, Messages.operationSystemArchitectureLabel, "Arch", false));
        list.add(new OverviewProperty(OverviewCategory.OperatingSystem, Messages.avaliableProcessorsLabel, "AvailableProcessors", false));
        this.overviewProperties.put(OverviewCategory.OperatingSystem, list);
    }
}

